/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchActions;
import oracle.glcm.opatch.common.api.PatchAutomation;
import oracle.glcm.opatch.common.api.PatchChecksum;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.PatchType;
import oracle.glcm.opatch.common.api.SystemPatchBundle;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.impl.AbstractPatch;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchFactoryImpl;
import oracle.glcm.opatch.common.impl.SystemPatchBundleImpl;
import oracle.glcm.opatch.common.impl.bundle.Subpatch;
import oracle.glcm.opatch.common.impl.bundle.SystemPatchBundleXml;
import oracle.glcm.opatch.common.impl.bundle.SystemPatchBundleXmlType;
import oracle.glcm.opatch.common.impl.dao.PatchBundleDAO;

public class SystemPatch
extends AbstractPatch
implements Patch {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private List<String> subpatchDirs = new ArrayList<String>();
    private List<Patch> subpatchObjs = new ArrayList<Patch>();
    private String patchLocation = null;
    private PatchBundleDAO pbdao = null;
    private final PatchType type = PatchType.SYSTEM_PATCH;
    private String patchId = null;
    private String patchUpi = null;
    private String patchDesc = null;

    public void cloneMetadata(String destinationPatchLoc) throws PatchMetadataWritingException {
        if (this.subpatchObjs != null && this.subpatchObjs.size() > 0) {
            for (Patch p : this.subpatchObjs) {
                String patchID = p.getPatchId();
                p.cloneMetadata(destinationPatchLoc + Constants.PATH + patchID);
            }
            this.pbdao.saveToDir(destinationPatchLoc);
        }
    }

    public List<PatchInventory.Component> getComponents() {
        ArrayList<PatchInventory.Component> list = new ArrayList<PatchInventory.Component>();
        if (this.subpatchObjs == null) {
            return list;
        }
        HashSet hs = new HashSet();
        for (Patch p : this.subpatchObjs) {
            hs.addAll(p.getComponents());
        }
        list.addAll(hs);
        this.logger.info("Number of components:" + list.size());
        return list;
    }

    public List<PatchDeployArtifact> getPatchDeployArtifacts() {
        ArrayList<PatchDeployArtifact> result = new ArrayList<PatchDeployArtifact>();
        if (this.subpatchObjs == null) {
            return result;
        }
        for (Patch p : this.subpatchObjs) {
            result.addAll(p.getPatchDeployArtifacts());
        }
        this.logger.info("Number of patch deploy artifact:" + result.size());
        return result;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public String getPatchUpi() {
        return this.patchUpi;
    }

    public List<PatchInventory> getPatchInventories() {
        ArrayList<PatchInventory> result = new ArrayList<PatchInventory>();
        if (this.subpatchObjs == null) {
            return result;
        }
        for (Patch p : this.subpatchObjs) {
            result.addAll(p.getPatchInventories());
        }
        return result;
    }

    public PatchType getPatchType() {
        return this.type;
    }

    public PatchSubType getPatchSubType() {
        return null;
    }

    public List<Patch> getSubPatches() {
        if (this.subpatchObjs == null) {
            return new ArrayList<Patch>();
        }
        return this.subpatchObjs;
    }

    public String createHash() {
        SystemPatchBundleXml bundleObj = this.pbdao.getBundleObj();
        String function = bundleObj.getFvalue().getFunction();
        return this.calculateHash(function, this.patchLocation, this.subpatchObjs);
    }

    public boolean verifyHash() {
        SystemPatchBundleXml bundleObj = this.pbdao.getBundleObj();
        String function = bundleObj.getFvalue().getFunction();
        String hashValue = bundleObj.getFvalue().getValue();
        String calHashValue = this.calculateHash(function, this.patchLocation, this.subpatchObjs);
        this.logger.info("Hash from patch:" + hashValue);
        this.logger.info("Calculated hash:" + calHashValue);
        return hashValue.equals(calHashValue);
    }

    @Override
    protected AbstractPatch createPatch(String patchLocation) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        return new SystemPatch(patchLocation);
    }

    private SystemPatch() {
    }

    private SystemPatch(String patchLocation) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        this.patchLocation = patchLocation;
        this.getSubpatchDirs();
        this.createSubpatches();
    }

    private void getSubpatchDirs() throws PatchNotFoundException, PatchMetadataLoadingException {
        String bundleFile = this.patchLocation + Constants.PATH + Constants.BUNDLE_XML;
        File bFile = new File(bundleFile);
        if (!bFile.exists() || bFile.isDirectory()) {
            throw new PatchNotFoundException("bundle.xml file does not exist in patchlocation:" + this.patchLocation);
        }
        this.pbdao = new PatchBundleDAO(bundleFile);
        SystemPatchBundleXml bundleObj = this.pbdao.getBundleObj();
        if (bundleObj != null) {
            this.patchId = bundleObj.getPatchId();
            this.patchUpi = bundleObj.getUniquePatchId();
            this.patchDesc = bundleObj.getPatchAbstract();
            SystemPatchBundleXmlType.Subpatches subPatches = bundleObj.getSubpatches();
            if (subPatches != null) {
                this.subpatchDirs = new ArrayList<String>();
                List subpatchList = subPatches.getSubpatch();
                for (Subpatch sb : subpatchList) {
                    if (!sb.getPatchingTool().value().equalsIgnoreCase("OPATCH")) continue;
                    this.subpatchDirs.add(this.processSubPatchLoc(sb.getLocation()));
                }
            }
        }
    }

    private String processSubPatchLoc(String subPatchLoc) {
        Object result = null;
        StringTokenizer st1 = new StringTokenizer(this.patchLocation, File.separator);
        StringTokenizer st2 = new StringTokenizer(subPatchLoc = subPatchLoc.replace("\\", File.separator).replace("/", File.separator), File.separator);
        if (st2.countTokens() > 1) {
            String patchIdInSubpatchLoc = st2.nextToken();
            String patchIdInPatchLoc = null;
            while (st1.hasMoreElements()) {
                patchIdInPatchLoc = st1.nextToken();
            }
            if (patchIdInSubpatchLoc.equals(patchIdInPatchLoc)) {
                return this.patchLocation + Constants.PATH + subPatchLoc.substring(patchIdInSubpatchLoc.length() + 1);
            }
        }
        return this.patchLocation + Constants.PATH + subPatchLoc;
    }

    private void createSubpatches() throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        if (this.subpatchDirs != null) {
            this.subpatchObjs = new ArrayList<Patch>();
            PatchFactoryImpl patchFac = new PatchFactoryImpl();
            for (String subDir : this.subpatchDirs) {
                this.subpatchObjs.add(patchFac.createPatch(subDir));
            }
        }
    }

    public String getPatchDescription() {
        return this.patchDesc;
    }

    public List<PatchActions> getActions() {
        ArrayList<PatchActions> result = new ArrayList<PatchActions>();
        if (this.subpatchObjs == null) {
            return result;
        }
        for (Patch p : this.subpatchObjs) {
            result.addAll(p.getActions());
        }
        return result;
    }

    public List<PatchChecksum> getChecksums() {
        ArrayList<PatchChecksum> result = new ArrayList<PatchChecksum>();
        if (this.subpatchObjs == null) {
            return result;
        }
        for (Patch p : this.subpatchObjs) {
            result.addAll(p.getChecksums());
        }
        return result;
    }

    public List<MaintenanceAliasActionHolder> getMaintenanceAliasActionHolders() {
        ArrayList<MaintenanceAliasActionHolder> result = new ArrayList<MaintenanceAliasActionHolder>();
        if (this.subpatchObjs == null) {
            return result;
        }
        for (Patch p : this.subpatchObjs) {
            result.addAll(p.getMaintenanceAliasActionHolders());
        }
        return result;
    }

    public List<PatchAutomation> getAutomations() {
        ArrayList<PatchAutomation> result = new ArrayList<PatchAutomation>();
        if (this.subpatchObjs == null) {
            return result;
        }
        for (Patch p : this.subpatchObjs) {
            result.addAll(p.getAutomations());
        }
        return result;
    }

    public List<String> getOrderedSubPatchId() {
        this.logger.info("Not applicable method for this object");
        return null;
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    public SystemPatchBundle getSystemPatchBundle() {
        return new SystemPatchBundleImpl(this.pbdao);
    }

    static {
        new PatchFactoryImpl().registerPatch(PatchType.SYSTEM_PATCH, new SystemPatch());
    }
}

