/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.DomainConfigInventory;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchFastInstall;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.api.PatchType;
import oracle.glcm.opatch.common.api.SystemPatchZip;
import oracle.glcm.opatch.common.impl.AbstractPatch;
import oracle.glcm.opatch.common.impl.ComponentCheckResultImpl;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.DomainConfigInventoryImpl;
import oracle.glcm.opatch.common.impl.PatchCheckResultsImpl;
import oracle.glcm.opatch.common.impl.PatchConfigInventoryImpl;
import oracle.glcm.opatch.common.impl.PatchDeployArtifactImpl;
import oracle.glcm.opatch.common.impl.PatchFastInstallImpl;
import oracle.glcm.opatch.common.impl.SystemPatchZipImpl;

public class PatchFactoryImpl
extends BasePatchFactory {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static HashMap<PatchType, AbstractPatch> _mRegisteredPatches = new HashMap();
    private static HashMap<String, DomainConfigInventory> domainConfigInventories = new HashMap();

    public PatchFactoryImpl() {
        try {
            Class.forName("oracle.glcm.opatch.common.impl.SingletonPatch");
            Class.forName("oracle.glcm.opatch.common.impl.CompositePatch");
            Class.forName("oracle.glcm.opatch.common.impl.SystemPatch");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load patch classes", e);
        }
    }

    protected void registerPatch(PatchType patchType, AbstractPatch aPatch) {
        this.logger.info("Registering:" + patchType + ":" + aPatch.getClass().getName());
        _mRegisteredPatches.put(patchType, aPatch);
    }

    public Patch createPatch(String patchLocation) throws PatchNotFoundException, PatchMetadataLoadingException, InvalidPatchMetadataException {
        PatchType type = this.getType(patchLocation);
        if (type == PatchType.UNKNOWN_PATCH) {
            throw new PatchNotFoundException("The patch type is invalid in patch location: " + patchLocation);
        }
        this.logger.info("Patch type found: " + type);
        AbstractPatch patchObj = _mRegisteredPatches.get(type);
        if (patchObj != null) {
            return (Patch)patchObj.createPatch(patchLocation);
        }
        throw new IllegalStateException("Patch type " + type + " has not been registered");
    }

    private PatchType getType(String patchLocation) {
        if (this.isSingletonPatch(patchLocation)) {
            return PatchType.SINGLETON_PATCH;
        }
        if (this.isCompositePatch(patchLocation)) {
            return PatchType.COMPOSITE_PATCH;
        }
        if (this.isSystemPatch(patchLocation)) {
            return PatchType.SYSTEM_PATCH;
        }
        return PatchType.UNKNOWN_PATCH;
    }

    private boolean isSingletonPatch(String patchLocation) {
        Path file = NioServiceFactory.getNioService().getPath(patchLocation, new String[0]).resolve(Constants.INVENTORY_XML);
        if (Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
            this.logger.info("Singleton  patch is found");
            return true;
        }
        this.logger.info("Singleton  patch not found");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCompositePatch(String patchLocation) {
        Path patchLoc = NioServiceFactory.getNioService().getPath(patchLocation, new String[0]);
        if (!Files.isDirectory(patchLoc, new LinkOption[0])) {
            this.logger.info("Composite patch NOT found");
            return false;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(patchLoc);){
            for (Path subdir : directoryStream) {
                Path subpatchLoc = patchLoc.resolve(subdir);
                Path file = subpatchLoc.resolve(Constants.COMPOSITE_XML);
                if (!Files.exists(file, new LinkOption[0]) || Files.isDirectory(file, new LinkOption[0])) continue;
                this.logger.info("Composite patch is found");
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ex) {
            this.logger.warning(ex.getMessage());
        }
        this.logger.info("Composite patch NOT found");
        return false;
    }

    private boolean isSystemPatch(String patchLocation) {
        Path file = NioServiceFactory.getNioService().getPath(patchLocation, new String[0]).resolve(Constants.BUNDLE_XML);
        if (Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
            this.logger.info("System patch is found");
            return true;
        }
        this.logger.info("System patch NOT found");
        return false;
    }

    public PatchDeployArtifact createPatchDeployArtifact() throws PatchMetadataLoadingException {
        return new PatchDeployArtifactImpl();
    }

    public PatchConfigInventoryImpl createPatchConfigInventory(String instanceDir) throws FileNotFoundException, DomainInventoryLoadingException {
        PatchConfigInventoryImpl obj = new PatchConfigInventoryImpl(instanceDir);
        return obj;
    }

    public SystemPatchZip createSystemPatchZip(InputStream is) throws IOException, PatchMetadataLoadingException {
        return new SystemPatchZipImpl(is);
    }

    public synchronized DomainConfigInventory getDomainConfigInventory(String domainDirectoryDir) throws FileNotFoundException, DomainInventoryLoadingException, DomainInventoryUpdatingException {
        DomainConfigInventory domainConfigInventory = domainConfigInventories.get(domainDirectoryDir);
        if (domainConfigInventory == null) {
            domainConfigInventory = new DomainConfigInventoryImpl(domainDirectoryDir);
            domainConfigInventories.put(domainDirectoryDir, domainConfigInventory);
        }
        return domainConfigInventory;
    }

    public ComponentCheckResult createComponentCheckResult(PatchInventory.Component component) {
        return new ComponentCheckResultImpl(component);
    }

    public PatchCheckResults getPatchCheckResults(Patch patch) {
        return new PatchCheckResultsImpl(patch);
    }

    public PatchFastInstall getPatchFastInstallInstance() {
        return PatchFastInstallImpl.getInstance();
    }
}

