/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchChecksum;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.dao.PatchChecksumDAO;

public class PatchChecksumImpl
implements PatchChecksum {
    private PatchChecksumDAO pcsdao = null;

    public PatchChecksumImpl() {
    }

    public PatchChecksumImpl(String actionsLoc) throws PatchMetadataLoadingException {
        this.pcsdao = new PatchChecksumDAO(actionsLoc);
    }

    protected void saveToDir(String destinationPatchLoc) throws PatchMetadataWritingException {
        Path dir = NioServiceFactory.getNioService().getPath(destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchMetadataWritingException("Cannot create directory " + dir + " for cloning patch checksum.xml", (Throwable)e);
            }
        }
        if (!Files.exists(dir, new LinkOption[0]) || Files.isRegularFile(dir, new LinkOption[0])) {
            throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning patch checksum.xml");
        }
        String checksumFile = destinationPatchLoc + Constants.PATH + Constants.CHECKSUM_XML;
        this.pcsdao.save(checksumFile);
    }

    public List<PatchChecksum.File> getFiles() {
        return this.pcsdao.getFiles();
    }

    public class FileImpl
    implements PatchChecksum.File {
        private String path = null;
        private String checksum = null;
        private String appDir = null;

        public FileImpl(String path, String checksum, String appDir) {
            this.path = path;
            this.checksum = checksum;
            this.appDir = appDir;
        }

        public String getPath() {
            return this.path;
        }

        public String getCheckSum() {
            return this.checksum;
        }

        public String getAppDir() {
            return this.appDir;
        }
    }
}

