/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.helpers;

import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasType;
import com.oracle.xmlns.cie.glcm.patch.mai.MappingType;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.alias.MaintenanceAlias;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasBuilderFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasInventory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasService;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.alias.MaintenanceAliasBuilderFactoryImpl;
import oracle.glcm.opatch.common.impl.alias.MaintenanceAliasImpl;
import oracle.glcm.opatch.common.impl.alias.MaintenanceAliasInventoryImpl;
import oracle.glcm.opatch.common.impl.alias.MaintenanceAliasServiceImpl;
import oracle.glcm.opatch.common.impl.dao.MaintenanceAliasInfoDAO;

public class MaintenanceAliasInfoHelper {
    private static final Logger _logger = Logger.getLogger(MaintenanceAliasInfoHelper.class.getName());
    public static final String MAINTENANCE_ALIAS_INFO_FILE_NAME = "maintenance-alias-info.xml";
    public static final String MAINTENANCE_ALIAS_INFO_LOC = "inventory" + Constants.PATH + "maintenance-alias-info" + Constants.PATH + "maintenance-alias-info.xml";
    private static MaintenanceAliasInfoHelper _instance;

    public static MaintenanceAliasInfoHelper getInstance() {
        if (_instance == null) {
            _instance = new MaintenanceAliasInfoHelper();
        }
        return _instance;
    }

    public String getMaintenanceAliasInfoPath(String oracleHome) {
        return oracleHome + Constants.PATH + MAINTENANCE_ALIAS_INFO_LOC;
    }

    public void validatesMaintenanceAliases(MaintenanceAliasInfoDAO info) throws MaintenanceAliasException {
        HashSet<String> mKeys = new HashSet<String>();
        for (MappingType mapping : info.getMappings()) {
            if (mKeys.contains(mapping.getMaintenanceAliasKey())) {
                throw new MaintenanceAliasException("Duplicated maintenance alias key found.");
            }
            mKeys.add(mapping.getMaintenanceAliasKey());
        }
        for (MaintenanceAliasType alias : info.getAliases()) {
            if (mKeys.contains(alias.getMaintenanceAliasKey())) continue;
            _logger.log(Level.WARNING, "The alias key " + alias.getMaintenanceAliasKey() + " doesn't correspond to any mapping.");
        }
    }

    public void validatesMaintenanceAliases(String oracleHome, MaintenanceAlias maintenanceAlias) throws MaintenanceAliasException {
        MaintenanceAliasInfoDAO info = this.getMaintenanceAliasInfoDAO(oracleHome);
        this.validatesMaintenanceAliases(info, maintenanceAlias);
    }

    public void validatesMaintenanceAliases(MaintenanceAliasInfoDAO info, MaintenanceAlias maintenanceAlias) throws MaintenanceAliasException {
        if (maintenanceAlias == null) {
            throw new MaintenanceAliasException("The maintenance alias can not be null.");
        }
        if (maintenanceAlias.getMaintenanceAliasKey() == null) {
            throw new MaintenanceAliasException("The maintenance alias key can not be null.");
        }
        if (maintenanceAlias.getProduct() == null) {
            throw new MaintenanceAliasException("The product can not be null.");
        }
        if (maintenanceAlias.getPatchType() == null) {
            throw new MaintenanceAliasException("The patch type can not be null.");
        }
        if (maintenanceAlias.getProductFamily() == null) {
            throw new MaintenanceAliasException("The product family can not be null.");
        }
        HashSet<String> mKeys = new HashSet<String>();
        for (MappingType mapping : info.getMappings()) {
            if (mKeys.contains(mapping.getMaintenanceAliasKey())) {
                throw new MaintenanceAliasException("Duplicated maintenance alias key found.");
            }
            mKeys.add(mapping.getMaintenanceAliasKey());
        }
        if (mKeys.contains(maintenanceAlias.getMaintenanceAliasKey())) {
            throw new MaintenanceAliasException("Duplicated maintenance alias key found: " + maintenanceAlias.getMaintenanceAliasKey());
        }
        MaintenanceAliasImpl aliasImpl = (MaintenanceAliasImpl)maintenanceAlias;
        for (MaintenanceAliasType alias : info.getAliases()) {
            if (mKeys.contains(alias.getMaintenanceAliasKey())) continue;
            _logger.log(Level.WARNING, "The alias key of " + alias.getProduct() + " doesn't correspong to any mapping.");
        }
        if (aliasImpl.getMapping() == null || aliasImpl.getMapping().isEmpty()) {
            throw new MaintenanceAliasException("The mainteinance alias: " + maintenanceAlias.getMaintenanceAliasKey() + " does not contain mappings.");
        }
    }

    public MaintenanceAliasInfoDAO getMaintenanceAliasInfoDAO(String oracleHome) throws MaintenanceAliasException {
        MaintenanceAliasInfoDAO dao = null;
        try {
            dao = new MaintenanceAliasInfoDAO(this.getMaintenanceAliasInfoPath(oracleHome), true);
        }
        catch (MaintenanceAliasException e) {
            throw new MaintenanceAliasException("Problem loading or parsing maintenance alias info file. ", (Throwable)e);
        }
        return dao;
    }

    public MaintenanceAliasInfoDAO initMaintenanceAliasInfoFile(String oracleHome) throws MaintenanceAliasException {
        MaintenanceAliasInfoDAO dao = null;
        try {
            dao = new MaintenanceAliasInfoDAO(this.getMaintenanceAliasInfoPath(oracleHome), false);
            dao.saveToFile();
        }
        catch (MaintenanceAliasException e) {
            throw new MaintenanceAliasException("Problem loading or parsing maintenance alias info file. ", (Throwable)e);
        }
        return dao;
    }

    public MaintenanceAliasBuilderFactory getMaintenanceAliasBuilderFactory() {
        return new MaintenanceAliasBuilderFactoryImpl();
    }

    public MaintenanceAliasService getMaintenanceAliasService(String oracleHome) throws MaintenanceAliasException {
        return new MaintenanceAliasServiceImpl(oracleHome);
    }

    public MaintenanceAliasInventory getMaintenanceAliasInventory(String oracleHome) throws MaintenanceAliasException {
        return new MaintenanceAliasInventoryImpl(oracleHome);
    }
}

