/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.diagnostic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.diagnostic.DiagnosticException;

public class Task {
    protected final Logger s_log = Logger.getLogger(this.getClass().getName());
    protected static final String[] binaryPaths = new String[]{"/usr/bin/", "/bin/", "/usr/sbin/", "/sbin/"};

    protected static String searchBinary(String binary) throws DiagnosticException {
        boolean found = false;
        String parent = "";
        for (String path : binaryPaths) {
            Path parentPath = Paths.get(path, binary);
            if (!Files.exists(parentPath, new LinkOption[0])) continue;
            found = true;
            parent = path;
            break;
        }
        if (!found) {
            throw new DiagnosticException("Missing command: " + binary);
        }
        return parent;
    }

    protected ExecReturn runCommand(String command) {
        return this.runCommand(new String[]{command});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecReturn runCommand(String[] commands) {
        this.s_log.info(String.format("Run CMD: %s", Arrays.toString(commands)));
        ExecReturn exeReturn = new ExecReturn(commands);
        int retValue = -1;
        String errMsg = "";
        String normalMsg = "";
        Process process = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            process = commands.length == 1 ? runtime.exec(commands[0]) : runtime.exec(commands);
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread errThread = new ReaderThread(errorStream);
            ReaderThread inputThread = new ReaderThread(inputStream);
            errThread.start();
            inputThread.start();
            retValue = process.waitFor();
            try {
                errThread.join();
                inputThread.join();
                errMsg = errThread.outputString;
                normalMsg = inputThread.outputString;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.s_log.info(String.format("Return code: %s", retValue));
        }
        catch (IOException e) {
            errMsg = errMsg + e.getMessage();
            this.s_log.warning(errMsg);
        }
        catch (InterruptedException e) {
            errMsg = errMsg + e.getMessage();
            this.s_log.warning(errMsg);
        }
        finally {
            try {
                if (process != null) {
                    process.getErrorStream().close();
                    process.getInputStream().close();
                }
            }
            catch (IOException e) {
                this.s_log.warning(e.getMessage());
            }
        }
        exeReturn.setErrorMessage(errMsg);
        exeReturn.setNormalMessage(normalMsg);
        exeReturn.setReturnCode(retValue);
        return exeReturn;
    }

    public static class ExecReturn {
        String[] systemCommand;
        String errorMessage;
        String normalMessage;
        int retCode;
        boolean ok;

        public ExecReturn(String[] cmd) {
            this.systemCommand = cmd;
            this.errorMessage = "";
            this.normalMessage = "";
            this.retCode = 0;
            this.ok = true;
        }

        public String getCommand() {
            if (this.systemCommand != null) {
                StringBuffer cmd = new StringBuffer();
                for (int i = 0; i < this.systemCommand.length; ++i) {
                    cmd.append(this.systemCommand[i]);
                    cmd.append("\n");
                }
                return cmd.toString();
            }
            return "Command not intialized";
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getNormalMessage() {
            return this.normalMessage;
        }

        public int getReturnCode() {
            return this.retCode;
        }

        public boolean isOK() {
            return this.ok;
        }

        protected void setErrorMessage(String msg) {
            this.errorMessage = msg;
        }

        protected void setNormalMessage(String msg) {
            this.normalMessage = msg;
        }

        protected void setReturnCode(int c) {
            this.retCode = c;
            this.ok = this.retCode == 0;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("[SystemCall.ExecReturn: ");
            buff.append("systemCommand= (");
            if (this.systemCommand == null) {
                buff.append("null");
            } else {
                for (int i = 0; i < this.systemCommand.length; ++i) {
                    String cmd = this.systemCommand[i];
                    if (cmd == null) continue;
                    buff.append("\"");
                    buff.append(cmd);
                    buff.append("\"");
                    if (i == this.systemCommand.length - 1) continue;
                    buff.append(", ");
                }
                buff.append(")");
            }
            buff.append(", errMsg= ");
            buff.append(this.errorMessage);
            buff.append(", normalMsg= ");
            buff.append(this.normalMessage);
            buff.append(", return code= ");
            buff.append(this.retCode);
            buff.append(", exec. ok= ");
            buff.append(this.ok);
            buff.append("]");
            return buff.toString();
        }
    }

    class ReaderThread
    extends Thread {
        private InputStreamReader isr;
        public String outputString;

        public ReaderThread(InputStreamReader isr) {
            this.isr = isr;
        }

        private String readStream(InputStreamReader inputStream) {
            BufferedReader br = new BufferedReader(inputStream);
            StringBuffer sb = new StringBuffer();
            String line = "";
            try {
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            catch (IOException e) {
                Task.this.s_log.warning(e.getMessage());
            }
            this.outputString = sb.toString();
            return this.outputString;
        }

        @Override
        public void run() {
            this.readStream(this.isr);
        }
    }
}

