/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.diagnostic;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.diagnostic.AsyncTask;

public class Executor<V> {
    private static Executor<?> instance;
    private ExecutorService executor;
    private final long _PERIOD = 10L;
    private final long _TIME_OUT = 1200L;
    private final TimeUnit _TIME_UNIT = TimeUnit.SECONDS;
    private List<Future<V>> runningJobs;
    protected final Logger s_log = Logger.getLogger(this.getClass().getName());

    public static Executor<?> getInstance() {
        if (instance == null) {
            System.setProperty("java.util.logging.manager", MyLogManager.class.getName());
            instance = new Executor();
        }
        return instance;
    }

    private Executor() {
        this.executor = Executors.newFixedThreadPool(5, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.runningJobs = new ArrayList<Future<V>>();
        this.startTimer();
    }

    public void execute(AsyncTask<V> task) {
        this.runningJobs.add(this.executor.submit(task));
    }

    public boolean isDone() {
        for (Future<V> job : this.runningJobs) {
            if (job.isDone()) continue;
            return false;
        }
        return true;
    }

    private void startTimer() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long costTime = 0L;
                try {
                    while (true) {
                        if (Executor.this.isDone()) {
                            Executor.this.s_log.info("Diag process completed in:  " + costTime + " sec.");
                            Executor.this.executor.shutdown();
                            instance = null;
                            break;
                        }
                        if (costTime >= 1200L) {
                            Executor.this.s_log.warning("Time out for diagnostic process: " + costTime + " sec, force quit.");
                            Executor.this.executor.shutdownNow();
                            instance = null;
                            break;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Executor.this.s_log.info("rescan if diag process completed after " + (costTime += 10L) + " sec.");
                    }
                }
                finally {
                    MyLogManager.resetFinally();
                }
            }
        }));
    }

    public static class MyLogManager
    extends LogManager {
        static MyLogManager instance;

        public MyLogManager() {
            instance = this;
        }

        @Override
        public void reset() {
        }

        private void reset0() {
            super.reset();
        }

        public static void resetFinally() {
            if (instance != null) {
                instance.reset0();
            }
        }
    }
}

