/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.common.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import oracle.glcm.common.nio.FileSystemHandler;
import oracle.glcm.common.nio.FileSystemType;
import oracle.glcm.repo.nio.ChecksumCopyOption;
import oracle.glcm.repo.nio.RepoFileSystemProvider;
import oracle.glcm.repo.nio.RepoPath;

public class CasFileSystemHandler
implements FileSystemHandler {
    private static final String SCHEME = "cas";
    private RepoFileSystemProvider _repoFileSystemProvider;

    public CasFileSystemHandler() {
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!SCHEME.equalsIgnoreCase(fileSystemProvider.getScheme())) continue;
            if (!(fileSystemProvider instanceof RepoFileSystemProvider)) break;
            this._repoFileSystemProvider = (RepoFileSystemProvider)fileSystemProvider;
            break;
        }
        if (this._repoFileSystemProvider == null) {
            throw new IllegalStateException("Unable to locate installed file system provider: " + RepoFileSystemProvider.class);
        }
    }

    @Override
    public FileSystemType getType() {
        return FileSystemType.Cas;
    }

    @Override
    public String getScheme() {
        return this._repoFileSystemProvider.getScheme();
    }

    @Override
    public FileSystem getFileSystemForPath(Path path) {
        if (path == null) {
            throw new NullPointerException("The path provided was null.");
        }
        return this._repoFileSystemProvider.getFileSystem(path.toUri());
    }

    @Override
    public Path getInternalPath(Path path) {
        if (path instanceof RepoPath) {
            return ((RepoPath)path).toInternalPath();
        }
        return path;
    }

    @Override
    public void newFileSystem(Path fileSystemPath) throws IOException {
        this.newFileSystem(fileSystemPath, null);
    }

    @Override
    public void newFileSystem(Path fileSystemPath, Map<String, Object> env) throws IOException {
        Object repoPathObj;
        if (env == null) {
            env = new HashMap<String, Object>();
        }
        if ((repoPathObj = env.get("FILE_SYSTEM_REPO_PATH")) == null) {
            env.put("FILE_SYSTEM_REPO_PATH", fileSystemPath.resolve(".cas").toString());
        }
        this._repoFileSystemProvider.newFileSystem(fileSystemPath.toUri(), env);
    }

    @Override
    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException {
        return this._repoFileSystemProvider.copy(in, target, options);
    }

    @Override
    public CopyOption getChecksumCopyOption(String checksum) {
        if (checksum != null && !checksum.trim().isEmpty()) {
            return new ChecksumCopyOption(checksum);
        }
        return null;
    }
}

