/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.common.inventory.utils;

import java.util.List;

public class StringUtil {
    private static final String EMPTY_STR = "";
    private static final String KEYSEP = "_";

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }

    public static String getString(List<String> strs) {
        return StringUtil.getString(strs, KEYSEP);
    }

    public static String getString(List<String> strs, String separator) {
        String retVal = EMPTY_STR;
        if (strs != null && !strs.isEmpty()) {
            if (separator == null) {
                separator = KEYSEP;
            }
            for (String str : strs) {
                if (StringUtil.isNullOrEmpty(str)) continue;
                retVal = retVal + separator + str;
            }
            retVal = retVal.replaceFirst(separator, EMPTY_STR);
        }
        return retVal;
    }
}

