/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.zip.ZipInputStream;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.opatchsdk.patchrepresentation.InvalidPatchPackageException;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchCompositeVariant;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchEXABundleVariant;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchEngineeredSystemVariant;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchGIBundleVariant;
import oracle.opatch.opatchsdk.patchrepresentation.OPatchSingletonVariant;
import oracle.opatch.opatchsdk.patchrepresentation.PatchVariant;
import oracle.opatch.patchsdk.OPatchBundlePatch;
import oracle.opatch.patchsdk.OPatchBundlePatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchCompositePatch;
import oracle.opatch.patchsdk.OPatchCompositePatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchEngineeredSystemPatch;
import oracle.opatch.patchsdk.OPatchEngineeredSystemPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchSingletonPatch;
import oracle.opatch.patchsdk.OPatchSingletonPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchZipStreamMapConstructor;
import oracle.opatch.patchsdk.PatchFactory;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.PatchValidatorAndGenerator;
import oracle.opatch.patchsdk.ZipStreamMapConstructor;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;

public class OPatchPatchFactory {
    public static PatchVariant getPatchInstance(String patchLocation) throws PatchPackageException, InvalidPatchPackageException {
        try {
            OPatchUtils.disableConsoleOutput();
            PatchFactory pf = new PatchFactory(false);
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchEngineeredSystemPatchValidatorAndGenerator());
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchCompositePatchValidatorAndGenerator());
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
            PatchPackage instance = pf.getInstance(patchLocation);
            if (instance instanceof OPatchSingletonPatch) {
                OPatchSingletonVariant oPatchSingletonVariant = new OPatchSingletonVariant(instance);
                return oPatchSingletonVariant;
            }
            if (instance instanceof OPatchEngineeredSystemPatch) {
                OPatchEngineeredSystemVariant oPatchEngineeredSystemVariant = new OPatchEngineeredSystemVariant(instance);
                return oPatchEngineeredSystemVariant;
            }
            if (instance instanceof OPatchCompositePatch) {
                OPatchCompositeVariant oPatchCompositeVariant = new OPatchCompositeVariant(instance);
                return oPatchCompositeVariant;
            }
            if (instance instanceof OPatchBundlePatch) {
                String bundlePatchType = ((OPatchBundlePatch)instance).getBundlePatchType();
                if (bundlePatchType.equals("GI_BUNDLE")) {
                    OPatchGIBundleVariant oPatchGIBundleVariant = new OPatchGIBundleVariant(instance);
                    return oPatchGIBundleVariant;
                }
                if (bundlePatchType.equals("EXA_BUNDLE")) {
                    OPatchEXABundleVariant oPatchEXABundleVariant = new OPatchEXABundleVariant(instance);
                    return oPatchEXABundleVariant;
                }
            }
        }
        catch (PatchPackageException ex) {
            throw ex;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
        return null;
    }

    public static PatchVariant getPatchInstance(ZipInputStream zStream) throws PatchPackageException, InvalidPatchPackageException {
        try {
            OPatchUtils.disableConsoleOutput();
            PatchFactory pf = new PatchFactory(false);
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchCompositePatchValidatorAndGenerator());
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchEngineeredSystemPatchValidatorAndGenerator());
            pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
            pf.addZipStreamMapConstructor((ZipStreamMapConstructor)new OPatchZipStreamMapConstructor());
            PatchPackage instance = pf.getInstance(zStream);
            if (instance instanceof OPatchSingletonPatch) {
                OPatchSingletonVariant oPatchSingletonVariant = new OPatchSingletonVariant(instance);
                return oPatchSingletonVariant;
            }
            if (instance instanceof OPatchCompositePatch) {
                OPatchCompositeVariant oPatchCompositeVariant = new OPatchCompositeVariant(instance);
                return oPatchCompositeVariant;
            }
            if (instance instanceof OPatchEngineeredSystemPatch) {
                OPatchEngineeredSystemVariant oPatchEngineeredSystemVariant = new OPatchEngineeredSystemVariant(instance);
                return oPatchEngineeredSystemVariant;
            }
            if (instance instanceof OPatchBundlePatch) {
                String bundlePatchType = ((OPatchBundlePatch)instance).getBundlePatchType();
                if (bundlePatchType.equals("GI_BUNDLE")) {
                    OPatchGIBundleVariant oPatchGIBundleVariant = new OPatchGIBundleVariant(instance);
                    return oPatchGIBundleVariant;
                }
                if (bundlePatchType.equals("EXA_BUNDLE")) {
                    OPatchEXABundleVariant oPatchEXABundleVariant = new OPatchEXABundleVariant(instance);
                    return oPatchEXABundleVariant;
                }
            }
        }
        catch (PatchPackageException ex) {
            throw ex;
        }
        finally {
            OPatchUtils.enableConsoleOutput();
        }
        return null;
    }
}

