/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.opatch.Bug;
import oracle.opatch.CompareInventorySession;
import oracle.opatch.opatchsdk.OPatchBug;

public class OPatchCompareInventoryOutput {
    ArrayList<OPatchBug> bugsInSrcNotDest;
    ArrayList<OPatchBug> bugsInDestNotSrc;
    ArrayList<OPatchBug> bugsInSrcAndDest;
    HashMap<String, ArrayList<String>> bugMap;

    private OPatchCompareInventoryOutput() {
    }

    protected OPatchCompareInventoryOutput(CompareInventorySession.CompareOutput output) {
        this.bugsInSrcNotDest = OPatchCompareInventoryOutput.convertBugToOPatchBug(output.getBugsInSrcNotDest());
        this.bugsInDestNotSrc = OPatchCompareInventoryOutput.convertBugToOPatchBug(output.getBugsInDestNotSrc());
        this.bugsInSrcAndDest = OPatchCompareInventoryOutput.convertBugToOPatchBug(output.getBugsInSrcAndDest());
        this.bugMap = output.getBugMap();
    }

    private static ArrayList<OPatchBug> convertBugToOPatchBug(ArrayList<Bug> bugs) {
        ArrayList<OPatchBug> opatchBugs = new ArrayList<OPatchBug>();
        for (int i = 0; i < bugs.size(); ++i) {
            opatchBugs.add(new OPatchBug(bugs.get(i)));
        }
        return opatchBugs;
    }

    public ArrayList<OPatchBug> getBugsInSrcNotDest() {
        return this.bugsInSrcNotDest;
    }

    public ArrayList<OPatchBug> getBugsInDestNotSrc() {
        return this.bugsInDestNotSrc;
    }

    public ArrayList<OPatchBug> getBugsInSrcAndDest() {
        return this.bugsInSrcAndDest;
    }

    public ArrayList<String> getPatchIDsThatFixBug(String bugID) {
        if (this.bugMap.containsKey(bugID)) {
            return this.bugMap.get(bugID);
        }
        return new ArrayList<String>();
    }

    private String printBugs(ArrayList<OPatchBug> bugs) {
        StringBuffer buff = new StringBuffer("");
        for (int i = 0; i < bugs.size(); ++i) {
            OPatchBug currentBug = bugs.get(i);
            buff.append(currentBug + ", patches=" + this.getPatchIDsThatFixBug(currentBug.getBugID()) + ";");
        }
        return buff.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[OPatchCompareInventoryOutput: ");
        buff.append("bugsInSrcNotDest= ");
        buff.append(this.printBugs(this.bugsInSrcNotDest));
        buff.append("\n\nbugsInDestNotSrc= ");
        buff.append(this.printBugs(this.bugsInDestNotSrc));
        buff.append("\n\nbugsInSrcAndDest= ");
        buff.append(this.printBugs(this.bugsInSrcAndDest));
        return buff.toString();
    }
}

