/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.protocol;

import oracle.security.xmlsec.saml2.protocol.RequestedAuthnContext;
import oracle.security.xmlsec.saml2.protocol.SubjectQuery;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthnQuery
extends SubjectQuery {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:protocol"};
    private static final String[] tagList = new String[]{"Issuer", "Signature", "Extensions", "Subject", "RequestedAuthnContext"};

    public AuthnQuery(Element element) throws DOMException {
        super(element);
    }

    public AuthnQuery(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnQuery(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:protocol", "AuthnQuery");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    protected AuthnQuery(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void setRequestedAuthnContext(RequestedAuthnContext ctx) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"RequestedAuthnContext");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)ctx, (String[])nsList, (String[])tagList);
    }

    public RequestedAuthnContext getRequestedAuthnContext() {
        return (RequestedAuthnContext)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "RequestedAuthnContext");
    }

    public void setSessionIndex(String index) {
        this.setAttribute("SessionIndex", index);
    }

    public String getSessionIndex() {
        if (this.hasAttribute("SessionIndex")) {
            return this.getAttribute("SessionIndex");
        }
        return null;
    }

    static {
        SAML2Initializer.initialize();
    }
}

