/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.rest.Checksum;
import com.oracle.cie.rest.FileInfo;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.wadl.provider.ChecksumImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.storage.FileInfo+json"})
public class StorageFileInfo
implements MessageBodyReader<FileInfo> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.storage.FileInfo+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public FileInfo readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        FileInfoImpl fileInfo = (FileInfoImpl)mapper.readValue(baos.toByteArray(), FileInfoImpl.class);
        return fileInfo;
    }

    public static class FileInfoImpl
    extends HashMap
    implements FileInfo {
        private Repository _repository;

        @Override
        public long getSize() {
            Object o = this.get("size");
            if (o != null) {
                if (o instanceof Number) {
                    return ((Number)o).longValue();
                }
                String s = o.toString();
                if (!s.isEmpty()) {
                    return Long.parseLong(s);
                }
            }
            return 0L;
        }

        @Override
        public Checksum getChecksum() {
            return ChecksumImpl.parse(this);
        }

        @Override
        public Repository getRepository() {
            return this._repository;
        }

        @Override
        public void setRepository(Repository repository) {
            this._repository = repository;
        }

        @Override
        public String getDownloadUri() {
            Object o = this.get("downloadUri");
            return o != null ? o.toString() : null;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("downloadURI:").append(this.getDownloadUri());
            buf.append(", size:").append(this.getSize());
            buf.append(", ").append(this.getChecksum());
            return buf.toString();
        }
    }
}

