/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.rest.CopyOrMoveResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.storage.CopyOrMoveResult+json"})
public class StorageCopyOrMoveResult
implements MessageBodyReader<CopyOrMoveResult> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.storage.CopyOrMoveResult+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public CopyOrMoveResult readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (CopyOrMoveResult)mapper.readValue(baos.toByteArray(), CopyOrMoveResultImpl.class);
    }

    public static class CopyOrMoveResultImpl
    extends HashMap
    implements CopyOrMoveResult {
        @Override
        public List<CopyOrMoveResult.Message> getMessages() {
            ArrayList<CopyOrMoveResult.Message> messages = new ArrayList<CopyOrMoveResult.Message>();
            List msgs = (List)this.get("messages");
            if (msgs != null) {
                for (Map m : msgs) {
                    String level = (String)m.get("level");
                    String message = (String)m.get("message");
                    messages.add(new MessageImpl(level, message));
                }
            }
            return messages;
        }

        @Override
        public String toString() {
            return "" + this.getMessages();
        }

        public class MessageImpl
        implements CopyOrMoveResult.Message {
            private String _level;
            private String _message;

            public MessageImpl(String level, String message) {
                this._level = level;
                this._message = message;
            }

            @Override
            public String getLevel() {
                return this._level;
            }

            @Override
            public String getMessage() {
                return this._message;
            }

            public String toString() {
                return this.getLevel() + " : " + this.getMessage();
            }
        }
    }
}

