/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import javax.ws.rs.core.UriBuilder;

public abstract class RestQuery {
    private UriBuilder _uri;

    public RestQuery(String schema, String host, String queryPath) {
        this._uri = UriBuilder.fromPath((String)queryPath);
        this._uri.host(host);
        this._uri.scheme(schema);
    }

    public String toString() {
        return this._uri.build(new Object[0]).toString();
    }

    public void addParameter(String keyParameter, String value) {
        this._uri.queryParam(keyParameter, new Object[]{value});
    }

    public void addRawPath(String rawPath, boolean addIncreaseExistingPath) {
        String[] pathAndQuery = rawPath.split("\\?");
        if (pathAndQuery.length > 0) {
            String path = pathAndQuery[0];
            if (addIncreaseExistingPath) {
                String[] paths = path.split("\\/");
                this._uri.segment(paths);
            } else {
                this._uri.replacePath(path);
            }
            if (pathAndQuery.length > 1) {
                String query = pathAndQuery[1];
                this._uri.replaceQuery(query);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestQuery that = (RestQuery)o;
        return this._uri.build(new Object[0]).toString().equals(that._uri.build(new Object[0]).toString());
    }

    public int hashCode() {
        int result = 0;
        result = this.toString().hashCode() / 11;
        return result;
    }
}

