/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest;

import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.RestHandlerConfig;
import com.oracle.cie.rest.RestHandlerType;
import com.oracle.cie.rest.RestHelper;
import com.oracle.cie.rest.impl.ArtifactoryRestHandlerConfigImpl;
import com.oracle.cie.rest.impl.ArtifactoryRestHandlerImpl;
import com.oracle.cie.rest.impl.RepositoryImpl;
import com.oracle.cie.rest.impl.RestHelperImpl;

public class RestFactory {
    public static final RestHandlerType DEFAULT_REST_HANDLER_TYPE = RestHandlerType.Artifactory;

    public static RestHandler getRestHandler() {
        return RestFactory.getRestHandler(DEFAULT_REST_HANDLER_TYPE);
    }

    public static RestHandler getRestHandler(RestHandlerType type) {
        if (type == RestHandlerType.Artifactory) {
            return new ArtifactoryRestHandlerImpl();
        }
        throw new IllegalArgumentException("Unknown rest handler type: " + (Object)((Object)type));
    }

    public static RestHandlerConfig getRestHandlerConfig() {
        return RestFactory.getRestHandlerConfig(DEFAULT_REST_HANDLER_TYPE);
    }

    public static RestHandlerConfig getRestHandlerConfig(RestHandlerType type) {
        if (type == RestHandlerType.Artifactory) {
            return ArtifactoryRestHandlerConfigImpl.getInstance();
        }
        throw new IllegalArgumentException("Unknown rest handler type: " + (Object)((Object)type));
    }

    public static RestHelper getRestHelper(RestHandler restHandler) {
        return new RestHelperImpl(restHandler);
    }

    public static Repository getRepository(String name) {
        return new RepositoryImpl(name, RepositoryType.LOCAL, RestFactory.getRestHandlerConfig().getDefaultRepositoryURL(name), name);
    }

    public static Repository getRepository(String name, String username, String password) {
        return new RepositoryImpl(name, RepositoryType.LOCAL, RestFactory.getRestHandlerConfig().getDefaultRepositoryURL(name), name, username, password);
    }

    public static Repository getRepository(String name, String location, String username, String password) {
        return new RepositoryImpl(name, RepositoryType.LOCAL, location, name, username, password);
    }

    public static Repository getRepository(String name, RestHandlerType handlerType) {
        return new RepositoryImpl(name, RepositoryType.LOCAL, RestFactory.getRestHandlerConfig(handlerType).getDefaultRepositoryURL(name), name, handlerType);
    }

    public static Repository getRepository(String name, RestHandlerType handlerType, String username, String password) {
        return new RepositoryImpl(name, RepositoryType.LOCAL, RestFactory.getRestHandlerConfig(handlerType).getDefaultRepositoryURL(name), name, handlerType, username, password);
    }

    public static Repository getRepository(String name, RepositoryType type, String location, String description) {
        return new RepositoryImpl(name, type, location, description);
    }

    public static Repository getRepository(String name, RepositoryType type, String location, String description, String username, String password) {
        return new RepositoryImpl(name, type, location, description, username, password);
    }

    public static Repository getRepository(String name, RepositoryType type, String location, String username, String password) {
        return new RepositoryImpl(name, type, location, name, username, password);
    }

    public static Repository getRepository(String name, RepositoryType type, String location, String description, RestHandlerType handlerType) {
        return new RepositoryImpl(name, type, location, description, handlerType);
    }

    public static Repository getRepository(String name, RepositoryType type, String location, String description, RestHandlerType handlerType, String username, String password) {
        return new RepositoryImpl(name, type, location, description, handlerType, username, password);
    }
}

