/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Version;
import java.util.Arrays;
import java.util.logging.Logger;

public class VersionImpl
implements Version {
    private static final Logger _log = Logger.getLogger(VersionImpl.class.getName());
    public static final String QUALIFIER_SEPARATOR = "-";
    protected String _baseVersion;
    protected String[] _qualifiers;
    protected boolean _emptyVersion;

    public VersionImpl() {
        this("0.0.0");
    }

    public VersionImpl(String version) {
        this(version, null);
    }

    public VersionImpl(String baseVersion, String ... qualifiers) {
        this.init(baseVersion, qualifiers);
    }

    private void init(String version, String ... qualifiers) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            throw new IllegalArgumentException("The version may not be null or empty.");
        }
        if (version.contains(" ")) {
            throw new IllegalArgumentException("The version may not contain spaces: " + version);
        }
        if (qualifiers != null && qualifiers.length > 0) {
            boolean allNull = true;
            String[] stringArray = qualifiers;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String qualifier = stringArray[i];
                if (qualifier == null) continue;
                allNull = false;
                break;
            }
            if (allNull) {
                qualifiers = null;
            }
        }
        if (qualifiers != null && qualifiers.length > 0) {
            for (String qualifier : qualifiers) {
                if (StringUtil.isNullOrEmpty((String)qualifier, (boolean)true)) {
                    throw new IllegalArgumentException("A null or empty version qualifier was specified: " + Arrays.asList(qualifiers));
                }
                if (!qualifier.contains(" ")) continue;
                throw new IllegalArgumentException("The version qualifiers may not contain spaces: " + qualifier);
            }
        }
        String[] split = version.split(QUALIFIER_SEPARATOR);
        this._baseVersion = split[0];
        int qualifierLength = split.length - 1;
        if (qualifiers != null) {
            qualifierLength += qualifiers.length;
        }
        this._qualifiers = new String[qualifierLength];
        if (split.length > 1) {
            System.arraycopy(split, 1, this._qualifiers, 0, split.length - 1);
        }
        if (qualifiers != null && qualifiers.length > 0) {
            System.arraycopy(qualifiers, 0, this._qualifiers, split.length - 1, qualifiers.length);
        }
        if (this._baseVersion.matches("0(\\.0)*")) {
            this._emptyVersion = true;
        }
    }

    @Override
    public String getVersion() {
        if (this._baseVersion != null) {
            StringBuilder buf = new StringBuilder(this._baseVersion);
            if (this.hasQualifier()) {
                buf.append(QUALIFIER_SEPARATOR).append(this.getQualifier());
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    public String getBaseVersion() {
        return this._baseVersion;
    }

    @Override
    public String[] getQualifiers() {
        return this._qualifiers;
    }

    @Override
    public String getQualifier() {
        StringBuilder buf = new StringBuilder();
        String[] qualifiers = this.getQualifiers();
        if (qualifiers != null && qualifiers.length > 0) {
            for (String qualifier : qualifiers) {
                if (buf.length() > 0) {
                    buf.append(QUALIFIER_SEPARATOR);
                }
                buf.append(qualifier);
            }
        }
        return buf.toString();
    }

    @Override
    public String getQualifier(int position) {
        if (this._qualifiers != null && position > 0 && this._qualifiers.length > position - 1) {
            return this._qualifiers[position - 1];
        }
        return null;
    }

    @Override
    public int getQualifierCount() {
        return this._qualifiers != null ? this._qualifiers.length : 0;
    }

    @Override
    public boolean hasQualifier() {
        return this._qualifiers != null && this._qualifiers.length > 0;
    }

    @Override
    public boolean equalsBase(Object o) {
        return this == o || o instanceof Version && ((Version)o).getBaseVersion().equals(this.getBaseVersion());
    }

    @Override
    public boolean isEmptyVersion() {
        return this._emptyVersion;
    }

    public String toString() {
        return this.getVersion();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Version && this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        int result = this._baseVersion != null ? this._baseVersion.hashCode() : 0;
        result = 31 * result + (this._qualifiers != null ? Arrays.hashCode(this._qualifiers) : 0);
        return result;
    }

    @Override
    public int compareTo(Version version) {
        String[] thatQualifiers;
        int compare;
        if (version == null) {
            throw new NullPointerException("The version for comparison was null.");
        }
        try {
            compare = this.compareVersionNumerically(this.getBaseVersion(), version.getBaseVersion());
        }
        catch (NumberFormatException e) {
            _log.fine("Encountered version with non-numerical values [" + this + "] vs. [" + version + "], switching to lexicographically comparison.");
            compare = this.compareVersionLexicographically(this.getBaseVersion(), version.getBaseVersion());
        }
        if (compare != 0) {
            return compare;
        }
        String[] thisQualifiers = this.getQualifiers();
        int maxSize = thisQualifiers.length >= (thatQualifiers = version.getQualifiers()).length ? thisQualifiers.length : thatQualifiers.length;
        for (int x = 0; x < maxSize; ++x) {
            String q1 = thisQualifiers.length > x ? thisQualifiers[x] : "0";
            String q2 = thatQualifiers.length > x ? thatQualifiers[x] : "0";
            try {
                compare = this.compareVersionNumerically(q1, q2);
            }
            catch (NumberFormatException e) {
                _log.fine("Encountered version with non-numerical values [" + this + "] vs. [" + version + "], switching to lexicographically comparison.");
                compare = this.compareVersionLexicographically(q1, q2);
            }
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private int compareVersionNumerically(String v1, String v2) throws NumberFormatException {
        String[] stringArray;
        String[] split1;
        String[] stringArray2;
        if (StringUtil.isNullOrEmpty((String)v1, (boolean)true)) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "0";
        } else {
            stringArray2 = split1 = v1.split("\\.");
        }
        if (StringUtil.isNullOrEmpty((String)v2, (boolean)true)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "0";
        } else {
            stringArray = v2.split("\\.");
        }
        String[] split2 = stringArray;
        int maxSize = split1.length >= split2.length ? split1.length : split2.length;
        for (int x = 0; x < maxSize; ++x) {
            long p1 = 0L;
            if (split1.length > x) {
                p1 = Long.parseLong(split1[x]);
            }
            long p2 = 0L;
            if (split2.length > x) {
                p2 = Long.parseLong(split2[x]);
            }
            if (p1 > p2) {
                return 1;
            }
            if (p2 <= p1) continue;
            return -1;
        }
        return 0;
    }

    private int compareVersionLexicographically(String v1, String v2) {
        String[] stringArray;
        String[] split1;
        String[] stringArray2;
        if (StringUtil.isNullOrEmpty((String)v1, (boolean)true)) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "0";
        } else {
            stringArray2 = split1 = v1.split("\\.");
        }
        if (StringUtil.isNullOrEmpty((String)v2, (boolean)true)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "0";
        } else {
            stringArray = v2.split("\\.");
        }
        String[] split2 = stringArray;
        int maxSize = split1.length >= split2.length ? split1.length : split2.length;
        for (int x = 0; x < maxSize; ++x) {
            int i;
            String p1 = "0";
            if (split1.length > x) {
                p1 = split1[x];
            }
            String p2 = "0";
            if (split2.length > x) {
                p2 = split2[x];
            }
            if ((i = p1.compareTo(p2)) == 0) continue;
            return i;
        }
        return 0;
    }
}

