/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.session;

import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.plan.PatchPlanManager;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import com.oracle.glcm.patch.auto.session.PatchInfoImpl;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Topology;
import com.oracle.glcm.patch.auto.topology.TopologyFactory;
import com.oracle.glcm.patch.auto.tracking.PatchTracking;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchSessionImpl
implements MutablePatchSession {
    private static final Logger _log = Logger.getLogger(PatchSessionImpl.class.getName());
    private File _opatchAutoHome;
    private OPatchAutoCommand _command;
    private PatchInfoImpl _patchInfo;
    private PatchPlanManager _patchPlanManager;
    private OPatchAutoOptions _options;
    private boolean _analyze;
    private Goal _currentGoal;
    private boolean _parallelEnabled;
    private CredentialManager _credentialManager;
    private ProductSupportManager _productSupportManager;
    private Topology _topology;
    private PatchTracking _patchTracking;
    private boolean _outOfPlace;
    private boolean _createImage;
    private boolean _applyImage;
    private String _imageLocation;
    private boolean _pushImage;
    private boolean _actionSession;

    @Override
    public File getOPatchAutoHome() {
        return this._opatchAutoHome;
    }

    @Override
    public void setOPatchAutoHome(File home) {
        this._opatchAutoHome = home;
    }

    @Override
    public OPatchAutoCommand getCommand() {
        return this._command;
    }

    @Override
    public void setCommand(OPatchAutoCommand command) {
        this._command = command;
    }

    @Override
    public void setPatchInfo(String patchLocation, String phBaseDirLocation, String patchId) throws OPatchAutoException {
        this._patchInfo = new PatchInfoImpl(patchLocation, phBaseDirLocation, patchId);
    }

    @Override
    public String getPatchLocation() {
        PatchInfo patchInfo = this.getPatchInfo();
        return patchInfo != null ? patchInfo.getPatchLocation() : null;
    }

    @Override
    public String getPatchBaseDirectory() {
        PatchInfo patchInfo = this.getPatchInfo();
        return patchInfo != null ? patchInfo.getPatchBaseDirectory() : null;
    }

    @Override
    public String getPatchId() {
        PatchInfo patchInfo = this.getPatchInfo();
        return patchInfo != null ? patchInfo.getPatchId() : null;
    }

    @Override
    public PatchInfo getPatchInfo() {
        return this._patchInfo;
    }

    @Override
    public PatchPlanManager getPatchPlanManager() {
        return this._patchPlanManager;
    }

    @Override
    public void setPatchPlanManager(PatchPlanManager patchPlanManager) {
        this._patchPlanManager = patchPlanManager;
    }

    @Override
    public OPatchAutoOptions getOptions() {
        return this._options;
    }

    @Override
    public void setOptions(OPatchAutoOptions options) {
        this._options = options;
    }

    @Override
    public boolean isAnalyze() {
        return this._analyze;
    }

    @Override
    public void setAnalyze(boolean analyze) {
        this._analyze = analyze;
    }

    @Override
    public boolean isRollback() {
        return this.getCommand() == OPatchAutoCommand.rollback;
    }

    @Override
    public Goal getCurrentGoal() {
        return this._currentGoal;
    }

    @Override
    public void setCurrentGoal(Goal goal) {
        this._currentGoal = goal;
    }

    @Override
    public boolean isParallelExecutionEnabled() {
        return this._parallelEnabled;
    }

    @Override
    public void setParallelEnabled(boolean parallelEnabled) {
        this._parallelEnabled = parallelEnabled;
    }

    @Override
    public CredentialManager getCredentialManager() {
        return this._credentialManager;
    }

    @Override
    public void setCredentialManager(CredentialManager credentialManager) {
        this._credentialManager = credentialManager;
    }

    @Override
    public ProductSupportManager getProductSupportManager() {
        return this._productSupportManager;
    }

    @Override
    public void setProductSupportManager(ProductSupportManager manager) {
        this._productSupportManager = manager;
        if (manager != null) {
            manager.getPatchActionManager().setPatchSession(this);
        }
    }

    @Override
    public Topology getTopology() {
        return this._topology;
    }

    @Override
    public void setTopology(Topology topology) throws OPatchAutoException {
        this._topology = topology;
        Set<PatchTarget> patchTargets = TopologyFactory.getPatchTargets(topology);
        if (_log.isLoggable(Level.FINER)) {
            _log.log(Level.FINER, "Created " + patchTargets.size() + " patch targets.\n" + this._topology + "\nPatch Targets:" + patchTargets);
        }
        this.setPatchPlanManager(PatchPlanManager.createPatchPlanManager(this.getProductSupportManager(), patchTargets.toArray(new PatchTarget[patchTargets.size()])));
    }

    @Override
    public PatchTracking getPatchTracking() {
        return this._patchTracking;
    }

    @Override
    public void setPatchTracking(PatchTracking patchTracking) {
        this._patchTracking = patchTracking;
    }

    @Override
    public boolean isOutOfPlacePatchingEnabled() {
        return this._outOfPlace;
    }

    @Override
    public void setOutOfPlaceEnabled(boolean outOfPlace) {
        this._outOfPlace = outOfPlace;
    }

    @Override
    public boolean isCreateImageEnabled() {
        return this._createImage;
    }

    @Override
    public void setCreateImageEnabled(boolean createImage) {
        this._createImage = createImage;
    }

    @Override
    public boolean isApplyImageEnabled() {
        return this._applyImage;
    }

    @Override
    public void setApplyImageEnabled(boolean applyImage) {
        this._applyImage = applyImage;
    }

    @Override
    public String getImageLocation() {
        return this._imageLocation;
    }

    @Override
    public void setImageLocation(String imageLocation) {
        this._imageLocation = imageLocation;
    }

    @Override
    public boolean isPushImage() {
        return this._pushImage;
    }

    @Override
    public void setPushImage(boolean pushImage) {
        this._pushImage = pushImage;
    }

    @Override
    public boolean isActionSession() {
        return this._actionSession;
    }

    @Override
    public void setActionSession(boolean actionSession) {
        this._actionSession = actionSession;
    }
}

