/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.product;

import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.plan.PatchPlanCustomizer;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementSetCreatorImpl;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementType;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Topology;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class CommonProductSupport
implements ProductSupport {
    private Set<ProductType> _types;
    private File _topologyFile;
    private Topology _topology;

    @Override
    public String getProductDisplayName() {
        return null;
    }

    @Override
    public Set<String> getPatchPlans() {
        return null;
    }

    @Override
    public String getPatchPlanDescription(String patchPlan) {
        return OPatchAutoHelper.getLocalizedString("CommonProductSupport.no.description", new Object[0]);
    }

    @Override
    public Set<ProductType> getTypes() {
        if (this._types == null) {
            Set<ProductType> types = this.loadProductTypes();
            if (types == null || types.isEmpty()) {
                throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68091", this.getClass()));
            }
            this._types = new LinkedHashSet<ProductType>();
            for (ProductType type : types) {
                this._types.add(type);
            }
        }
        return this._types;
    }

    @Override
    public ProductType getType(String type) {
        for (ProductType productType : this.getTypes()) {
            if (!productType.getType().equals(type)) continue;
            return productType;
        }
        return null;
    }

    protected abstract Set<ProductType> loadProductTypes();

    @Override
    public File getTopologyFile() {
        return this._topologyFile;
    }

    @Override
    public void setTopologyFile(File topologyFile) {
        this._topologyFile = topologyFile;
    }

    @Override
    public Topology getTopology() {
        return this._topology;
    }

    @Override
    public void loadTopology(OPatchAutoOptions options, CredentialManager credentialManager) throws OPatchAutoException {
    }

    @Override
    public void setTopology(Topology topology) {
        this._topology = topology;
    }

    @Override
    public boolean hasTopology() throws OPatchAutoException {
        return this.getTopology() != null;
    }

    @Override
    public Set<OPatchAutoOption> getOptions() {
        return null;
    }

    @Override
    public Set<OPatchAutoOptionGroup> getOptionGroups(OPatchAutoOptions options) {
        return null;
    }

    @Override
    public Set<String> getResourceBundles() {
        return null;
    }

    @Override
    public void updateOptions(OPatchAutoOptions options) throws OPatchAutoException {
        OPatchAutoOption sshAccessKey = options.getOption("sshaccesskey");
        if (sshAccessKey.hasValue() && sshAccessKey.isUsingDefault()) {
            sshAccessKey.setTracked(false);
        }
    }

    @Override
    public PatchPlanIncrementType getPatchPlanIncrementType(String incrementType) {
        try {
            return PatchPlanIncrementSetCreatorImpl.DefaultPatchPlanIncrementType.valueOf(incrementType.toLowerCase().trim());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void initialize(OPatchAutoCommand command, OPatchAutoOptions options) throws OPatchAutoException {
    }

    @Override
    public Map<String, String> getPluginVersions() {
        return null;
    }

    @Override
    public void closeSession(OPatchAutoCommand command, boolean isSuccessful) {
    }

    @Override
    public PatchPlanCustomizer getPatchPlanCustomizer(String id) {
        return null;
    }

    @Override
    public boolean isHomeCloningSupported(PatchTarget patchTarget) throws OPatchAutoException {
        return false;
    }

    @Override
    public void cloneHome(File sourceHome, File destHome) throws OPatchAutoException {
    }

    @Override
    public void applyClonedHome(File clonedSourceHome, File destHome, File backupHome, String invPtrLoc) throws OPatchAutoException {
    }

    @Override
    public void imageHome(File sourceHome, File imageFile, String invPtrLoc) throws OPatchAutoException {
    }

    @Override
    public void applyHomeImage(File imageFile, File destHome, File backupHome, String invPtrLoc) throws OPatchAutoException {
    }

    @Override
    public void rollbackToOriginalHome(File currentHome, File originalHome, String invPtrLoc) throws OPatchAutoException {
    }

    @Override
    public void clearClonedHome(File cloneHome) throws OPatchAutoException {
    }

    @Override
    public boolean isDefaultTopologyDisable(OPatchAutoOptions options) throws OPatchAutoException {
        return false;
    }

    @Override
    public Set<File> getAdditionalClasspath() throws OPatchAutoException {
        return null;
    }

    @Override
    public Set<File> getAdditionalCopyFiles() throws OPatchAutoException {
        return null;
    }

    @Override
    public Set<ProductType> getExternalOPatchAutoProductTypes() {
        return null;
    }

    @Override
    public void validatePatchSession(PatchSession patchSession) throws OPatchAutoException {
    }

    @Override
    public Set<PatchTarget> getSortedPatchTargets(Set<PatchTarget> patchTargets) {
        return null;
    }

    @Override
    public void updateOptionApplicability(OPatchAutoOptions options) throws OPatchAutoException {
    }

    @Override
    public Set<? extends OPatchAutoCommand> getUnsupportedCommand() {
        return null;
    }

    @Override
    public void postPatchSessionInit(PatchSession patchSession) {
    }

    @Override
    public void initializeOPatchAutoReporting(String reportingType) throws OPatchAutoException {
    }
}

