/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.credential;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.ValueHolder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.exception.OracleSecretNotFoundException;

public class CredentialManager {
    private static final Logger _log = Logger.getLogger(CredentialManager.class.getName());
    public static final String DEFAULT_PROTOCOL = "ssh";
    private static final String KEY_STORE_MAP_NAME = "oracle";
    private static final String KEY_STORE_CONSTANT = "@#3#@";
    private File _walletLocation;
    private ValueHolder _walletPassword;
    private OracleWallet _wallet;
    private Map<String, Credential> _cache = new HashMap<String, Credential>();

    public void setWallet(File walletLocation, char[] walletPassword) throws OPatchAutoException {
        this.validateWalletLocation(walletLocation);
        this._walletLocation = walletLocation;
        this._wallet = new OracleWallet();
        try {
            this._wallet.open(this._walletLocation.getAbsolutePath(), walletPassword);
            this.setWalletPassword(walletPassword);
        }
        catch (IOException e) {
            if (walletPassword == null || walletPassword.length < 1) {
                _log.log(Level.FINEST, "Failed to open wallet " + this._walletLocation + " and no wallet password was given, prompting...", e);
                walletPassword = OPatchAutoHelper.getPasswordFromConsole(OPatchAutoHelper.getLocalizedString("CredentialManager.wallet.password.prompt", new Object[0]));
                try {
                    this._wallet.open(this._walletLocation.getAbsolutePath(), walletPassword);
                    this.setWalletPassword(walletPassword);
                }
                catch (IOException e1) {
                    throw new OPatchAutoException("68083", (Throwable)e1, this._walletLocation);
                }
            }
            throw new OPatchAutoException("68083", (Throwable)e, this._walletLocation);
        }
    }

    public void setWallet(File walletLocation, ValueHolder walletPassword) throws OPatchAutoException {
        this.validateWalletLocation(walletLocation);
        this._walletLocation = walletLocation;
        this._walletPassword = walletPassword;
        this._wallet = new OracleWallet();
        try {
            this._wallet.open(this._walletLocation.getAbsolutePath(), walletPassword != null ? walletPassword.getValue() : null);
        }
        catch (IOException e) {
            throw new OPatchAutoException("68083", (Throwable)e, this._walletLocation);
        }
    }

    private void validateWalletLocation(File walletLocation) throws OPatchAutoException {
        if (walletLocation == null) {
            throw new OPatchAutoException("68081", new Object[0]);
        }
        if (!walletLocation.exists()) {
            throw new OPatchAutoException("68082", this._walletLocation);
        }
    }

    public Credential getCredential(String host) throws OPatchAutoException {
        return this.getCredential(host, null, null);
    }

    public Credential getCredential(String host, String protocol) throws OPatchAutoException {
        return this.getCredential(host, protocol, null);
    }

    public Credential getCredential(String host, String protocol, String username) throws OPatchAutoException {
        Credential credential = null;
        if (!StringUtil.isNullOrEmpty((String)host)) {
            Set<String> hostAddresses;
            try {
                hostAddresses = OPatchAutoHelper.getHostAddresses(host);
            }
            catch (OPatchAutoException e) {
                _log.log(Level.WARNING, "Failed to get host addresses for " + host, e);
                hostAddresses = new LinkedHashSet<String>();
                hostAddresses.add(host);
            }
            for (String hostAddress : hostAddresses) {
                String key = this.getCredentialKey(hostAddress, protocol, false, username);
                credential = this.credentialLookup(key);
                if (credential == null) {
                    key = this.getCredentialKey(hostAddress, protocol, true, username);
                    credential = this.credentialLookup(key);
                }
                if (credential == null) continue;
                break;
            }
            if (credential == null && !StringUtil.isNullOrEmpty((String)username, (boolean)true) && (credential = this.getCredential(host, protocol)) != null && !credential.getUsername().equals(username)) {
                credential = null;
            }
        }
        if (null == credential) {
            String msg = "Unable to locate credential for host ";
            msg = msg + (host == null ? " " : host);
            msg = msg + (protocol == null ? "" : " for protocol " + protocol);
            msg = msg + (username == null ? "" : " for user " + username);
            _log.warning(msg);
        }
        return credential;
    }

    public Credential getCredentialByKey(String key) throws OPatchAutoException {
        Credential cred = this.credentialLookup(key);
        if (cred == null) {
            _log.warning("Failed to locate any credential for " + key);
        }
        return cred;
    }

    private Credential credentialLookup(String key) throws OPatchAutoException {
        OracleWallet wallet;
        Credential credential = this._cache.get(key);
        if (credential == null && (wallet = this.getWallet()) != null) {
            try {
                OracleSecretStore oracleSecretStore = wallet.getSecretStore();
                credential = new Credential(oracleSecretStore.getUsernameCredential(KEY_STORE_MAP_NAME, key), oracleSecretStore.getPasswordCredential(KEY_STORE_MAP_NAME, key));
                this._cache.put(key, credential);
            }
            catch (OracleSecretNotFoundException e) {
                if (this.keyContainsUser(key) && _log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Credential not entered for oracle:" + key);
                }
            }
            catch (Exception e) {
                throw new OPatchAutoException("68084", (Throwable)e, this._walletLocation);
            }
        }
        if (credential == null && !this.keyContainsUser(key)) {
            credential = this.getCredentialByHost(key);
        }
        return credential;
    }

    public Credential getCredentialByHost(String key) throws OPatchAutoException {
        String key2 = this.removeUserFromKey(key);
        Credential credential = this._cache.get(key2);
        if (credential == null) {
            int startIndex = key2.indexOf(58);
            if (startIndex == -1) {
                startIndex = key2.indexOf(47);
            }
            String host = key2.substring(0, startIndex);
            OracleWallet wallet = this.getWallet();
            String wltAls = "";
            if (wallet != null) {
                try {
                    OracleSecretStore oracleSecretStore = wallet.getSecretStore();
                    Enumeration enumeration = oracleSecretStore.internalAliases();
                    while (enumeration.hasMoreElements()) {
                        String identifier;
                        wltAls = enumeration.nextElement().toString();
                        if (!wltAls.startsWith(identifier = "oracle@#3#@") || !wltAls.endsWith(":" + key2)) continue;
                        int keyIndex = wltAls.indexOf(KEY_STORE_CONSTANT);
                        String actualKey = wltAls.substring(keyIndex + KEY_STORE_CONSTANT.length());
                        credential = new Credential(oracleSecretStore.getUsernameCredential(KEY_STORE_MAP_NAME, actualKey), oracleSecretStore.getPasswordCredential(KEY_STORE_MAP_NAME, actualKey));
                        this._cache.put(key2, credential);
                        break;
                    }
                }
                catch (OracleSecretNotFoundException e) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.log(Level.FINEST, "Failed to access wallet alias " + wltAls, e);
                    }
                }
                catch (Exception e) {
                    throw new OPatchAutoException("68084", (Throwable)e, this._walletLocation);
                }
            }
        }
        return credential;
    }

    public void addCredential(String host, String accessKey) {
        this.addCredential(host, DEFAULT_PROTOCOL, accessKey);
    }

    public void addCredential(String host, String protocol, String accessKey) {
        Credential credential = new Credential();
        credential.setAccessKeyLocation(accessKey);
        this._cache.put(this.getCredentialKey(host, protocol), credential);
    }

    public void addCredential(String host, String username, char[] password) throws OPatchAutoException {
        this.addCredential(host, DEFAULT_PROTOCOL, username, password);
    }

    public void addCredential(String host, String protocol, String username, char[] password) throws OPatchAutoException {
        Credential credential = new Credential(username, password);
        this._cache.put(this.getCredentialKey(host, protocol, false, username), credential);
        if (!StringUtil.isNullOrEmpty((String)username, (boolean)true)) {
            this._cache.put(this.getCredentialKey(host, protocol, false, null), credential);
        }
    }

    public String getCredentialKey(String host, String protocol) {
        return this.getCredentialKey(host, protocol, false, null);
    }

    private String getCredentialKey(String host, String protocol, boolean upperCaseProtocol, String username) {
        if (StringUtil.isNullOrEmpty((String)protocol, (boolean)true)) {
            protocol = DEFAULT_PROTOCOL;
        }
        if (upperCaseProtocol) {
            protocol = protocol.toUpperCase();
        }
        if (StringUtil.isNullOrEmpty((String)username, (boolean)true)) {
            return host + ":" + protocol;
        }
        return username + ":" + host + ":" + protocol;
    }

    private boolean keyContainsUser(String key) {
        return key.split(":").length == 3;
    }

    private String removeUserFromKey(String key) {
        int counter = key.split(":").length;
        if (counter == 3) {
            int startIndex = key.indexOf(58);
            return key.substring(startIndex + 1, key.length());
        }
        return key;
    }

    public File getWalletLocation() {
        return this._walletLocation;
    }

    public char[] getWalletPassword() throws OPatchAutoException {
        return this._walletPassword != null ? this._walletPassword.getValue() : null;
    }

    public void setWalletPassword(char[] walletPassword) throws OPatchAutoException {
        if (walletPassword != null && walletPassword.length > 0) {
            this._walletPassword = new ValueHolder(walletPassword);
            Arrays.fill(walletPassword, '\u0000');
        } else {
            this._walletPassword = null;
        }
    }

    public ValueHolder getValueHolder() throws OPatchAutoException {
        return this._walletPassword;
    }

    public OracleWallet getWallet() {
        return this._wallet;
    }
}

