/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.reporting.Receiver;
import com.oracle.cie.common.util.reporting.ReceiverType;
import com.oracle.cie.common.util.reporting.ReceiverTypes;
import com.oracle.cie.common.util.reporting.Receiving;
import com.oracle.cie.common.util.reporting.Recipient;
import com.oracle.cie.common.util.reporting.RecipientAdapter;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionResultsContainer;
import com.oracle.glcm.patch.auto.action.PatchActionRunner;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.tracking.PatchTracking;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemotePatchActionRunner
implements PatchActionRunner {
    private static final Logger _logger = Logger.getLogger(RemotePatchActionRunner.class.getName());
    private PatchAction _patchAction;
    private Set<PatchTarget> _patchTargets;
    private Host _host;
    private boolean _isRequiredCheck;
    private boolean _parallel;
    private Map<PatchTarget, PatchActionResult> _patchActionResults = new LinkedHashMap<PatchTarget, PatchActionResult>();

    public RemotePatchActionRunner(PatchAction patchAction, Set<PatchTarget> patchTargets, Host host, boolean isRequiredCheck, boolean parallel) {
        this._patchAction = patchAction;
        this._patchTargets = patchTargets;
        this._host = host;
        this._isRequiredCheck = isRequiredCheck;
        this._parallel = parallel;
    }

    @Override
    public Map<PatchTarget, PatchActionResult> getPatchActionResults() {
        return this._patchActionResults;
    }

    @Override
    public void run() {
        try {
            _logger.info("Remote patch action runner executing" + (this._isRequiredCheck ? " is required check for " : " ") + "patch action " + this._patchAction + " on patch targets " + this._patchTargets);
            if (this._patchTargets != null && !this._patchTargets.isEmpty()) {
                if (!this._isRequiredCheck) {
                    PatchTracking.updateActions(this._patchAction, this._patchTargets, null);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Obtaining remote connection handler for host " + this._host);
                }
                RemoteConnectionHandler handler = OPatchAutoHelper.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)this._host);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Obtained remote connection handler [" + handler.getClass() + "] for host " + this._host);
                }
                String scriptExt = handler.isWindows() ? ".cmd" : ".sh";
                Home home = this._patchTargets.iterator().next().getHome(true);
                String homeLocation = home.getLocation().replace("\\", "/");
                if (!this._isRequiredCheck && this._patchAction.isRemoteOutOfPlaceRequired()) {
                    if (homeLocation.endsWith("/")) {
                        homeLocation = homeLocation.substring(0, homeLocation.length() - 1);
                    }
                    String homeParent = homeLocation.substring(0, homeLocation.lastIndexOf("/"));
                    String tmpHomeLocation = homeParent + "/opatchauto" + OPatchAutoHelper.getCurrentDateTimeStamp();
                    String command = "\"" + homeLocation + "/" + OPatchAutoHelper.OPATCHAUTO_BIN_PATH + "/" + "opatchautoCopy" + scriptExt + "\" \"" + homeLocation + "\" \"" + tmpHomeLocation + "\"";
                    _logger.info("Executing remote command [" + command + "]");
                    ByteArrayOutputStream junkOutputStream = new ByteArrayOutputStream();
                    try {
                        handler.exec(command, (OutputStream)junkOutputStream, home.getRemoteExecEnvVars());
                    }
                    catch (RemoteConnectionException e) {
                        _logger.warning("Failure while executing remote command [" + command + "] Output:\n****START REMOTE ACTION OUTPUT****\n" + junkOutputStream.toString() + "\n****END REMOTE ACTION OUTPUT****");
                        throw new OPatchAutoException("68141", (Throwable)e, this._host.getHost());
                    }
                    junkOutputStream.flush();
                    junkOutputStream.close();
                    _logger.info("Executed remote command [" + command + "] Output:\n****START REMOTE ACTION OUTPUT****\n" + junkOutputStream.toString() + "\n****END REMOTE ACTION OUTPUT****");
                    handler.deleteOnClose(tmpHomeLocation);
                    handler.chmod(tmpHomeLocation + "/" + OPatchAutoHelper.OPATCHAUTO_BIN_PATH + "/opatchauto" + scriptExt, 700);
                    handler.chmod(tmpHomeLocation + "/" + OPatchAutoHelper.OPATCHAUTO_BIN_PATH + "/opatchautoEnv" + scriptExt, 700);
                    homeLocation = tmpHomeLocation;
                }
                String tempDirName = System.getProperty("remote.temp.dir.name", "opatchauto-tmp");
                String opatchAutoTmp = System.getProperty("remote.temp.dir.path", homeLocation + "/" + tempDirName);
                String containerPath = opatchAutoTmp + "/container_" + this._host.getHost() + ".ser";
                String resultsPath = opatchAutoTmp + "/results_" + this._host.getHost() + ".ser";
                PatchActionExecutorContainer container = new PatchActionExecutorContainer();
                container.setTempLocation(opatchAutoTmp);
                container.setGoal(this._patchAction.getPatchSession().getCurrentGoal());
                container.setPatchTargets(this._patchTargets);
                container.setTopology(this._patchAction.getPatchSession().getTopology());
                container.setActionName(this._patchAction.getClass().getName());
                container.setAnalyze(this._patchAction.getPatchSession().isAnalyze());
                container.setCommand(this._patchAction.getPatchSession().getCommand());
                container.setParallel(this._parallel);
                container.setRequired(this._isRequiredCheck);
                container.setResults(resultsPath);
                container.setOutOfPlacePatchingEnabled(this._patchAction.getPatchSession().isOutOfPlacePatchingEnabled());
                container.setCreateImageEnabled(this._patchAction.getPatchSession().isCreateImageEnabled());
                container.setApplyImageEnabled(this._patchAction.getPatchSession().isApplyImageEnabled());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Creating opatchauto tmp directory at " + opatchAutoTmp + " on remote host " + this._host);
                }
                if (!handler.exists(opatchAutoTmp)) {
                    handler.mkdir(opatchAutoTmp);
                }
                handler.chmod(opatchAutoTmp, 700);
                handler.deleteOnClose(opatchAutoTmp);
                this._patchAction.prepareRemoteActionExecutionHost(handler, container);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Putting container object at " + containerPath + " on remote host " + this._host);
                }
                handler.putObject(containerPath, (Object)container);
                handler.deleteOnClose(containerPath);
                String command = "\"" + homeLocation + "/" + OPatchAutoHelper.OPATCHAUTO_BIN_PATH + "/" + "opatchauto" + scriptExt + "\" " + OPatchAutoCommand.action.name() + " " + this._patchAction.getPatchSession().getOptions().getOption("container").getArg() + " \"" + containerPath + "\" " + this._patchAction.getPatchSession().getOptions().getOption(OPatchAutoOptions.LOG_LEVEL_KEY).getCommandLineString();
                _logger.info("Executing" + (this._isRequiredCheck ? " is required check " : " ") + "remote command [" + command + "] for targets " + this._patchTargets);
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                Receiver receiver = Receiving.addReceiver((ReceiverType)ReceiverTypes.jackson, (InputStream)pipedInputStream, (String)OPatchAutoHelper.OPATCHAUTO_REMOTE_MESSAGE_INDICATOR);
                receiver.setKeepStreamOpen(false);
                receiver.addRecipient((Recipient)new RecipientAdapter(){

                    public void received(Message message) {
                        message.setMessage("<" + RemotePatchActionRunner.this._host.getHost() + ">" + " : " + message.getMessage());
                        Reporting.report((Message)message);
                    }
                });
                ByteArrayOutputStream junkOutputStream = new ByteArrayOutputStream();
                receiver.setJunkOutputStream((OutputStream)junkOutputStream);
                try {
                    handler.exec(command, (OutputStream)pipedOutputStream, home.getRemoteExecEnvVars());
                }
                catch (RemoteConnectionException e) {
                    _logger.warning("Failure while executing" + (this._isRequiredCheck ? " is required check " : " ") + " remote command [" + command + "] for targets " + this._patchTargets + " Output:\n****START REMOTE ACTION OUTPUT****\n" + junkOutputStream.toString() + "\n****END REMOTE ACTION OUTPUT****");
                    throw new OPatchAutoException("68141", (Throwable)e, this._host.getHost());
                }
                finally {
                    Thread.sleep(1000L);
                    Receiving.stop((Receiver)receiver);
                    receiver.getReceiverThread().join();
                }
                junkOutputStream.flush();
                junkOutputStream.close();
                this.captureRemoteLog(junkOutputStream, command);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Getting results container object from " + resultsPath + " on remote host " + this._host);
                }
                this._patchActionResults.putAll(((PatchActionResultsContainer)handler.getObject(resultsPath, OPatchAutoHelper.getPluginClassLoader())).getResults());
                handler.delete(containerPath, false, true);
                Set<String> cleanupPaths = container.getCleanupPaths();
                if (cleanupPaths != null) {
                    for (String cleanupPath : cleanupPaths) {
                        handler.delete(cleanupPath, true, true);
                    }
                }
            }
            if (!this._isRequiredCheck) {
                PatchTracking.updateActions(this._patchAction, this._patchTargets, this._patchActionResults);
                for (PatchTarget patchTarget : this._patchTargets) {
                    this._patchAction.postExecute(patchTarget, this._patchActionResults.get(patchTarget));
                }
            }
        }
        catch (Throwable e) {
            if (this._patchTargets != null) {
                for (PatchTarget patchTarget : this._patchTargets) {
                    this._patchActionResults.put(patchTarget, new PatchActionResult(e));
                }
            }
            _logger.log(Level.SEVERE, "Failure in remote patch action runner while executing" + (this._isRequiredCheck ? " is required check for " : " ") + "patch action " + this._patchAction + " on patch targets " + this._patchTargets, e);
        }
    }

    private void captureRemoteLog(ByteArrayOutputStream logoutputStream, String command) {
        try {
            String remoteLog = logoutputStream.toString();
            _logger.info("Executed" + (this._isRequiredCheck ? " is required check " : " ") + "remote command [" + command + "] for targets " + this._patchTargets + " Output:\n****START REMOTE ACTION OUTPUT****\n" + remoteLog + "\n****END REMOTE ACTION OUTPUT****");
        }
        catch (OutOfMemoryError e) {
            _logger.info("Reading each line of log as size of the log from remote is big");
            _logger.info("Executed" + (this._isRequiredCheck ? " is required check " : " ") + "remote command [" + command + "] for targets " + this._patchTargets + " Output:\n****START REMOTE ACTION OUTPUT****\n");
            byte[] outputdata = logoutputStream.toByteArray();
            int outputLength = outputdata.length;
            int startIndex = 0;
            int endIndex = 0;
            for (int i = 0; i < outputLength; ++i) {
                if ((char)outputdata[i] != '\n') continue;
                endIndex = i;
                _logger.logp(Level.INFO, "", "", new String(Arrays.copyOfRange(outputdata, startIndex, endIndex)));
                startIndex = endIndex + 1;
            }
            if (endIndex + 1 < outputLength) {
                _logger.info(new String(Arrays.copyOfRange(outputdata, startIndex, outputLength - 1)));
            }
            _logger.info("\n****END REMOTE ACTION OUTPUT****");
        }
    }
}

