/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.glcm.patch.auto.action.PatchActionResultData;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PatchActionResult
implements Serializable {
    private PatchActionStatus _result;
    private Throwable _exception;
    private List<String> _details;
    private PatchActionResultData _resultData;

    public PatchActionResult() {
        this._result = PatchActionStatus.success;
    }

    public PatchActionResult(boolean result) {
        this(result ? PatchActionStatus.success : PatchActionStatus.failure);
    }

    public PatchActionResult(PatchActionStatus result) {
        this(result, null);
    }

    public PatchActionResult(Throwable exception) {
        this(PatchActionStatus.failure, exception);
    }

    public PatchActionResult(PatchActionStatus result, Throwable exception) {
        this._result = result;
        this._exception = exception;
    }

    public PatchActionStatus getResult() {
        return this._result;
    }

    public Throwable getException() {
        return this._exception;
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public boolean isFailure() {
        return this._result.isFailure();
    }

    public boolean isSuccess() {
        return this._result.isSuccess() || this._result.isWarning();
    }

    public boolean isWarning() {
        return this._result.isWarning();
    }

    public String getDetails() {
        if (this._details != null && !this._details.isEmpty()) {
            return this._details.toString();
        }
        if (this.getException() != null) {
            return this.getException().getMessage();
        }
        return this.getResult().name();
    }

    public List<String> getDetailsList() {
        return this._details;
    }

    public void setDetails(Collection<String> details) {
        if (details != null) {
            for (String detail : details) {
                this.addDetail(detail);
            }
        }
    }

    public void addDetail(String detail) {
        if (detail != null) {
            if (this._details == null) {
                this._details = new ArrayList<String>();
            }
            this._details.add(detail);
        }
    }

    public <T extends PatchActionResultData> T getTypedResultData(Class<T> type) {
        return (T)((PatchActionResultData)type.cast(this._resultData));
    }

    public void setResultData(PatchActionResultData resultData) {
        this._resultData = resultData;
    }
}

