/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class OPatchAutoOptionGroup {
    private String _key;
    private Relationship _relationship;
    private boolean _required;
    private boolean _enabled;
    private Set<OPatchAutoOption> _options;

    public static OPatchAutoOptionGroup getOPatchAutoOptionGroup(String key, Relationship relationship, boolean required, OPatchAutoOption ... options) {
        return OPatchAutoOptionGroup.getOPatchAutoOptionGroup(key, relationship, required, true, options);
    }

    public static OPatchAutoOptionGroup getOPatchAutoOptionGroup(String key, Relationship relationship, boolean required, boolean enabled, OPatchAutoOption ... options) {
        LinkedHashSet<OPatchAutoOption> optionsSet = new LinkedHashSet<OPatchAutoOption>();
        if (options != null) {
            Collections.addAll(optionsSet, options);
        }
        return new OPatchAutoOptionGroup(key, relationship, required, enabled, optionsSet);
    }

    protected OPatchAutoOptionGroup(String key, Relationship relationship, boolean required, boolean enabled, Set<OPatchAutoOption> options) {
        if (key == null) {
            throw new NullPointerException(OPatchAutoHelper.getPublishedMessage("68050", new Object[0]));
        }
        if (options == null || options.size() < 2) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage("68051", key, options));
        }
        this._key = key;
        this._relationship = relationship;
        this._required = required;
        this._enabled = enabled;
        this._options = options;
    }

    public String getKey() {
        return this._key;
    }

    public Relationship getRelationship() {
        return this._relationship;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public Set<OPatchAutoOption> getOptions() {
        return this._options;
    }

    public Set<OPatchAutoOption> validateRequiredTogether(boolean requiredCheck) throws OPatchAutoException {
        if (this.isEnabled() && this.getRelationship().isRequiredTogether()) {
            Set<OPatchAutoOption> options = this.getOptions();
            LinkedHashSet<OPatchAutoOption> missingValues = new LinkedHashSet<OPatchAutoOption>();
            boolean atLeastOneHasValue = false;
            for (OPatchAutoOption option : options) {
                if (option == null) continue;
                if (!option.hasValue()) {
                    missingValues.add(option);
                    continue;
                }
                atLeastOneHasValue = true;
            }
            if (requiredCheck) {
                if (this.isRequired() && !missingValues.isEmpty()) {
                    return missingValues;
                }
            } else if (atLeastOneHasValue && !missingValues.isEmpty()) {
                return options;
            }
        }
        return null;
    }

    public Set<OPatchAutoOption> validateMutuallyExclusive(boolean requiredCheck) throws OPatchAutoException {
        if (this.isEnabled() && this.getRelationship().isMutuallyExclusive()) {
            Set<OPatchAutoOption> options = this.getOptions();
            ArrayList<OPatchAutoOption> haveValues = new ArrayList<OPatchAutoOption>();
            for (OPatchAutoOption option : options) {
                if (option == null || !option.hasValue()) continue;
                haveValues.add(option);
            }
            if (requiredCheck ? this.isRequired() && haveValues.isEmpty() : haveValues.size() > 1) {
                return options;
            }
        }
        return null;
    }

    public Set<OPatchAutoOption> validateIfFirstThenAllRequired(boolean requiredCheck) throws OPatchAutoException {
        if (this.isEnabled() && this.getRelationship().isIfFirstThenAllRequired()) {
            Set<OPatchAutoOption> options = this.getOptions();
            LinkedHashSet<OPatchAutoOption> missingValues = new LinkedHashSet<OPatchAutoOption>();
            OPatchAutoOption firstOption = null;
            for (OPatchAutoOption option : options) {
                if (option == null) continue;
                if (firstOption == null) {
                    firstOption = option;
                }
                if (option.hasValue()) continue;
                missingValues.add(option);
            }
            if (requiredCheck) {
                if (this.isRequired() && !missingValues.isEmpty()) {
                    return missingValues;
                }
            } else if (firstOption != null && firstOption.hasValue() && !missingValues.isEmpty()) {
                return options;
            }
        }
        return null;
    }

    public Set<OPatchAutoOption> validateIfFirstThenExcludeAll() throws OPatchAutoException {
        if (this.isEnabled() && this.getRelationship().isIfFirstThenExcludeAll()) {
            Set<OPatchAutoOption> options = this.getOptions();
            LinkedHashSet<OPatchAutoOption> mutualExclusiveOptions = new LinkedHashSet<OPatchAutoOption>();
            OPatchAutoOption firstOption = null;
            for (OPatchAutoOption option : options) {
                if (option == null) continue;
                if (firstOption == null) {
                    if ((!option.isSwitch() || !option.isSwitchEnabled()) && (option.isSwitch() || !option.hasValue())) break;
                    firstOption = option;
                    continue;
                }
                if ((!option.isSwitch() || !option.isSwitchEnabled()) && (option.isSwitch() || !option.hasValue())) continue;
                mutualExclusiveOptions.add(option);
            }
            if (mutualExclusiveOptions.size() > 0) {
                return mutualExclusiveOptions;
            }
        }
        return null;
    }

    public Set<OPatchAutoOption> validateIfFirstThenAtLeastOneRequired(boolean requiredCheck) throws OPatchAutoException {
        if (this.isEnabled() && this.getRelationship().isIfFirstThenAtLeastOneRequired()) {
            Set<OPatchAutoOption> options = this.getOptions();
            LinkedHashSet<OPatchAutoOption> missingValues = new LinkedHashSet<OPatchAutoOption>();
            OPatchAutoOption firstOption = null;
            for (OPatchAutoOption option : options) {
                if (option == null) continue;
                if (firstOption == null) {
                    firstOption = option;
                }
                if (option.hasValue()) continue;
                missingValues.add(option);
            }
            if (requiredCheck) {
                if (this.isRequired() && firstOption != null && !firstOption.hasValue()) {
                    return Collections.singleton(firstOption);
                }
            } else if (firstOption != null && firstOption.hasValue() && missingValues.size() == options.size() - 1) {
                return missingValues;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OPatchAutoOptionGroup)) {
            return false;
        }
        OPatchAutoOptionGroup that = (OPatchAutoOptionGroup)o;
        return this._key.equals(that._key);
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public String toString() {
        return this._key + ":" + (Object)((Object)this._relationship);
    }

    public static enum Relationship {
        required_together,
        mutually_exclusive,
        if_first_then_all_required,
        if_first_then_at_least_one_required,
        if_first_then_exclude_all;


        public boolean isRequiredTogether() {
            return this == required_together;
        }

        public boolean isMutuallyExclusive() {
            return this == mutually_exclusive;
        }

        public boolean isIfFirstThenAllRequired() {
            return this == if_first_then_all_required;
        }

        public boolean isIfFirstThenAtLeastOneRequired() {
            return this == if_first_then_at_least_one_required;
        }

        public boolean isIfFirstThenExcludeAll() {
            return this == if_first_then_exclude_all;
        }
    }
}

