/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.productdriver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.OUIComponent;
import model.common.OracleHome;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.osysmodel.driver.sdk.util.OsysUtility;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiClusterInstallInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUIDriver {
    private Logger logger = Logger.getLogger(OUIDriver.class.getName());
    private static OUIDriver ouiDriver = new OUIDriver();
    OiicStandardInventorySession osis = null;
    String OUI_DIR = "oui";
    String SYSTEM_PROPERTY_OUI_LOC = "oracle.installer.oui_loc";
    String SYSTEM_PROPERTY_STARTUP_LOC = "oracle.installer.startup_location";
    String LIB_DIR = "lib";
    String SYSTEM_PROPERTY_LIB_LOC = "oracle.installer.library_loc";

    public static int compareOPatchVersion(String string, String string2) {
        OiiiVersion oiiiVersion = new OiiiVersion(string);
        OiiiVersion oiiiVersion2 = new OiiiVersion(string2);
        if (oiiiVersion.laterThan(oiiiVersion2)) {
            return 1;
        }
        if (oiiiVersion.equals(oiiiVersion2)) {
            return 0;
        }
        return -1;
    }

    public static List<OracleHome> getLocalInfo() {
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        OUIDriver oUIDriver = new OUIDriver();
        OiicStandardInventorySession oiicStandardInventorySession = oUIDriver.initOUI();
        OiiiInstallAreaControl oiiiInstallAreaControl = oiicStandardInventorySession.getInstallAreaControl();
        OiiiInstallInventory oiiiInstallInventory = oiiiInstallAreaControl.getInstallInventory();
        ArrayList<OracleHome> arrayList = new ArrayList<OracleHome>();
        for (Object e : oiiiInstallInventory.getHomes()) {
            String string;
            OracleHome oracleHome = new OracleHome();
            oracleHome.setId("ID_" + UUID.randomUUID().toString());
            if (OUIDriver.isWindows()) {
                oracleHome.setPlatform("windows");
            } else {
                oracleHome.setPlatform("linux");
            }
            oracleHome.setType(oracleHome.getClass().getName());
            oracleHome.setDescription("A " + oracleHome.getType());
            OiiiOracleHomeInfo oiiiOracleHomeInfo = (OiiiOracleHomeInfo)e;
            oracleHome.setPath(new File(oiiiOracleHomeInfo.getLocation()).getAbsolutePath());
            oracleHome.setInstalledSWComponents(new ArrayList());
            oUIDriver.writeHomeInfo(oracleHome, oiiiOracleHomeInfo, oiiiInstallInventory);
            File file = new File(oracleHome.getPath(), "oraInst.loc");
            try {
                string = OUIDriver.readCentralInventoryLocation(file);
                oracleHome.setCentralInvPtr(string);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Unable to read central inventory file from " + file.getPath(), exception);
                continue;
            }
            try {
                string = OUIDriver.checkOpatchVersion(oracleHome.getPath());
                oracleHome.setVersionOPatch(string);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Unable to collect OPatch Version from " + oracleHome.getPath(), exception);
            }
            try {
                string = OUIDriver.checkOracleBase(oracleHome.getPath());
                oracleHome.setOracleBaseLocation(string);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Unable to get ORACLE_BASE for " + oracleHome.getPath(), exception);
                continue;
            }
            try {
                string = OUIDriver.checkFileOwner(new File(oracleHome.getPath(), "oraInst.loc"));
                oracleHome.setOwner(string);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Unable to get owner for " + oracleHome.getPath(), exception);
                continue;
            }
            arrayList.add(oracleHome);
            logger.finest("Found Local Home:" + oiiiOracleHomeInfo.getLocation());
        }
        oUIDriver.endSession();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _checkOracleBase(String string) {
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        File file = new File(string + "/bin/orabase");
        if (!file.exists()) {
            logger.log(Level.FINE, string + "/bin/orabase could not be found for OracleHome at " + string);
            return null;
        }
        try {
            String string2 = null;
            Process process = Runtime.getRuntime().exec(new String[]{string + "/bin/orabase"});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                string2 = bufferedReader.readLine();
                logger.fine(string + " has ORACLE_BASE " + string2);
            }
            finally {
                bufferedReader.close();
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new ProductDriverException(iOException.getMessage(), iOException, ProductDriverException.Type.Unknown);
        }
    }

    public static String checkOracleBase(String string) {
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        logger.entering(OUIDriver.class.getName(), "checkOracleBase");
        OiicStandardInventorySession oiicStandardInventorySession = new OiicStandardInventorySession("invcloner", "9.0.1.1");
        try {
            oiicStandardInventorySession.initSession(2);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Could not create an Inventory Session", exception);
        }
        String string2 = null;
        try {
            OiiiInstallInventory oiiiInstallInventory = oiicStandardInventorySession.getInstallAreaControl().getInstallInventory();
            OiiiOracleHomeInfo oiiiOracleHomeInfo = oiiiInstallInventory.getHomeWithLocation(string);
            string2 = oiiiOracleHomeInfo.getAdditionalOracleHomeProperty("ORACLE_BASE");
            oiicStandardInventorySession.endSession();
        }
        catch (Exception exception) {
            oiicStandardInventorySession.endSession();
            logger.log(Level.WARNING, "Could not get ORACLE_BASE for " + string + " via OUI API.", exception);
            logger.info("Going to attempt getting ORACLE_BASE using command for" + string);
            string2 = OUIDriver._checkOracleBase(string);
        }
        if (string2 != null) {
            logger.log(Level.INFO, "ORACLE_BASE for " + string + " is " + string2);
        } else {
            logger.log(Level.FINE, "ORACLE_BASE for " + string + " is " + string2);
        }
        logger.exiting(OUIDriver.class.getName(), "checkOracleBase");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkOpatchVersion(String string) {
        String string2;
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        logger.entering(OUIDriver.class.getName(), "checkOpatchVersion");
        File file = new File(string + "/OPatch/opatch");
        if (!file.exists()) {
            logger.log(Level.FINE, "OPatch/opatch could not be found for OracleHome at " + string);
            return null;
        }
        String string3 = null;
        logger.log(Level.FINEST, "Executing OPatch/opatch version for OracleHome at " + string);
        Process process = Runtime.getRuntime().exec(new String[]{string + "/OPatch/opatch", "version"});
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String string4 = bufferedReader.readLine();
            String string5 = "OPatch Version: ";
            while (string4 != null) {
                if (string4.startsWith(string5)) {
                    string3 = string4.substring(string5.length());
                    logger.fine(string + " has OPatch Version " + string3);
                    logger.exiting(OUIDriver.class.getName(), "checkOpatchVersion");
                    break;
                }
                string4 = bufferedReader.readLine();
            }
            string2 = string3;
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ProductDriverException(iOException.getMessage(), iOException, ProductDriverException.Type.Unknown);
            }
        }
        bufferedReader.close();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readCentralInventoryLocation(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = bufferedReader.readLine();
                String string2 = "inventory_loc=";
                while (string != null) {
                    if (string.startsWith(string2)) {
                        String string3 = string.substring(string2.length());
                        return string3;
                    }
                    string = bufferedReader.readLine();
                }
                throw new ProductDriverException("Couldn't find inventory_loc in " + file.getAbsolutePath(), ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            throw new ProductDriverException(iOException.getMessage(), iOException, ProductDriverException.Type.Unknown);
        }
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("win");
    }

    private static String getCurrentRunningUser() {
        return System.getProperty("user.name");
    }

    public static String checkFileOwnerInWindows(File file) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cmd /c dir /q " + file.getAbsoluteFile());
            int n = process.waitFor();
            if (n != 0) {
                String string = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine();
                throw new ProductDriverException("Failed to check OH owner:" + string, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains(file.getName())) continue;
                String[] stringArray = string.split("\\s+");
                return stringArray[4];
            }
        }
        catch (IOException iOException) {
            throw new ProductDriverException(iOException.getMessage(), iOException, ProductDriverException.Type.Unknown);
        }
        catch (InterruptedException interruptedException) {
            throw new ProductDriverException(interruptedException.getMessage(), interruptedException, ProductDriverException.Type.Unknown);
        }
        return OUIDriver.getCurrentRunningUser();
    }

    public static String checkFileOwnerInLinux(File file) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("/bin/ls", "-ld", file.getAbsolutePath());
        try {
            Process process = processBuilder.start();
            int n = process.waitFor();
            if (n != 0) {
                String string;
                String string2 = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine();
                if (string2.startsWith(string = "/bin/ls:")) {
                    string2 = string2.substring(string.length());
                }
                throw new ProductDriverException("Failed to check OH owner:" + string2, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            String[] stringArray = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine().split("\\s+");
            if (stringArray.length < 3) {
                throw new ProductDriverException("ls did not return the expected number of fields", ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            return stringArray[2];
        }
        catch (IOException iOException) {
            throw new ProductDriverException(iOException.getMessage(), iOException, ProductDriverException.Type.Unknown);
        }
        catch (InterruptedException interruptedException) {
            throw new ProductDriverException(interruptedException.getMessage(), interruptedException, ProductDriverException.Type.Unknown);
        }
    }

    public static String checkFileOwner(File file) {
        if (OUIDriver.isWindows()) {
            return OUIDriver.checkFileOwnerInWindows(file);
        }
        return OUIDriver.checkFileOwnerInLinux(file);
    }

    public static String checkFileGroup(File file) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("/bin/ls", "-ld", file.getAbsolutePath());
        try {
            Process process = processBuilder.start();
            int n = process.waitFor();
            if (n != 0) {
                String string;
                String string2 = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine();
                if (string2.startsWith(string = "/bin/ls:")) {
                    string2 = string2.substring(string.length());
                }
                throw new ProductDriverException("Failed to check OH group:" + string2, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            String[] stringArray = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine().split("\\s+");
            if (stringArray.length < 4) {
                throw new ProductDriverException("ls did not return the expected number of fields", ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            return stringArray[3];
        }
        catch (IOException iOException) {
            throw new ProductDriverException(iOException.getMessage(), iOException, ProductDriverException.Type.Unknown);
        }
        catch (InterruptedException interruptedException) {
            throw new ProductDriverException(interruptedException.getMessage(), interruptedException, ProductDriverException.Type.Unknown);
        }
    }

    private OUIDriver() {
    }

    public static OiicStandardInventorySession getStdInventorySession() {
        return ouiDriver.initOUI();
    }

    public static void endStdInventorySession() {
        ouiDriver.endSession();
    }

    OiicStandardInventorySession startSession() {
        OiicStandardInventorySession oiicStandardInventorySession = new OiicStandardInventorySession("OUISM", "1.0");
        try {
            oiicStandardInventorySession.initSession(0);
        }
        catch (OiitTargetLockNotAvailableException oiitTargetLockNotAvailableException) {
            throw new ProductDriverException(oiitTargetLockNotAvailableException, ProductDriverException.Type.ProductApiException);
        }
        catch (IOException iOException) {
            throw new ProductDriverException(iOException, ProductDriverException.Type.Unknown);
        }
        catch (OiiiInventoryDoesNotExistException oiiiInventoryDoesNotExistException) {
            throw new ProductDriverException(oiiiInventoryDoesNotExistException, ProductDriverException.Type.Unknown);
        }
        this.osis = oiicStandardInventorySession;
        return oiicStandardInventorySession;
    }

    void endSession() {
        this.osis.endSession();
        this.osis = null;
    }

    OiicStandardInventorySession initOUI() {
        String string = System.getenv("ORACLE_HOME");
        if ((string == null || string.equals("")) && ((string = System.getProperty("ORACLE_HOME")) == null || string.equals(""))) {
            throw new ProductDriverException("Please set the ORACLE_HOME environment variable to the location of the Grid Infrastructure (GI) Home.");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(File.separator);
        stringBuffer.append(this.OUI_DIR);
        System.setProperty(this.SYSTEM_PROPERTY_OUI_LOC, stringBuffer.toString());
        System.setProperty(this.SYSTEM_PROPERTY_STARTUP_LOC, stringBuffer.toString());
        String string2 = OiixPathOps.concatPath((String)stringBuffer.toString(), (String)this.LIB_DIR);
        String string3 = OiixPlatform.getCurrentPlatformDirectoryName();
        string2 = OiixPathOps.concatPath((String)string2, (String)string3);
        string2 = OiixPathOps.getNativeForm((String)string2);
        System.setProperty(this.SYSTEM_PROPERTY_LIB_LOC, string2);
        return this.startSession();
    }

    void writeHomeInfo(OracleHome oracleHome, OiiiOracleHomeInfo oiiiOracleHomeInfo, OiiiInstallInventory oiiiInstallInventory) {
        if (oiiiOracleHomeInfo == null) {
            this.logger.finest("No information for home at " + oracleHome.getPath() + " in OUI inventory");
            return;
        }
        oracleHome.setPlatform(oiiiOracleHomeInfo.getARUIDDescription());
        oracleHome.setARUId(Integer.toString(oiiiOracleHomeInfo.getARUID()));
        oracleHome.setDescription(oiiiOracleHomeInfo.getLocation());
        oracleHome.setName(oiiiOracleHomeInfo.getUniqueName());
        oracleHome.setHomeName(oracleHome.getName());
        oracleHome.setDisplayName(oracleHome.getName());
        oracleHome.setHomeGuid(oiiiOracleHomeInfo.getGUID());
        oracleHome.setTopLevelOUI(new ArrayList());
        for (Object e : oiiiInstallInventory.getTopLevelComps(oiiiOracleHomeInfo.getIndex())) {
            OiiiCompInstallID oiiiCompInstallID = (OiiiCompInstallID)e;
            OUIComponent oUIComponent = new OUIComponent();
            oUIComponent.setName(oiiiCompInstallID.getName());
            oUIComponent.setId(UUID.randomUUID().toString());
            oUIComponent.setType(OUIComponent.class.getName());
            oUIComponent.setDescription(oiiiCompInstallID.getName());
            oUIComponent.setDisplayName(oiiiCompInstallID.getName());
            oUIComponent.setVersion(oiiiCompInstallID.getVersion().getVerString());
            oracleHome.getTopLevelOUI().add(oUIComponent);
            this.logger.finest("Added Component:" + oUIComponent.getName());
        }
        this.logger.finest("Added OUI Info to:" + oracleHome.getName());
    }

    public static String getMaxMinVersion(List<String> list) {
        String string = list.get(0);
        for (String string2 : list) {
            OiiiVersion oiiiVersion;
            OiiiVersion oiiiVersion2 = new OiiiVersion(string2);
            if (!oiiiVersion2.laterThan(oiiiVersion = new OiiiVersion(string))) continue;
            string = string2;
        }
        return string;
    }

    public static Object[] getTopLevelCompOfOracleHome(String string) {
        Object[] objectArray = null;
        try {
            OiicStandardInventorySession oiicStandardInventorySession = new OiicStandardInventorySession("oplanInv", "1.0");
            oiicStandardInventorySession.initSession(1);
            OiiiInstallAreaControl oiiiInstallAreaControl = oiicStandardInventorySession.getInstallAreaControl();
            OiiiInstallInventory oiiiInstallInventory = oiiiInstallAreaControl.getInstallInventory();
            Vector vector = oiiiInstallInventory.getHomes();
            int n = OiiiOracleHomeInfo.getOHIndex((Vector)vector, (String)string);
            Vector vector2 = oiiiInstallInventory.getTopLevelComps(n);
            for (Object e : vector2) {
                OiiiCompInstallID oiiiCompInstallID;
                if (!(e instanceof OiiiCompInstallID) || (oiiiCompInstallID = (OiiiCompInstallID)e) == null) continue;
                objectArray = new Object[]{oiiiCompInstallID.getName(), oiiiCompInstallID.getVersion()};
                break;
            }
        }
        catch (Exception exception) {
            objectArray = null;
        }
        return objectArray;
    }

    public static HashMap isHomeOnRemoteNode(String[] stringArray, String string, Object object, Object object2) {
        HashMap<String, String> hashMap;
        block6: {
            hashMap = new HashMap<String, String>();
            try {
                OiiiClusterInstallInventory oiiiClusterInstallInventory = new OiiiClusterInstallInventory(stringArray);
                if (oiiiClusterInstallInventory != null) {
                    hashMap.put("IS_CLUSTER_INV", "YES");
                    for (int i = 0; i < stringArray.length; ++i) {
                        OiiiRemoteHome oiiiRemoteHome = oiiiClusterInstallInventory.getRemoteHome(stringArray[i], string);
                        if (oiiiRemoteHome != null) {
                            List list = oiiiRemoteHome.getTopLevelComps();
                            OiiiInstallCompInvEntry oiiiInstallCompInvEntry = (OiiiInstallCompInvEntry)list.get(0);
                            OiiiVersion oiiiVersion = oiiiInstallCompInvEntry.getVersion();
                            OiiiCompInstallID oiiiCompInstallID = oiiiInstallCompInvEntry.getCompInstallID();
                            String string2 = oiiiCompInstallID.getName();
                            String string3 = (String)object;
                            OiiiVersion oiiiVersion2 = (OiiiVersion)object2;
                            if (oiiiVersion.equals(oiiiVersion2) && string3.equalsIgnoreCase(string2)) continue;
                            hashMap.put("IS_HOME_ON_REMOTE_NODE", "NO");
                        } else {
                            hashMap.put("IS_HOME_ON_REMOTE_NODE", "NO");
                        }
                        break block6;
                    }
                    break block6;
                }
                hashMap.put("IS_HOME_ON_REMOTE_NODE", "NO");
            }
            catch (Exception exception) {
                hashMap.put("IS_HOME_ON_REMOTE_NODE", "NO");
            }
        }
        return hashMap;
    }

    public static String[] fetchNodeNames(String string) {
        String[] stringArray = new String[]{};
        OiicStandardInventorySession oiicStandardInventorySession = OUIDriver.getStdInventorySession();
        OiiiInstallAreaControl oiiiInstallAreaControl = oiicStandardInventorySession.getInstallAreaControl();
        OiiiInstallInventory oiiiInstallInventory = oiiiInstallAreaControl.getInstallInventory();
        block0: for (Object e : oiiiInstallInventory.getHomes()) {
            OiiiOracleHomeInfo oiiiOracleHomeInfo = (OiiiOracleHomeInfo)e;
            if (!new File(oiiiOracleHomeInfo.getLocation()).equals(new File(string))) continue;
            Vector vector = oiiiOracleHomeInfo.getNodeList();
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
            String string2 = oiiiOracleHomeInfo.getLocalNode();
            if (string2 == null || string2.equals("")) {
                string2 = OsysUtility.getHostname();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                if (i == 0) break block0;
                String string3 = stringArray[0];
                stringArray[0] = stringArray[i];
                stringArray[i] = string3;
                break block0;
            }
        }
        if (stringArray.length < 1) {
            stringArray = new String[]{OsysUtility.getHostname()};
        }
        OUIDriver.endStdInventorySession();
        return stringArray;
    }

    public static boolean firstVersionLaterThanSecond(String string, String string2) {
        OiiiVersion oiiiVersion = new OiiiVersion(string);
        OiiiVersion oiiiVersion2 = new OiiiVersion(string2);
        return oiiiVersion.laterThan(oiiiVersion2);
    }

    public static boolean areLocationsSame(String string, String string2) {
        OiipgFileSystem oiipgFileSystem = new OiipgFileSystem();
        return oiipgFileSystem.areLocsSame(string, string2);
    }

    public static ArrayList<String[]> getHomesList() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        OiicStandardInventorySession oiicStandardInventorySession = OUIDriver.getStdInventorySession();
        OiiiInstallAreaControl oiiiInstallAreaControl = oiicStandardInventorySession.getInstallAreaControl();
        OiiiInstallInventory oiiiInstallInventory = oiiiInstallAreaControl.getInstallInventory();
        boolean bl = false;
        for (Object e : oiiiInstallInventory.getHomes()) {
            String string;
            String[] stringArray = new String[2];
            OiiiOracleHomeInfo oiiiOracleHomeInfo = (OiiiOracleHomeInfo)e;
            stringArray[0] = string = oiiiOracleHomeInfo.getLocation();
            stringArray[1] = oiiiOracleHomeInfo.isCRSHome() ? "IS_CRS_HOME" : "IS_NOT_CRS_HOME";
            arrayList.add(stringArray);
        }
        return arrayList;
    }
}

