/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.driver.sdk.productdriver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import model.SystemInstance;
import model.common.Host;
import model.common.OracleHome;
import oracle.osysmodel.driver.sdk.productdriver.HostComparatorCreator;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalInfo {
    Host localHost;
    String localHostName;
    List<OracleHome> homes = null;

    public String getLocalHostName() {
        return this.localHostName;
    }

    public void setLocalHostName(String string) {
        this.localHostName = string;
    }

    public Host getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(Host host) {
        this.localHost = host;
        this.localHostName = host.getHostName();
    }

    public List<OracleHome> getOracleHomes() {
        return this.homes;
    }

    public void setOracleHomes(List<OracleHome> list) {
        this.homes = list;
    }

    public OracleHome getHome(String string) {
        Iterator<OracleHome> iterator = this.homes.iterator();
        while (iterator.hasNext()) {
            OiipgFileSystem oiipgFileSystem = new OiipgFileSystem();
            OracleHome oracleHome = iterator.next();
            if (!oiipgFileSystem.areLocsSame(oracleHome.getPath(), string)) continue;
            return oracleHome;
        }
        return null;
    }

    public static LocalInfo getLocalInfoFromSystemInstance(SystemInstance systemInstance) {
        OracleHome oracleHome2;
        Object object2;
        LocalInfo localInfo = new LocalInfo();
        localInfo.setOracleHomes(new ArrayList<OracleHome>());
        for (Object object2 : systemInstance.getEntities()) {
            if (!(object2 instanceof OracleHome)) continue;
            oracleHome2 = (OracleHome)object2;
            localInfo.getOracleHomes().add(oracleHome2);
        }
        ArrayList arrayList = new ArrayList();
        for (OracleHome oracleHome2 : systemInstance.getEntities()) {
            if (!(oracleHome2 instanceof Host)) continue;
            Host host = (Host)oracleHome2;
            arrayList.add(host);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        object2 = HostComparatorCreator.getInstance();
        Collections.sort(arrayList, ((HostComparatorCreator)object2).getHostComparator());
        oracleHome2 = (Host)arrayList.get(0);
        localInfo.setLocalHostName(oracleHome2.getHostName());
        localInfo.setLocalHost((Host)oracleHome2);
        return localInfo;
    }
}

