/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.logger;

import com.oracle.cie.repository.common.RepositoryUtils;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class RepoLogger
extends Logger {
    private static ConsoleHandler cHandler = null;
    private FileHandler fHandler = null;

    protected RepoLogger(String name) {
        super(name, null);
    }

    public static RepoLogger getLogger(String name, Level level) {
        LogManager manager = LogManager.getLogManager();
        Logger tmp = manager.getLogger(name);
        if (tmp == null) {
            RepoLogger result = new RepoLogger(name);
            cHandler = new ConsoleHandler();
            result.addHandler(cHandler);
            result.setLevel(level);
            assert (manager.addLogger(result));
            return result;
        }
        return (RepoLogger)tmp;
    }

    public static RepoLogger getLogger(String name) {
        return RepoLogger.getLogger(name, Level.INFO);
    }

    @Override
    public void setLevel(Level logLevel) {
        Handler[] handlers;
        for (Handler handler : handlers = super.getHandlers()) {
            handler.setLevel(logLevel);
        }
        super.setLevel(logLevel);
    }

    public void setFileLogger(String logFile) throws SecurityException, IOException {
        if (this.fHandler == null) {
            RepositoryUtils.createFile(logFile);
            this.fHandler = new FileHandler(logFile);
            this.fHandler.setFormatter(new SimpleFormatter());
            this.fHandler.setLevel(this.getLevel());
            this.addHandler(this.fHandler);
        } else {
            Handler[] handlers;
            for (Handler handler : handlers = super.getHandlers()) {
                if (!(handler instanceof FileHandler)) continue;
                this.removeHandler(handler);
                RepositoryUtils.createFile(logFile);
                this.fHandler = new FileHandler(logFile);
                this.fHandler.setFormatter(new SimpleFormatter());
                this.fHandler.setLevel(this.getLevel());
                this.addHandler(this.fHandler);
            }
        }
    }
}

