/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.repository.common.RepositoryUtils;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.RestException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class CommonCommandLine {
    protected static Map<String, String> _additionalArguments;
    protected static Map<String, String> _additionalArgumentValues;

    public static Map<String, String> getAdditionalArguments() {
        return _additionalArguments;
    }

    public static Map<String, String> getAdditionalArgumentValues() {
        return _additionalArgumentValues;
    }

    public static String[] getAllArguments() {
        Argument[] defaultArgs = Argument.values();
        Map<String, String> additionalArgs = CommonCommandLine.getAdditionalArguments();
        int additionalArgsSize = additionalArgs != null ? additionalArgs.size() : 0;
        String[] args = new String[defaultArgs.length + additionalArgsSize];
        int x = 0;
        for (Argument arg : defaultArgs) {
            args[x] = arg.getArgument();
        }
        if (additionalArgs != null && !additionalArgs.isEmpty()) {
            for (String arg : additionalArgs.keySet()) {
                args[x] = "-" + arg;
            }
        }
        return args;
    }

    protected static RepoCommonConfig getRepoCommonConfig(String[] args) throws RepositoryCommonException, RestException, IOException, CommonCommandLineException {
        return CommonCommandLine.getRepoCommonConfig(args, (Map<String, String>)null);
    }

    protected static RepoCommonConfig getRepoCommonConfig(String[] args, String defaultLoggingDestination) throws RepositoryCommonException, RestException, IOException, CommonCommandLineException {
        return CommonCommandLine.getRepoCommonConfig(args, null, defaultLoggingDestination);
    }

    protected static RepoCommonConfig getRepoCommonConfig(Map<String, String> argMap) throws RepositoryCommonException, RestException, IOException, CommonCommandLineException {
        return CommonCommandLine.getRepoCommonConfig(argMap, null, null);
    }

    protected static RepoCommonConfig getRepoCommonConfig(String[] args, Map<String, String> additionalArguments) throws CommonCommandLineException, RestException, IOException, RepositoryCommonException {
        return CommonCommandLine.getRepoCommonConfig(args, additionalArguments, "stdout");
    }

    protected static RepoCommonConfig getRepoCommonConfig(String[] args, Map<String, String> additionalArguments, String defaultLoggingDestination) throws CommonCommandLineException, RestException, IOException, RepositoryCommonException {
        Map<String, String> argMap;
        try {
            argMap = RepositoryUtils.parseCommandLineArgs(args);
        }
        catch (RepositoryCommonException e) {
            throw new CommonCommandLineException(e.getMessage(), e);
        }
        return CommonCommandLine.getRepoCommonConfig(argMap, additionalArguments, defaultLoggingDestination);
    }

    protected static RepoCommonConfig getRepoCommonConfig(Map<String, String> argMap, Map<String, String> additionalArguments, String defaultLoggingDestination) throws CommonCommandLineException, RestException, IOException, RepositoryCommonException {
        Map<String, String> additionalArgs;
        _additionalArguments = additionalArguments;
        if (argMap == null || argMap.isEmpty()) {
            throw new CommonCommandLineException("No arguments specified. Please see usage for available arguments.");
        }
        RepositoryUtils.setupLogging(argMap, defaultLoggingDestination);
        File propertiesFile = null;
        if (argMap.containsKey(Argument.props.getArgument()) && !(propertiesFile = new File(argMap.remove(Argument.props.getArgument()))).exists()) {
            throw new CommonCommandLineException("The properties file specified did not exist: " + propertiesFile);
        }
        String repo = argMap.remove(Argument.repo.getArgument());
        String repoURL = argMap.remove(Argument.repoURL.getArgument());
        String cacheRepo = argMap.remove(Argument.localRepo.getArgument());
        String auxLocalRepos = argMap.remove(Argument.auxLocalRepos.getArgument());
        String readOnlyLocalRepos = argMap.remove(Argument.readOnlyLocalRepos.getArgument());
        String username = argMap.remove(Argument.username.getArgument());
        String password = argMap.remove(Argument.password.getArgument());
        String repoBaseDir = argMap.remove(Argument.repoBaseDir.getArgument());
        File repoBaseDirFile = null;
        if (!StringUtil.isNullOrEmpty((String)repoBaseDir, (boolean)true)) {
            repoBaseDirFile = new File(repoBaseDir);
        }
        if ((additionalArgs = CommonCommandLine.getAdditionalArguments()) != null && !additionalArgs.isEmpty()) {
            _additionalArgumentValues = new LinkedHashMap<String, String>();
            for (String string : additionalArgs.keySet()) {
                String argValue = argMap.remove("-" + string);
                if (argValue == null) continue;
                _additionalArgumentValues.put(string, argValue);
            }
        }
        Properties properties = RepoCommonConfig.loadProperties(propertiesFile);
        if (propertiesFile != null && !properties.containsKey("PROPERTIES_FILE_LOCATION")) {
            properties.setProperty("PROPERTIES_FILE_LOCATION", propertiesFile.getAbsolutePath());
        }
        if (!argMap.isEmpty()) {
            for (String key : argMap.keySet()) {
                for (String arg : CommonCommandLine.getAllArguments()) {
                    if (!key.equalsIgnoreCase(arg)) continue;
                    throw new CommonCommandLineException("The \"" + key + "\" argument which was specified conflicts with the known argument \"" + arg + "\".  Please check the case of the argument specified.");
                }
                properties.setProperty(key.substring(1).toUpperCase(), argMap.get(key));
            }
        }
        RepoCommonConfig repoCommonConfig = RepoCommonConfig.createRepoCommonConfig(repo, repoURL, cacheRepo, properties, repoBaseDirFile, username, password);
        repoCommonConfig.configureAuxLocalRepos(auxLocalRepos, readOnlyLocalRepos);
        return repoCommonConfig;
    }

    protected static void printUsage(Class clazz) {
        StringBuilder usage = new StringBuilder();
        usage.append("Usage: java").append(" ");
        usage.append(clazz.getName()).append(" ");
        usage.append(Argument.repoURL.getArgument()).append(" <repo-url>").append(" ");
        usage.append(Argument.username.getArgument()).append(" <username>").append(" ");
        usage.append(Argument.password.getArgument()).append(" <password>").append(" ");
        usage.append(Argument.localRepo.getArgument()).append(" <local-cache-repo>").append(" ");
        usage.append(Argument.auxLocalRepos.getArgument()).append(" <aux-cache-repos>").append(" ");
        usage.append(Argument.readOnlyLocalRepos.getArgument()).append(" <read-only-cache-repos>").append(" ");
        usage.append(Argument.props.getArgument()).append(" <").append(clazz.getSimpleName().toLowerCase()).append(".properties>").append(" ");
        usage.append(Argument.log.getArgument()).append(" <output.log>").append(" ");
        usage.append(Argument.logLevel.getArgument()).append(" <level>").append(" ");
        usage.append(Argument.repoBaseDir.getArgument()).append(" <repo-base-dir>").append(" ");
        Map<String, String> additionalArgs = CommonCommandLine.getAdditionalArguments();
        if (additionalArgs != null && !additionalArgs.isEmpty()) {
            for (String arg : additionalArgs.keySet()) {
                usage.append("-").append(arg).append(" ").append(additionalArgs.get(arg)).append(" ");
            }
        }
        usage.append("-propertyName <property-value>");
        System.out.println(usage);
    }

    public static enum Argument {
        log,
        logLevel,
        props,
        repoURL,
        localRepo,
        auxLocalRepos,
        readOnlyLocalRepos,
        username,
        password,
        repoBaseDir,
        repo;


        public String getArgument() {
            return "-" + this.name();
        }
    }

    public static class CommonCommandLineException
    extends Exception {
        public CommonCommandLineException(String message, Throwable cause) {
            super(message, cause);
        }

        public CommonCommandLineException(String message) {
            super(message);
        }
    }
}

