/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.ap;

import com.sun.tools.jxc.ConfigReader;
import com.sun.tools.jxc.ap.Const;
import com.sun.tools.jxc.ap.ErrorReceiverImpl;
import com.sun.tools.jxc.ap.Messages;
import com.sun.tools.jxc.api.JXC;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.J2SJAXBModel;
import com.sun.tools.xjc.api.Reference;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.xml.bind.SchemaOutputResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@SupportedAnnotationTypes(value={"javax.xml.bind.annotation.*"})
@SupportedOptions(value={"jaxb.config"})
public final class AnnotationParser
extends AbstractProcessor {
    private ErrorReceiver errorListener;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnv = processingEnv;
        this.errorListener = new ErrorReceiverImpl(processingEnv.getMessager(), processingEnv.getOptions().containsKey(Const.DEBUG_OPTION.getValue()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.processingEnv.getOptions().containsKey(Const.CONFIG_FILE_OPTION.getValue())) {
            String value = this.processingEnv.getOptions().get(Const.CONFIG_FILE_OPTION.getValue());
            StringTokenizer st = new StringTokenizer(value, File.pathSeparator);
            if (!st.hasMoreTokens()) {
                this.errorListener.error(null, Messages.OPERAND_MISSING.format(Const.CONFIG_FILE_OPTION.getValue()));
                return true;
            }
            while (st.hasMoreTokens()) {
                File configFile = new File(st.nextToken());
                if (!configFile.exists()) {
                    this.errorListener.error(null, Messages.NON_EXISTENT_FILE.format(new Object[0]));
                    continue;
                }
                try {
                    ArrayList<TypeElement> rootElements = new ArrayList<TypeElement>();
                    this.filterClass(rootElements, roundEnv.getRootElements());
                    ConfigReader configReader = new ConfigReader(this.processingEnv, rootElements, configFile, (ErrorHandler)this.errorListener);
                    Collection<Reference> classesToBeIncluded = configReader.getClassesToBeIncluded();
                    J2SJAXBModel model = JXC.createJavaCompiler().bind(classesToBeIncluded, Collections.emptyMap(), null, this.processingEnv);
                    SchemaOutputResolver schemaOutputResolver = configReader.getSchemaOutputResolver();
                    model.generateSchema(schemaOutputResolver, (ErrorListener)this.errorListener);
                }
                catch (IOException e) {
                    this.errorListener.error(e.getMessage(), (Exception)e);
                }
                catch (SAXException sAXException) {}
            }
        }
        return true;
    }

    private void filterClass(Collection<TypeElement> rootElements, Collection<? extends Element> elements) {
        for (Element element : elements) {
            if (!element.getKind().equals((Object)ElementKind.CLASS) && !element.getKind().equals((Object)ElementKind.INTERFACE) && !element.getKind().equals((Object)ElementKind.ENUM)) continue;
            rootElements.add((TypeElement)element);
            this.filterClass(rootElements, ElementFilter.typesIn(element.getEnclosedElements()));
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_6) > 0) {
            return SourceVersion.valueOf("RELEASE_7");
        }
        return SourceVersion.RELEASE_6;
    }
}

