/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.PrePostTreeVisitor;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.TreeFilter;
import com.oracle.cie.common.tree.TreeHelper;
import com.oracle.cie.common.tree.XMLTreeData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class XMLTreeWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Tree tree, File f) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            XMLTreeWriter.write(tree, fos);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(Tree tree, OutputStream os) throws IOException {
        XMLTreeWriter.write(tree, null, os);
    }

    public static void write(Tree tree, TreeFilter filter, OutputStream os) throws IOException {
        XMLTreeDataVisitor writer = new XMLTreeDataVisitor();
        TreeHelper.depthFirstTraversal(tree, writer, filter);
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        osw.write(writer.toString());
        osw.flush();
    }

    public static String asString(Tree tree) {
        return XMLTreeWriter.asString(tree, null);
    }

    public static String asString(Tree tree, TreeFilter filter) {
        XMLTreeDataVisitor writer = new XMLTreeDataVisitor();
        TreeHelper.depthFirstTraversal(tree, writer, filter);
        return writer.toString();
    }

    public static class XMLTreeDataVisitor
    implements PrePostTreeVisitor {
        private StringBuffer _sb = new StringBuffer();
        private int _tabCount = -1;

        @Override
        public void preVisitTree(Tree t, TreeFilter filter) {
            XMLTreeData data = (XMLTreeData)t.getData();
            ++this._tabCount;
            this._sb.append(this.getTab()).append("<").append(t.getId());
            this._sb.append(this.formatAttributes(data));
            if (t.isLeaf() && !data.hasText() && !data.hasComments()) {
                this._sb.append("/>\n");
            } else {
                this._sb.append(">");
                if (!data.hasText()) {
                    this._sb.append("\n");
                }
            }
        }

        @Override
        public void visitTree(Tree t, TreeFilter filter) {
            XMLTreeData data = (XMLTreeData)t.getData();
            if (data.hasText()) {
                this._sb.append(data.getText());
            }
            if (data.hasComments()) {
                ++this._tabCount;
                List<String> comments = data.getComments();
                for (String comment : comments) {
                    this._sb.append(this.getTab()).append("<!--").append(comment).append("-->");
                    if (data.hasText()) continue;
                    this._sb.append("\n");
                }
                --this._tabCount;
            }
        }

        @Override
        public void postVisitTree(Tree t, TreeFilter filter) {
            XMLTreeData data = (XMLTreeData)t.getData();
            if (!t.isLeaf() || data.hasText() || data.hasComments()) {
                if (!data.hasText()) {
                    this._sb.append(this.getTab());
                }
                this._sb.append("</").append(t.getId()).append(">\n");
            }
            --this._tabCount;
        }

        private String formatAttributes(XMLTreeData data) {
            StringBuffer sb = new StringBuffer();
            Properties attrs = data.getAttributes();
            Enumeration<Object> propEnum = attrs.keys();
            while (propEnum.hasMoreElements()) {
                String key = (String)propEnum.nextElement();
                String value = attrs.getProperty(key);
                sb.append(" ");
                sb.append(key).append("=\"").append(value).append("\"");
            }
            return sb.toString();
        }

        private String getTab() {
            String tab = "";
            for (int t = 0; t < this._tabCount; ++t) {
                tab = tab + "\t";
            }
            return tab;
        }

        public String toString() {
            return this._sb.toString();
        }
    }
}

