/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.jaxb;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JaxbJsonHandler {
    private static ObjectMapper _objectMapper;

    public static void saveJson(Object jaxbObject, File file) throws IOException {
        File parent;
        if (file != null && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        JaxbJsonHandler.getObjectWriter().writeValue(file, jaxbObject);
    }

    public static void saveJson(Object jaxbObject, OutputStream os) throws IOException {
        JaxbJsonHandler.getObjectWriter().writeValue(os, jaxbObject);
    }

    public static Object readJson(Class<?> jaxbClass, File file) throws IOException {
        return JaxbJsonHandler.getObjectMapper().readValue(file, jaxbClass);
    }

    public static Object readJson(Class<?> jaxbClass, InputStream is) throws IOException {
        return JaxbJsonHandler.getObjectMapper().readValue(is, jaxbClass);
    }

    private static ObjectWriter getObjectWriter() {
        return JaxbJsonHandler.getObjectMapper().writer(SerializationFeature.INDENT_OUTPUT);
    }

    private static ObjectReader getObjectReader() {
        return JaxbJsonHandler.getObjectMapper().reader();
    }

    private static ObjectMapper getObjectMapper() {
        if (_objectMapper == null) {
            _objectMapper = new ObjectMapper();
            _objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            _objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
            _objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector(_objectMapper.getTypeFactory());
            _objectMapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        }
        return _objectMapper;
    }
}

