/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.c14n.C14NImpl;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.NodeIterator;
import oracle.security.xmlsec.util.NodeListImpl;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DecryptTransform
extends XSTransformer {
    private static final boolean debug = System.getProperty("xml.debug.decrypt") != null;
    private static DocumentNavigator docNavigator = XMLUtils.getDocumentNavigator();
    private String algorithmURI;
    private boolean xmlMode = true;
    private ArrayList exceptList = new ArrayList();

    public DecryptTransform(XSAlgorithmIdentifier trans) {
        super(trans);
        this.algorithmURI = trans.getAlgorithm();
        if (!this.algorithmURI.startsWith("http://www.w3.org/2002/07/decrypt#")) {
            throw new IllegalArgumentException("Decryption Transform required");
        }
        if ("http://www.w3.org/2002/07/decrypt#XML".equals(this.algorithmURI)) {
            this.xmlMode = true;
        } else if ("http://www.w3.org/2002/07/decrypt#Binary".equals(this.algorithmURI)) {
            this.xmlMode = false;
        } else {
            throw new IllegalArgumentException("Unsupported algorithm: " + this.algorithmURI);
        }
        NodeList excList = trans.getParameters();
        int n = excList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = excList.item(i);
            if (this.isExcept(node)) {
                String uri = ((Element)node).getAttribute("URI");
                if (uri == null || uri.length() == 0) continue;
                this.exceptList.add(XMLUtils.getIdFromURI(uri));
                continue;
            }
            throw new IllegalArgumentException("Illegal Decryption Transform parameter " + node.getNodeName());
        }
    }

    @Override
    public String getAlgorithmURI() {
        return this.algorithmURI;
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        try {
            if (this.xmlMode) {
                return new XMLContainer(this.decryptXML(source.getNodeSet()));
            }
            return new XMLContainer(this.decryptBinary(source.getNodeSet()));
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
    }

    Set decryptXML(Set nodes) throws TransformationException {
        LinkedHashSet N = new LinkedHashSet(nodes);
        HashMap Y = this.decryptNodeSet(N);
        if (debug) {
            System.err.println("\n+++ DecryptTransform.decryptXML(Set):");
            System.err.println("+++ Y:\n" + this.toStringMap(Y));
        }
        String B = new C14NWithReplace(N, Y, null).canonicalize();
        if (debug) {
            System.err.println("B:\n" + B);
        }
        Set O = null;
        try {
            O = new XMLContainer(Utils.toUTF8((String)B)).getNodeSet();
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
        return O;
    }

    byte[] decryptBinary(Set nodes) throws TransformationException {
        ByteArrayOutputStream O = new ByteArrayOutputStream();
        try {
            List list = XMLUtils.toDocumentOrderList(nodes);
            NodeIterator D = new NodeIterator((Collection)list, new EncryptedDataFilter());
            while (D.hasNext()) {
                XEEncryptedData d = new XEEncryptedData((Element)D.next());
                O.write(d.decrypt());
            }
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (XEException ex) {
            throw new TransformationException(ex);
        }
        return O.toByteArray();
    }

    private HashMap decryptNodeSet(Set N) throws TransformationException {
        LinkedHashMap<Node, NodeList> Y = new LinkedHashMap<Node, NodeList>();
        List list = XMLUtils.toDocumentOrderList(N);
        if (debug) {
            System.err.println("\n+++ DecryptTransform.decryptNodeSet(Set N):");
            System.err.println("+++ N(doc order):\n" + XMLUtils.toStringNodes(list).replace(',', '\n'));
        }
        NodeIterator D = new NodeIterator((Collection)list, new EncryptedDataFilter());
        while (D.hasNext()) {
            XEEncryptedData d = new XEEncryptedData((Element)D.next());
            if (debug) {
                System.err.println("+++ d: " + XMLUtils.toStringNode(d.getNode()));
            }
            NodeList apexNodes = null;
            Set Od = null;
            try {
                apexNodes = d.decryptAndParse(N.contains(d.getParentNode()));
                Od = this.expandSubtrees(apexNodes);
            }
            catch (XEException ex) {
                throw new TransformationException(ex);
            }
            catch (XPathException ex) {
                throw new TransformationException(ex);
            }
            Y.put(d.getNode(), apexNodes);
            Y.putAll(this.decryptNodeSet(Od));
        }
        return Y;
    }

    private Set expandSubtrees(NodeList apexNodes) throws XPathException {
        LinkedHashSet nodeSet = new LinkedHashSet();
        int n = apexNodes.getLength();
        for (int i = 0; i < n; ++i) {
            nodeSet.addAll(XMLContainer.subtreeToNodeSet(apexNodes.item(i), true));
        }
        return nodeSet;
    }

    private boolean isExcept(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element element = (Element)node;
        return "http://www.w3.org/2002/07/decrypt#".equals(element.getNamespaceURI()) && "Except".equals(element.getLocalName());
    }

    private Node parentOf(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    private String toStringMap(Map map) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Node key = (Node)it.next();
                buf.append('{');
                buf.append(XMLUtils.toStringNode(key));
                buf.append(" --> ");
                buf.append(new NodeListImpl((NodeList)map.get(key)).toString());
                buf.append('}');
                if (!it.hasNext()) continue;
                buf.append(",\n");
            }
        }
        buf.append(']');
        return buf.toString();
    }

    class C14NWithReplace
    extends C14NImpl {
        private EncryptedDataFilter filter;
        private Set N;
        private HashMap Y;
        private SortedMap xmlAttrMap;

        public C14NWithReplace(Set N, HashMap Y, SortedMap xmlAttrMap) {
            super(true);
            this.filter = new EncryptedDataFilter();
            this.N = N;
            this.Y = Y;
            this.xmlAttrMap = xmlAttrMap;
        }

        public String canonicalize() throws CanonicalizationException {
            this.processNodeSet(this.N);
            return this.output.toString();
        }

        @Override
        protected void processElement(Element element, SortedMap inScopeNamespaces, SortedMap xmlAttributes) throws CanonicalizationException {
            if (debug) {
                System.err.println("\n+++ C14NWithReplace.processElement():");
                System.err.println("element=" + XMLUtils.toStringNode(element));
            }
            if (this.filter.matches(element) && this.Y.containsKey(element)) {
                try {
                    NodeList apexNodes = (NodeList)this.Y.get(element);
                    if (debug) {
                        System.err.println("apexNodes: " + XMLUtils.toStringNodes(new NodeListImpl(apexNodes)));
                    }
                    if (this.xmlAttrMap == null && apexNodes.getLength() > 0 && !this.N.contains(DecryptTransform.this.parentOf(element))) {
                        this.xmlAttrMap = C14NWithReplace.getAncestorXMLAttrs(element);
                    }
                    int len = apexNodes.getLength();
                    for (int i = 0; i < len; ++i) {
                        Node node = apexNodes.item(i);
                        if (this.xmlAttrMap != null && node.getNodeType() == 1) {
                            for (String attrName : this.xmlAttrMap.keySet()) {
                                Attr attr = (Attr)this.xmlAttrMap.get(attrName);
                                ((Element)node).setAttribute(attrName, attr.getNodeValue());
                            }
                        }
                        Set nodeSet = XMLContainer.subtreeToNodeSet(node, true);
                        C14NWithReplace c14n = new C14NWithReplace(nodeSet, this.Y, this.xmlAttrMap);
                        if (node.getNodeType() == 1 && !this.hasDefaultNS(node)) {
                            c14n.canonicalize();
                            int n = c14n.output.length();
                            for (int j = 0; j < n; ++j) {
                                char c = c14n.output.charAt(j);
                                if (c != ' ' && c != '>') continue;
                                c14n.output.insert(j, " xmlns=\"\"");
                                break;
                            }
                            this.output.append(c14n.output.toString());
                            continue;
                        }
                        this.output.append(c14n.canonicalize());
                    }
                    this.N.removeAll(XMLContainer.subtreeToNodeSet(element, true));
                    this.xmlAttrMap = null;
                }
                catch (XPathException ex) {
                    throw new CanonicalizationException(ex);
                }
            } else {
                super.processElement(element, inScopeNamespaces, xmlAttributes);
            }
        }

        private boolean hasDefaultNS(Node node) {
            Iterator nsIter = docNavigator.getNamespaceAxisIterator((Object)node);
            while (nsIter.hasNext()) {
                NamespaceNode ns = (NamespaceNode)nsIter.next();
                if (!"".equals(ns.getNodeName())) continue;
                return true;
            }
            return false;
        }
    }

    class EncryptedDataFilter
    extends NodeIterator.ElementFilter {
        public EncryptedDataFilter() {
            super("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        }

        @Override
        public boolean matches(Node node) {
            boolean match = super.matches(node) && !DecryptTransform.this.exceptList.contains(new XEEncryptedData((Element)node).getId());
            return match;
        }
    }
}

