/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.util.Vector;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.keys.AgreementMethod;
import oracle.security.xmlsec.keys.DHAgreementMethod;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XEKeyInfo
extends XSKeyInfo {
    public XEKeyInfo(Element element) throws DOMException {
        super(element);
    }

    public XEKeyInfo(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public XEKeyInfo(Document owner) throws DOMException {
        super(owner);
    }

    public XEKeyInfo(Document owner, String id) throws DOMException {
        super(owner, id);
    }

    public XEEncryptedKey createEncryptedKey() throws DOMException {
        XEEncryptedKey ek = new XEEncryptedKey(this.getOwnerDocument());
        ek.setSystemId(this.systemId);
        return ek;
    }

    public XEEncryptedKey createEncryptedKey(String id) throws DOMException {
        XEEncryptedKey ek = this.createEncryptedKey();
        ek.setId(id);
        return ek;
    }

    public DHAgreementMethod createDHAgreementMethod() throws DOMException {
        DHAgreementMethod am = new DHAgreementMethod(this.getOwnerDocument());
        am.setSystemId(this.systemId);
        return am;
    }

    public Vector getEncryptedKeys() {
        Vector<XEEncryptedKey> eks = new Vector<XEEncryptedKey>();
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            eks.addElement(new XEEncryptedKey((Element)nodes.item(i), this.systemId));
        }
        return eks;
    }

    public Vector getAgreementMethods() {
        Vector<AgreementMethod> ams = new Vector<AgreementMethod>();
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "AgreementMethod");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            ams.addElement(AgreementMethod.getInstance((Element)nodes.item(i), this.systemId));
        }
        return ams;
    }
}

