/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Vector;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.enc.OriginatorKeyInfo;
import oracle.security.xmlsec.enc.RecipientKeyInfo;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XECipherReference;
import oracle.security.xmlsec.enc.XEDataReference;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEEncryptionProperties;
import oracle.security.xmlsec.enc.XEEncryptionProperty;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XEKeyInfo;
import oracle.security.xmlsec.enc.XEKeyReference;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.keys.AgreementMethod;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.RetrievalMethod;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XEEncryptedObject
extends XMLElement {
    protected XEEncryptedObject(Element encElement) throws DOMException {
        super(encElement);
    }

    protected XEEncryptedObject(Element encElement, String systemId) throws DOMException {
        super(encElement, systemId);
    }

    protected XEEncryptedObject(Document doc, String tagName) throws DOMException {
        super(doc, "http://www.w3.org/2001/04/xmlenc#", tagName);
        String encPrefix = XMLElement.getDefaultNSPrefix("http://www.w3.org/2001/04/xmlenc#");
        if (encPrefix != null && encPrefix.length() != 0) {
            this.addNSPrefixAttrDefault("http://www.w3.org/2001/04/xmlenc#");
        }
    }

    public static XEEncryptedObject getInstance(Element encElement) throws DOMException {
        XMLElement eo = XMLUtils.getInstance(encElement);
        if (eo != null) {
            try {
                return (XEEncryptedObject)eo;
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
        throw new IllegalArgumentException("Unknown encrypted element: " + encElement.getTagName());
    }

    public static XEEncryptedObject getInstance(Element encElement, String systemId) throws DOMException {
        XEEncryptedObject eo = XEEncryptedObject.getInstance(encElement);
        eo.setSystemId(systemId);
        return eo;
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    public void setDataType(String typeURI) throws DOMException {
        this.setAttribute("Type", typeURI);
    }

    public String getDataType() {
        if (this.hasAttribute("Type")) {
            return this.getAttribute("Type");
        }
        return null;
    }

    public void setMimeType(String mimeType) throws DOMException {
        this.setAttribute("MimeType", mimeType);
    }

    public String getMimeType() {
        if (this.hasAttribute("MimeType")) {
            return this.getAttribute("MimeType");
        }
        return null;
    }

    public void setEncoding(String encoding) throws DOMException {
        this.setAttribute("Encoding", encoding);
    }

    public String getEncoding() {
        if (this.hasAttribute("Encoding")) {
            return this.getAttribute("Encoding");
        }
        return null;
    }

    public XEEncryptionMethod createEncryptionMethod(String algURI) throws DOMException {
        XEEncryptionMethod em = new XEEncryptionMethod(this.getOwnerDocument(), algURI);
        em.setSystemId(this.systemId);
        return em;
    }

    public XEKeyInfo createKeyInfo() throws DOMException {
        XEKeyInfo ki = new XEKeyInfo(this.getOwnerDocument());
        ki.setSystemId(this.systemId);
        return ki;
    }

    public XEKeyInfo createKeyInfo(String id) throws DOMException {
        XEKeyInfo ki = new XEKeyInfo(this.getOwnerDocument(), id);
        ki.setSystemId(this.systemId);
        return ki;
    }

    public OriginatorKeyInfo createOriginatorKeyInfo() throws DOMException {
        OriginatorKeyInfo oki = new OriginatorKeyInfo(this.getOwnerDocument());
        oki.setSystemId(this.systemId);
        return oki;
    }

    public RecipientKeyInfo createRecipientKeyInfo() throws DOMException {
        RecipientKeyInfo rki = new RecipientKeyInfo(this.getOwnerDocument());
        rki.setSystemId(this.systemId);
        return rki;
    }

    public XEDataReference createDataReference(String uri) throws DOMException {
        XEDataReference dr = new XEDataReference(this.getOwnerDocument(), uri);
        dr.setSystemId(this.systemId);
        return dr;
    }

    public XEKeyReference createKeyReference(String uri) throws DOMException {
        XEKeyReference kr = new XEKeyReference(this.getOwnerDocument(), uri);
        kr.setSystemId(this.systemId);
        return kr;
    }

    public XECipherData createCipherData(byte[] cipherValue) throws DOMException {
        XECipherData cd = this.createCipherData();
        cd.setCipherValue(cipherValue);
        return cd;
    }

    public XECipherData createCipherData() throws DOMException {
        XECipherData cd = new XECipherData(this.getOwnerDocument());
        cd.setSystemId(this.systemId);
        return cd;
    }

    public XECipherReference createCipherReference(String uri) throws DOMException {
        XECipherReference cr = new XECipherReference(this.getOwnerDocument(), uri);
        cr.setSystemId(this.systemId);
        return cr;
    }

    public XEEncryptionProperties createEncryptionProperties() throws DOMException {
        XEEncryptionProperties ep = new XEEncryptionProperties(this.getOwnerDocument());
        ep.setSystemId(this.systemId);
        return ep;
    }

    public XEEncryptionProperties createEncryptionProperties(String id) throws DOMException {
        XEEncryptionProperties encProps = this.createEncryptionProperties();
        encProps.setId(id);
        return encProps;
    }

    public XEEncryptionProperty createEncryptionProperty() throws DOMException {
        XEEncryptionProperty ep = new XEEncryptionProperty(this.getOwnerDocument());
        ep.setSystemId(this.systemId);
        return ep;
    }

    public XEEncryptionProperty createEncryptionProperty(String id) throws DOMException {
        XEEncryptionProperty encProp = this.createEncryptionProperty();
        encProp.setId(id);
        return encProp;
    }

    public void setEncryptionMethod(XEEncryptionMethod encMethod) throws DOMException {
        NodeList nodes = this.getChildElementsByTagName("*");
        boolean appended = false;
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if ("EncryptionMethod".equals(name)) {
                this.removeChild(node);
                continue;
            }
            if (appended || !"KeyInfo".equals(name) && !"CipherData".equals(name) && !"EncryptionProperties".equals(name) && !"ReferenceList".equals(name) && !"CarriedKeyName".equals(name)) continue;
            this.insertBefore(encMethod, node);
            appended = true;
        }
        if (!appended) {
            this.appendChild(encMethod);
        }
    }

    public XEEncryptionMethod getEncryptionMethod() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
        if (nodes.getLength() != 0) {
            return new XEEncryptionMethod((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setKeyInfo(XEKeyInfo keyInfo) throws DOMException {
        String prefix = keyInfo.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            keyInfo.addNSPrefixAttr(prefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        NodeList nodes = this.getChildElementsByTagName("*");
        boolean appended = false;
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if ("KeyInfo".equals(name)) {
                this.removeChild(node);
                continue;
            }
            if (appended || !"CipherData".equals(name) && !"EncryptionProperties".equals(name) && !"ReferenceList".equals(name) && !"CarriedKeyName".equals(name)) continue;
            this.insertBefore(keyInfo, node);
            appended = true;
        }
        if (!appended) {
            this.appendChild(keyInfo);
        }
    }

    public XEKeyInfo getKeyInfo() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (nodes.getLength() != 0) {
            return new XEKeyInfo((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setCipherData(XECipherData cipherData) throws DOMException {
        NodeList nodes = this.getChildElementsByTagName("*");
        boolean appended = false;
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if ("CipherData".equals(name)) {
                this.removeChild(node);
                continue;
            }
            if (appended || !"EncryptionProperties".equals(name) && !"ReferenceList".equals(name) && !"CarriedKeyName".equals(name)) continue;
            this.insertBefore(cipherData, node);
            appended = true;
        }
        if (!appended) {
            this.appendChild(cipherData);
        }
    }

    public XECipherData getCipherData() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
        if (nodes.getLength() != 0) {
            return new XECipherData((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public void setEncryptionProperties(XEEncryptionProperties encProps) throws DOMException {
        NodeList nodes = this.getChildElementsByTagName("*");
        boolean appended = false;
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            String name = node.getLocalName();
            if (name == null) {
                String tn = ((Element)node).getTagName();
                int j = tn.indexOf(":");
                String string = name = j == -1 ? tn : tn.substring(j + 1);
            }
            if ("EncryptionProperties".equals(name)) {
                this.removeChild(node);
                continue;
            }
            if ((appended || !"ReferenceList".equals(name)) && !"CarriedKeyName".equals(name)) continue;
            this.insertBefore(encProps, node);
            appended = true;
        }
        if (!appended) {
            this.appendChild(encProps);
        }
    }

    public XEEncryptionProperties getEncryptionProperties() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties");
        if (nodes.getLength() != 0) {
            return new XEEncryptionProperties((Element)nodes.item(0), this.systemId);
        }
        return null;
    }

    public Key getEncryptionKey() throws XEException {
        XEKeyInfo ki = this.getKeyInfo();
        XEEncryptionMethod em = this.getEncryptionMethod();
        if (em == null) {
            throw new XESchemaException("Missing EncryptionMethod element");
        }
        if (ki == null) {
            throw new XESchemaException("Missing KeyInfo element");
        }
        Key key = null;
        Vector ams = ki.getAgreementMethods();
        int len = ams.size();
        for (int i = 0; i < len; ++i) {
            AgreementMethod am = (AgreementMethod)ams.elementAt(i);
            PublicKey rPubKey = null;
            PrivateKey oPrivKey = null;
            OriginatorKeyInfo oki = am.getOriginatorKeyInfo();
            RecipientKeyInfo rki = am.getRecipientKeyInfo();
            if (oki == null || rki == null) continue;
            try {
                rPubKey = KeyRetriever.getPublicKey(rki);
                oPrivKey = KeyRetriever.getPrivateKey(oki);
            }
            catch (KeyRetrievalException ex) {
                throw new XECipherException(ex);
            }
            if (rPubKey == null || oPrivKey == null) continue;
            byte[] km = am.generateKeyMaterial(em, oPrivKey, rPubKey);
            key = new SecretKeySpec(km, em.getJCEKeyAlgorithm());
            break;
        }
        if (key == null) {
            try {
                key = em.getAlgorithm().equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || em.getAlgorithm().equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p") ? KeyRetriever.getPublicKey(ki) : KeyRetriever.getSymmetricKey(ki);
            }
            catch (KeyRetrievalException ex) {
                throw new XEException(ex);
            }
        }
        if (key == null) {
            throw new XEException("Could not retrieve encryption key");
        }
        return key;
    }

    public Key getDecryptionKey() throws XEException {
        Key decKey;
        int i;
        int len;
        XEKeyInfo ki = this.getKeyInfo();
        XEEncryptionMethod em = this.getEncryptionMethod();
        Key key = null;
        if (em == null) {
            throw new XESchemaException("Missing EncryptionMethod element.");
        }
        if (ki == null) {
            throw new XESchemaException("Missing KeyInfo element");
        }
        XEEncryptedKey ek = null;
        Vector eks = ki.getEncryptedKeys();
        if (eks.size() != 0) {
            ek = (XEEncryptedKey)eks.elementAt(0);
        } else {
            Vector rms = ki.getRetrievalMethods();
            len = rms.size();
            for (i = 0; i < len; ++i) {
                KeyInfoData kid = (KeyInfoData)rms.elementAt(i);
                try {
                    while ("http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod".equals(kid.getType())) {
                        kid = ((RetrievalMethod)kid).getKeyInfoData();
                    }
                }
                catch (ReferenceException ex) {
                    continue;
                }
                if (!"http://www.w3.org/2001/04/xmlenc#EncryptedKey".equals(kid.getType())) continue;
                ek = (XEEncryptedKey)kid;
                break;
            }
        }
        if (ek != null && (decKey = ek.getDecryptionKey()) != null) {
            key = ek.getKey(em, decKey);
        }
        if (key == null) {
            Vector ams = ki.getAgreementMethods();
            len = ams.size();
            for (i = 0; i < len; ++i) {
                AgreementMethod am = (AgreementMethod)ams.elementAt(i);
                PublicKey oPubKey = null;
                PrivateKey rPrivKey = null;
                OriginatorKeyInfo oki = am.getOriginatorKeyInfo();
                RecipientKeyInfo rki = am.getRecipientKeyInfo();
                if (oki != null && rki != null) {
                    try {
                        oPubKey = KeyRetriever.getPublicKey(oki);
                        rPrivKey = KeyRetriever.getPrivateKey(rki);
                    }
                    catch (KeyRetrievalException ex) {
                        throw new XECipherException(ex);
                    }
                }
                if (oPubKey == null || rPrivKey == null) continue;
                byte[] km = am.generateKeyMaterial(em, rPrivKey, oPubKey);
                key = new SecretKeySpec(km, em.getJCEKeyAlgorithm());
                break;
            }
        }
        if (key == null) {
            String algURI = em.getAlgorithm();
            try {
                key = algURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || algURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p") ? KeyRetriever.getPrivateKey(ki) : KeyRetriever.getSymmetricKey(ki);
            }
            catch (KeyRetrievalException ex) {
                throw new XECipherException(ex);
            }
        }
        if (key == null) {
            throw new XECipherException("Could not retrieve decryption key");
        }
        return key;
    }
}

