/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.logging;

import com.oracle.cie.common.util.reporting.CommonReporter;
import com.oracle.cie.common.util.reporting.ReportLevel;
import com.oracle.cie.common.util.reporting.ReporterType;
import com.oracle.cie.common.util.reporting.ReporterTypes;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;

public class LoggingReporter
extends CommonReporter {
    public LoggingReporter(Level level) {
        this(new ByteArrayOutputStream());
        if (level == null) {
            throw new NullPointerException("The Level provided was null.");
        }
        this._messageLoggingEnabled = true;
        this._messageLoggingLevel = level;
    }

    public LoggingReporter(ByteArrayOutputStream out) {
        super(out);
    }

    @Override
    public ReporterType getType() {
        return ReporterTypes.logging;
    }

    @Override
    protected String writeReportMessage(ReportLevel level, ReportMessage reportMessage) {
        return null;
    }

    @Override
    protected String writeReport(ReportLevel level, Report report) {
        return report != null ? report.toString() : null;
    }

    @Override
    protected void outputReport(ReportLevel level, Report report) {
        this.escapeReport(report);
        this.logOutput(report);
        this.unescapeReport(report);
    }

    @Override
    protected void outputReportMessage(ReportLevel level, ReportMessage reportMessage) {
        this.escapeReportMessage(reportMessage);
        this.logOutput(reportMessage);
        this.unescapeReportMessage(reportMessage);
    }
}

