/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class BasicFormatter
extends Formatter {
    private String lineSeparator = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        StringBuilder stringBuilder = new StringBuilder();
        if (record.getSourceClassName() != null) {
            stringBuilder.append(record.getSourceClassName());
        } else {
            stringBuilder.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(record.getSourceMethodName());
        }
        stringBuilder.append(this.lineSeparator);
        String message = this.formatMessage(record);
        stringBuilder.append(": ");
        stringBuilder.append(message);
        stringBuilder.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                stringBuilder.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }
}

