/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.a;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Utils;

public final class DES
extends BlockCipher {
    private static final int g = 8;
    private int[] h;
    private int[] i;
    private boolean j;
    private static final int[] k = new int[]{57, 49, 41, 33, 25, 17, 9, 1, 58, 50, 42, 34, 26, 18, 10, 2, 59, 51, 43, 35, 27, 19, 11, 3, 60, 52, 44, 36, 63, 55, 47, 39, 31, 23, 15, 7, 62, 54, 46, 38, 30, 22, 14, 6, 61, 53, 45, 37, 29, 21, 13, 5, 28, 20, 12, 4};
    private static final int[] l = new int[]{1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28};
    private static final int[] m = new int[]{14, 17, 11, 24, 1, 5, 3, 28, 15, 6, 21, 10, 23, 19, 12, 4, 26, 8, 16, 7, 27, 20, 13, 2, 41, 52, 31, 37, 47, 55, 30, 40, 51, 45, 33, 48, 44, 49, 39, 56, 34, 53, 46, 42, 50, 36, 29, 32};
    private static final int[] n = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static final int[][] o = new int[][]{{0x1010400, 0, 65536, 0x1010404, 0x1010004, 66564, 4, 65536, 1024, 0x1010400, 0x1010404, 1024, 0x1000404, 0x1010004, 0x1000000, 4, 1028, 0x1000400, 0x1000400, 66560, 66560, 0x1010000, 0x1010000, 0x1000404, 65540, 0x1000004, 0x1000004, 65540, 0, 1028, 66564, 0x1000000, 65536, 0x1010404, 4, 0x1010000, 0x1010400, 0x1000000, 0x1000000, 1024, 0x1010004, 65536, 66560, 0x1000004, 1024, 4, 0x1000404, 66564, 0x1010404, 65540, 0x1010000, 0x1000404, 0x1000004, 1028, 66564, 0x1010400, 1028, 0x1000400, 0x1000400, 0, 65540, 66560, 0, 0x1010004}, {-2146402272, -2147450880, 32768, 1081376, 0x100000, 32, -2146435040, -2147450848, -2147483616, -2146402272, -2146402304, Integer.MIN_VALUE, -2147450880, 0x100000, 32, -2146435040, 0x108000, 0x100020, -2147450848, 0, Integer.MIN_VALUE, 32768, 1081376, -2146435072, 0x100020, -2147483616, 0, 0x108000, 32800, -2146402304, -2146435072, 32800, 0, 1081376, -2146435040, 0x100000, -2147450848, -2146435072, -2146402304, 32768, -2146435072, -2147450880, 32, -2146402272, 1081376, 32, 32768, Integer.MIN_VALUE, 32800, -2146402304, 0x100000, -2147483616, 0x100020, -2147450848, -2147483616, 0x100020, 0x108000, 0, -2147450880, 32800, Integer.MIN_VALUE, -2146435040, -2146402272, 0x108000}, {520, 0x8020200, 0, 0x8020008, 0x8000200, 0, 131592, 0x8000200, 131080, 0x8000008, 0x8000008, 131072, 0x8020208, 131080, 0x8020000, 520, 0x8000000, 8, 0x8020200, 512, 131584, 0x8020000, 0x8020008, 131592, 0x8000208, 131584, 131072, 0x8000208, 8, 0x8020208, 512, 0x8000000, 0x8020200, 0x8000000, 131080, 520, 131072, 0x8020200, 0x8000200, 0, 512, 131080, 0x8020208, 0x8000200, 0x8000008, 512, 0, 0x8020008, 0x8000208, 131072, 0x8000000, 0x8020208, 8, 131592, 131584, 0x8000008, 0x8020000, 0x8000208, 520, 0x8020000, 131592, 8, 0x8020008, 131584}, {8396801, 8321, 8321, 128, 0x802080, 0x800081, 0x800001, 8193, 0, 0x802000, 0x802000, 8396929, 129, 0, 0x800080, 0x800001, 1, 8192, 0x800000, 8396801, 128, 0x800000, 8193, 8320, 0x800081, 1, 8320, 0x800080, 8192, 0x802080, 8396929, 129, 0x800080, 0x800001, 0x802000, 8396929, 129, 0, 0, 0x802000, 8320, 0x800080, 0x800081, 1, 8396801, 8321, 8321, 128, 8396929, 129, 1, 8192, 0x800001, 8193, 0x802080, 0x800081, 8193, 8320, 0x800000, 8396801, 128, 0x800000, 8192, 0x802080}, {256, 34078976, 0x2080000, 1107296512, 524288, 256, 0x40000000, 0x2080000, 1074266368, 524288, 0x2000100, 1074266368, 1107296512, 1107820544, 524544, 0x40000000, 0x2000000, 0x40080000, 0x40080000, 0, 0x40000100, 1107820800, 1107820800, 0x2000100, 1107820544, 0x40000100, 0, 0x42000000, 34078976, 0x2000000, 0x42000000, 524544, 524288, 1107296512, 256, 0x2000000, 0x40000000, 0x2080000, 1107296512, 1074266368, 0x2000100, 0x40000000, 1107820544, 34078976, 1074266368, 256, 0x2000000, 1107820544, 1107820800, 524544, 0x42000000, 1107820800, 0x2080000, 0, 0x40080000, 0x42000000, 524544, 0x2000100, 0x40000100, 524288, 0, 0x40080000, 34078976, 0x40000100}, {0x20000010, 0x20400000, 16384, 541081616, 0x20400000, 16, 541081616, 0x400000, 0x20004000, 0x404010, 0x400000, 0x20000010, 0x400010, 0x20004000, 0x20000000, 16400, 0, 0x400010, 536887312, 16384, 0x404000, 536887312, 16, 541065232, 541065232, 0, 0x404010, 0x20404000, 16400, 0x404000, 0x20404000, 0x20000000, 0x20004000, 16, 541065232, 0x404000, 541081616, 0x400000, 16400, 0x20000010, 0x400000, 0x20004000, 0x20000000, 16400, 0x20000010, 541081616, 0x404000, 0x20400000, 0x404010, 0x20404000, 0, 541065232, 16, 16384, 0x20400000, 0x404010, 16384, 0x400010, 536887312, 0, 0x20404000, 0x20000000, 0x400010, 536887312}, {0x200000, 0x4200002, 67110914, 0, 2048, 67110914, 0x200802, 69208064, 69208066, 0x200000, 0, 0x4000002, 2, 0x4000000, 0x4200002, 2050, 0x4000800, 0x200802, 0x200002, 0x4000800, 0x4000002, 0x4200000, 69208064, 0x200002, 0x4200000, 2048, 2050, 69208066, 0x200800, 2, 0x4000000, 0x200800, 0x4000000, 0x200800, 0x200000, 67110914, 67110914, 0x4200002, 0x4200002, 2, 0x200002, 0x4000000, 0x4000800, 0x200000, 69208064, 2050, 0x200802, 69208064, 2050, 0x4000002, 69208066, 0x4200000, 0x200800, 0, 2, 69208066, 0, 0x200802, 0x4200000, 2048, 0x4000002, 0x4000800, 2048, 0x200002}, {0x10001040, 4096, 262144, 0x10041040, 0x10000000, 0x10001040, 64, 0x10000000, 262208, 0x10040000, 0x10041040, 266240, 0x10041000, 266304, 4096, 64, 0x10040000, 0x10000040, 0x10001000, 4160, 266240, 262208, 0x10040040, 0x10041000, 4160, 0, 0, 0x10040040, 0x10000040, 0x10001000, 266304, 262144, 266304, 262144, 0x10041000, 4096, 64, 0x10040040, 4096, 266304, 0x10001000, 64, 0x10000040, 0x10040000, 0x10040040, 0x10000000, 262144, 0x10001040, 0, 0x10041040, 262208, 0x10000040, 0x10040000, 0x10001000, 0x10001040, 0, 0x10041040, 266240, 266240, 4160, 4160, 262208, 0x10000000, 0x10041000}};

    public DES() {
        super(8);
        this.d = 0;
        this.i = new int[2];
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        oracle.security.crypto.core.a.a(symmetricKey != null ? symmetricKey.getBitLength() - 8 : 0, 56);
        this.e = symmetricKey;
        this.j = false;
        this.c();
        this.f = randomBitsSource;
        this.a = null;
        this.a(algorithmIdentifier);
        this.c = iD;
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.desECB.getOID())) {
            this.d = 0;
        } else if (algorithmIdentifier.getOID().equals(AlgID.desCBC.getOID())) {
            this.d = 1;
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for DES");
        }
    }

    private void b(byte[] byArray) throws AlgorithmIdentifierException {
        try {
            if (byArray != null) {
                this.a(byArray);
            } else if (this.a == null) {
                this.a(this.b().randomBytes(new byte[this.getBlockSize()]));
            } else {
                this.a(this.a);
            }
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
    }

    private void a(boolean bl) {
        oracle.security.crypto.core.a.a(this.e != null ? this.e.getBitLength() - 8 : 0, 56);
        this.h = new int[32];
        DES.a(((SymmetricKey)this.e).d(), this.h, bl);
        this.j = true;
    }

    @Override
    protected void a(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (!this.j) {
            this.a(false);
        }
        DES.a(byArray, n, byArray2, n2, this.h, this.i);
    }

    @Override
    protected void b(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (!this.j) {
            this.a(true);
        }
        DES.a(byArray, n, byArray2, n2, this.h, this.i);
    }

    @Override
    public String algName() {
        return "DES" + (this.d == 1 ? "-CBC" : "");
    }

    @Override
    public void erase() {
        super.erase();
        Utils.setArray(this.h, 0);
        Utils.setArray(this.i, 0);
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.d == 0) {
            return AlgID.desECB;
        }
        if (this.d == 1) {
            return new CBCAlgorithmIdentifier(AlgID.desCBC.getOID(), this.getIV());
        }
        throw new IllegalStateException("Unknown mode " + this.d);
    }

    public String toString() {
        return this.algName();
    }

    static void a(byte[] byArray, int[] nArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int[] nArray2 = new int[56];
        int[] nArray3 = new int[56];
        int[] nArray4 = new int[8];
        for (n3 = 0; n3 < 56; ++n3) {
            n2 = k[n3] - 1;
            int n4 = n2 & 7;
            nArray2[n3] = (byArray[n2 >> 3] & DES.n[n4]) != 0 ? 1 : 0;
        }
        for (n = 0; n < 16; ++n) {
            Utils.setArray(nArray4, 0);
            for (n3 = 0; n3 < 56; ++n3) {
                n2 = n3 + l[n];
                nArray3[n3] = nArray2[n2 < (n3 < 28 ? 28 : 56) ? n2 : n2 - 28];
            }
            for (n3 = 0; n3 < 48; ++n3) {
                if (nArray3[m[n3] - 1] == 0) continue;
                n2 = n3 % 6;
                int n5 = n3 / 6;
                nArray4[n5] = nArray4[n5] | DES.n[n2] >> 2;
            }
            nArray[2 * n] = nArray4[0] << 24 | nArray4[2] << 16 | nArray4[4] << 8 | nArray4[6];
            nArray[2 * n + 1] = nArray4[1] << 24 | nArray4[3] << 16 | nArray4[5] << 8 | nArray4[7];
        }
        if (!bl) {
            for (n = 0; n < 16; n += 2) {
                int n6 = nArray[n];
                nArray[n] = nArray[30 - n];
                nArray[30 - n] = n6;
                n6 = nArray[n + 1];
                nArray[n + 1] = nArray[31 - n];
                nArray[31 - n] = n6;
            }
        }
        Utils.setArray(nArray2, 0);
        Utils.setArray(nArray3, 0);
        Utils.setArray(nArray4, 0);
    }

    private static void a(byte[] byArray, int n, int[] nArray) {
        nArray[0] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        nArray[1] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
    }

    private static void b(byte[] byArray, int n, int[] nArray) {
        byArray[n++] = (byte)(nArray[0] >> 24);
        byArray[n++] = (byte)(nArray[0] >> 16);
        byArray[n++] = (byte)(nArray[0] >> 8);
        byArray[n++] = (byte)nArray[0];
        byArray[n++] = (byte)(nArray[1] >> 24);
        byArray[n++] = (byte)(nArray[1] >> 16);
        byArray[n++] = (byte)(nArray[1] >> 8);
        byArray[n++] = (byte)nArray[1];
    }

    private static void a(int[] nArray) {
        nArray[1] = DES.a(nArray[1], 4);
        int n = (nArray[0] ^ nArray[1]) & 0xF0F0F0F0;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.b(nArray[1] ^ n, 20);
        n = (nArray[0] ^ nArray[1]) & 0xFFFF0000;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.b(nArray[1] ^ n, 18);
        n = (nArray[0] ^ nArray[1]) & 0x33333333;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.b(nArray[1] ^ n, 6);
        n = (nArray[0] ^ nArray[1]) & 0xFF00FF;
        nArray[0] = nArray[0] ^ n;
        nArray[1] = DES.a(nArray[1] ^ n, 9);
        n = (nArray[0] ^ nArray[1]) & 0xAAAAAAAA;
        nArray[0] = DES.a(nArray[0] ^ n, 1);
        nArray[1] = nArray[1] ^ n;
    }

    private static void b(int[] nArray) {
        nArray[1] = DES.b(nArray[1], 1);
        int n = (nArray[0] ^ nArray[1]) & 0xAAAAAAAA;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.b(nArray[0] ^ n, 9);
        n = (nArray[0] ^ nArray[1]) & 0xFF00FF;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.a(nArray[0] ^ n, 6);
        n = (nArray[0] ^ nArray[1]) & 0x33333333;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.a(nArray[0] ^ n, 18);
        n = (nArray[0] ^ nArray[1]) & 0xFFFF0000;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.a(nArray[0] ^ n, 20);
        n = (nArray[0] ^ nArray[1]) & 0xF0F0F0F0;
        nArray[1] = nArray[1] ^ n;
        nArray[0] = DES.b(nArray[0] ^ n, 4);
    }

    static void a(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray, int[] nArray2) {
        int n3;
        DES.a(byArray, n, nArray2);
        DES.a(nArray2);
        for (int i = 0; i < 8; ++i) {
            n3 = DES.b(nArray2[1], 4) ^ nArray[4 * i + 0];
            nArray2[0] = nArray2[0] ^ (o[6][n3 & 0x3F] ^ o[4][n3 >> 8 & 0x3F] ^ o[2][n3 >> 16 & 0x3F] ^ o[0][n3 >> 24 & 0x3F]);
            n3 = nArray2[1] ^ nArray[4 * i + 1];
            nArray2[0] = nArray2[0] ^ (o[7][n3 & 0x3F] ^ o[5][n3 >> 8 & 0x3F] ^ o[3][n3 >> 16 & 0x3F] ^ o[1][n3 >> 24 & 0x3F]);
            n3 = DES.b(nArray2[0], 4) ^ nArray[4 * i + 2];
            nArray2[1] = nArray2[1] ^ (o[6][n3 & 0x3F] ^ o[4][n3 >> 8 & 0x3F] ^ o[2][n3 >> 16 & 0x3F] ^ o[0][n3 >> 24 & 0x3F]);
            n3 = nArray2[0] ^ nArray[4 * i + 3];
            nArray2[1] = nArray2[1] ^ (o[7][n3 & 0x3F] ^ o[5][n3 >> 8 & 0x3F] ^ o[3][n3 >> 16 & 0x3F] ^ o[1][n3 >> 24 & 0x3F]);
        }
        nArray2[1] = DES.b(nArray2[1], 1);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xAAAAAAAA;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.b(nArray2[0] ^ n3, 9);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xFF00FF;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.a(nArray2[0] ^ n3, 6);
        n3 = (nArray2[0] ^ nArray2[1]) & 0x33333333;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.a(nArray2[0] ^ n3, 18);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xFFFF0000;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.a(nArray2[0] ^ n3, 20);
        n3 = (nArray2[0] ^ nArray2[1]) & 0xF0F0F0F0;
        nArray2[1] = nArray2[1] ^ n3;
        nArray2[0] = DES.b(nArray2[0] ^ n3, 4);
        int n4 = nArray2[0];
        nArray2[0] = nArray2[1];
        nArray2[1] = n4;
        DES.b(byArray2, n2, nArray2);
    }

    private static int a(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int b(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }
}

