/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizardx.gui.table.messages;

import com.oracle.cie.wizard.gui.msgpanel.MessageKey;
import com.oracle.cie.wizardx.gui.table.messages.TableCell;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TableComplexMessageKey
implements MessageKey {
    private Set<TableCell> associatedAddrList = new HashSet<TableCell>();

    public TableComplexMessageKey(TableCell address) {
        this.associatedAddrList.add(address);
    }

    public TableComplexMessageKey(Collection<TableCell> addresses) {
        this.associatedAddrList.addAll(addresses);
    }

    public void add(TableCell address) {
        if (address != null) {
            this.associatedAddrList.add(address);
        }
    }

    public void addAll(Collection<TableCell> addresses) {
        if (addresses != null) {
            this.associatedAddrList.addAll(addresses);
        }
    }

    public Set<TableCell> getAssociatedAddresses() {
        return Collections.unmodifiableSet(this.associatedAddrList);
    }

    public boolean equals(Object obj) {
        return this == obj || obj.getClass().isAssignableFrom(TableComplexMessageKey.class) && this.associatedAddrList.containsAll(((TableComplexMessageKey)TableComplexMessageKey.class.cast(obj)).getAssociatedAddresses()) && ((TableComplexMessageKey)TableComplexMessageKey.class.cast(obj)).getAssociatedAddresses().containsAll(this.getAssociatedAddresses());
    }

    public int hashCode() {
        return this.associatedAddrList.hashCode();
    }

    public boolean contains(int row, int column) {
        for (TableCell cell : this.associatedAddrList) {
            if (cell.getRow() != row && cell.getRow() != -1 && row != -1 || cell.getCol() != column && cell.getCol() != -1 && column != -1) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.associatedAddrList.toString();
    }
}

