/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.Branch;
import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.FlowPropertyListener;
import com.oracle.cie.wizard.internal.wcf.Subflow;
import com.oracle.cie.wizard.internal.wcf.WCFElement;
import com.oracle.cie.wizard.internal.wcf.WCFElementExecutionState;
import com.oracle.cie.wizard.internal.wcf.xml.BranchType;
import com.oracle.cie.wizard.internal.wcf.xml.SwitchType;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

class SwitchElem
extends EntryElem<SwitchType>
implements FlowPropertyListener {
    protected Map<String, Branch> _branches = new LinkedHashMap<String, Branch>();
    protected String _propertyName = ((SwitchType)this.getXmlObject()).getProperty();
    protected boolean _lazyExpansionState = ((SwitchType)this.getXmlObject()).isLazyExpansion();
    protected String _defaultBranchName;
    protected Branch _defaultBranch;

    SwitchElem(Subflow<?> sequence, SwitchType entry) throws ExecPlanException {
        super(sequence, entry);
        for (BranchType branch : ((SwitchType)this.getXmlObject()).getBranches()) {
            Branch branchWrapper = new Branch(this, branch);
            if (this._branches.containsKey(branch.getName())) {
                this._log.warning("WCF [" + this.getParentTarget().getWCFParent().getWcFileName() + "] target [" + this.getParentTarget().getName() + "] switch [" + this._propertyName + "] contains duplicate branches [" + branch.getName() + "].");
                continue;
            }
            this._branches.put(branch.getName(), branchWrapper);
        }
        this._defaultBranchName = ((SwitchType)this.getXmlObject()).getDefaultBranch();
        if (this._defaultBranchName != null) {
            this._defaultBranch = this._branches.get(this._defaultBranchName);
        } else {
            this._log.log(Level.FINER, "WCF [" + this.getParentTarget().getWCFParent().getWcFileName() + "] target [" + this.getParentTarget().getName() + "] switch [" + this._propertyName + "] has no default branch defined.");
        }
        if (this._branches.isEmpty()) {
            this._log.warning("WCF [" + this.getParentTarget().getWCFParent().getWcFileName() + "] target [" + this.getParentTarget().getName() + "] switch [" + this._propertyName + "] has no branches defined.");
        }
        if (!this._branches.isEmpty() && this._defaultBranchName != null && this._defaultBranch == null) {
            this._log.warning("WCF [" + this.getParentTarget().getWCFParent().getWcFileName() + "] target [" + this.getParentTarget().getName() + "] switch [" + this._propertyName + "] references undefined default Branch [" + this._defaultBranchName + "].");
        }
        if (this._defaultBranch != null) {
            this._log.finer("WCF [" + this.getParentTarget().getWCFParent().getWcFileName() + "] target [" + this.getParentTarget().getName() + "] switch [" + this._propertyName + "] default branch [" + this._defaultBranchName + "]" + (this._lazyExpansionState ? " is set to expand lazily" : " will be loaded."));
        }
    }

    @Override
    public List<WCFElement> getDefaultElementList() throws ExecPlanException {
        Subflow<?> branch;
        ArrayList<WCFElement> list = new ArrayList<WCFElement>();
        list.add(this);
        if (!this._lazyExpansionState && (branch = this.getBranch(this.getWorkflow().getFlowProperty(this._propertyName))) != null) {
            list.addAll(branch.getDefaultElementList());
        }
        return list;
    }

    @Override
    public void selectedOnNext() throws ExecPlanException {
        super.selectedOnNext();
        if (this._lazyExpansionState) {
            this._lazyExpansionState = false;
            this.selectBranch(this.getWorkflow().getFlowProperty(this._propertyName));
        }
    }

    @Override
    public void selectedOnPrev() throws ExecPlanException {
        super.selectedOnPrev();
        if (((SwitchType)this.getXmlObject()).isLazyExpansion()) {
            this._lazyExpansionState = true;
            this.updateWorkflow(this.getCurrentBranch(), null);
        }
    }

    @Override
    public void addingToWorkflow() throws ExecPlanException {
        super.addingToWorkflow();
        this.getWorkflow().addFlowPropertyListener(this);
    }

    @Override
    public void removedFromWorkflow() throws ExecPlanException {
        super.removedFromWorkflow();
        this.getWorkflow().removeFlowPropertyListener(this);
    }

    @Override
    public void propertyValueChanged(String name, String oldValue, String newValue) {
        if (this._propertyName != null && this._propertyName.equals(name)) {
            try {
                this.selectBranch(newValue);
            }
            catch (ExecPlanException ex) {
                this._log.log(Level.SEVERE, "Unable to expand branch " + newValue, ex);
            }
        }
    }

    public Collection<String> getBranchKeys() {
        return Collections.unmodifiableCollection(this._branches.keySet());
    }

    public List<EntryElem<?>> getBranchEntries(String branchName) {
        return this._branches.get(branchName).getEntries();
    }

    public Branch getDefaultBranch() {
        return this._defaultBranch;
    }

    public String getDefaultBranchName() {
        return this._defaultBranchName;
    }

    void selectBranch(String branchKey) throws ExecPlanException {
        Subflow<?> newBranch = this.getBranch(branchKey);
        Subflow<?> currBranch = this.getCurrentBranch();
        if (currBranch == newBranch) {
            this._log.finer(currBranch == this._defaultBranch ? "Default branch ".concat(this._lazyExpansionState ? " will be expanded lazily" : " is already expanded.") : "Branch [" + ((BranchType)((Branch)Branch.class.cast(currBranch)).getXmlSequence()).getName() + "]".concat(this._lazyExpansionState ? " will be expanded lazily" : " is already expanded."));
        } else {
            this.updateWorkflow(currBranch, newBranch);
        }
    }

    private Subflow<?> getBranch(String branchKey) {
        Subflow newBranch = null;
        if (branchKey == null) {
            this._log.finer("Branch key has been unset. " + (branchKey == null ? "No branch to expand." : (this._defaultBranchName != null ? "Will expand default [" + this._defaultBranchName + "] branch".concat(this._lazyExpansionState ? " lazily." : ".") : "")));
            branchKey = this._defaultBranchName;
        }
        if (branchKey != null && (newBranch = (Subflow)this._branches.get(branchKey)) == null) {
            this._log.finer("Branch [" + branchKey + "] is not defined existing subflow will be removed.");
        }
        return newBranch;
    }

    private Subflow<?> getCurrentBranch() {
        WCFElement elem = this.getWorkflow().getElementAfter(this);
        if (elem != null && (Branch.class.isAssignableFrom(elem.getClass()) && this._branches.containsValue(Branch.class.cast(elem)) || this._defaultBranch == elem)) {
            return (Subflow)Subflow.class.cast(elem);
        }
        return null;
    }

    private void updateWorkflow(Subflow<?> currBranch, Subflow<?> newBranch) throws ExecPlanException {
        boolean canModifyBranch;
        WCFElementExecutionState executionState = this.getWorkflow().getExecutionState(this);
        boolean bl = canModifyBranch = executionState.equals((Object)WCFElementExecutionState.WAITING_FOR_EXECUTION) || executionState.equals((Object)WCFElementExecutionState.CURRENTLY_EXECUTING);
        if (currBranch != null && canModifyBranch) {
            this._log.finer(this._defaultBranch == currBranch ? "Removing default branch." : "Removing branch [" + ((BranchType)((Branch)Branch.class.cast(currBranch)).getXmlSequence()).getName() + "].");
            this.getWorkflow().removeSubflow(currBranch);
        }
        if (newBranch != null && !this._lazyExpansionState && canModifyBranch) {
            this._log.finer(this._defaultBranch == newBranch ? "Adding default branch." : "Adding branch [" + ((BranchType)((Branch)Branch.class.cast(newBranch)).getXmlSequence()).getName() + "].");
            this.getWorkflow().addSubflow(this, newBranch);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" switch: ").append(this._propertyName);
        return sb.toString();
    }
}

