/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.cont;

import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.WizardState;
import com.oracle.cie.wizard.event.WizardStateChangeEvent;
import com.oracle.cie.wizard.event.WizardStateChangeListener;
import com.oracle.cie.wizard.internal.cont.TaskContainer;
import com.oracle.cie.wizard.tasks.Task;
import com.oracle.cie.wizard.tasks.TaskContext;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import com.oracle.cie.wizard.tasks.TraversalMode;

abstract class AbstractTaskContainer<CI extends TaskContext, T extends Task<CI>, TC extends CI>
implements TaskContainer<CI, T>,
WizardStateChangeListener {
    protected ControllerProxy _proxy;
    protected TC _context;
    protected T _task;
    protected TraversalMode _traversalMode;

    AbstractTaskContainer() {
    }

    @Override
    public void init(ControllerProxy proxy) {
        this._proxy = proxy;
        this._proxy.addWizardStateChangeListener(this);
        this._context = this.createTaskContext();
    }

    @Override
    public ControllerProxy getProxy() {
        return this._proxy;
    }

    @Override
    public void setTask(T task, TraversalMode direction) {
        this._traversalMode = direction;
        this._task = task;
        this.doConfigureTask();
    }

    @Override
    public T getCurrentTask() {
        return this._task;
    }

    @Override
    public abstract boolean bypassTask() throws WizardException;

    @Override
    public void keepRunningTask() {
    }

    @Override
    public void unconfigureTask() {
        this._traversalMode = null;
        this.doUnconfigureTask();
        this._task = null;
    }

    @Override
    public boolean handlesFatalErrorExit() {
        return false;
    }

    @Override
    public void stateChanged(WizardStateChangeEvent e) {
        switch (e.getNewState()) {
            case CREATED: 
            case CONFIGURED: {
                break;
            }
            case SUSPENDED: {
                if (e.getOldState() != WizardState.RUNNING) break;
                this.suspendTask();
                break;
            }
            case RUNNING: {
                if (e.getOldState() != WizardState.SUSPENDED) break;
                this.resumeTask();
                break;
            }
            case ERROR: {
                this.handleError();
                break;
            }
            case SHUTTING_DOWN: {
                this.handleExit();
                break;
            }
            case CLEANUP: {
                this.handleCleanup();
                break;
            }
            case TERMINATED: {
                this.handleTermination();
            }
        }
    }

    protected abstract TC createTaskContext();

    protected void doConfigureTask() {
        try {
            this._task.configure(this._context);
        }
        catch (TaskExecutionException e) {
            this._proxy.error(WizardCompletionInfo.getInstance().getFatalErrorCode(), e);
        }
    }

    protected void doUnconfigureTask() {
        this._task.unconfigure();
    }

    protected void suspendTask() {
        if (this._task != null) {
            this._task.suspend();
        }
    }

    protected void resumeTask() {
        if (this._task != null) {
            this._task.resume();
        }
    }

    protected void handleError() {
    }

    protected void handleExit() {
        if (this._task != null) {
            this._task.exiting();
        }
    }

    protected void handleCleanup() {
    }

    protected void handleTermination() {
    }

    @Override
    public TraversalMode getTraversalMode() {
        return this._traversalMode;
    }
}

