/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.help;

import com.oracle.cie.wizard.help.HelpDelegate;
import com.oracle.cie.wizard.help.HelpProvider;
import com.oracle.cie.wizard.help.HelpProviderException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.help.Help;
import oracle.help.library.Book;
import oracle.help.library.helpset.HelpSet;
import oracle.help.library.helpset.HelpSetParseException;

public class DefaultHelpProvider
implements HelpProvider {
    protected static final Logger _log = Logger.getLogger(DefaultHelpProvider.class.getName());
    protected Help help;
    protected HelpSet helpSet;

    @Override
    public void init(String helpJarName, String helpContent, String helpJarLoc) throws HelpProviderException {
        _log.fine("Initializing help implementation....");
        Locale locale = Locale.getDefault();
        URL helpURL = this.findLocalizedHelpset(helpJarLoc, helpContent, helpJarName, locale);
        if (helpURL == null) {
            throw new HelpProviderException("The oracle help content jar " + helpJarName + " is missing for " + locale + " locale.");
        }
        _log.fine("Localized Help jar URL:" + helpURL);
        if (this.help == null) {
            this.help = new Help();
            try {
                this.helpSet = new HelpSet(helpURL);
            }
            catch (NullPointerException e) {
                throw new HelpProviderException("The oracle help jar is null. Please check the Oracle Help content jar. The help jar location specified is: ", e);
            }
            catch (HelpSetParseException e) {
                throw new HelpProviderException("Unable to load the help book: Exception being thrown from help jars.The help jar location specified is: " + helpURL.toString(), e);
            }
            catch (Throwable e) {
                throw new HelpProviderException("Error occured in the oracle Help jars. Please contact the Oracle Help team.", e);
            }
            try {
                this.help.addBook((Book)this.helpSet);
            }
            catch (Throwable e) {
                throw new HelpProviderException("Error occured in the oracle Help jars. Please contact the Oracle Help team.", e);
            }
        }
        throw new HelpProviderException("The oracle help module has been initialized. It will not be re-instantiated.");
    }

    @Override
    public void showHelp(HelpDelegate delegate) throws HelpProviderException {
        String key = delegate.getHelpTopicKey();
        try {
            if (key != null) {
                if ("".equalsIgnoreCase(key)) {
                    this.help.showNavigatorWindow();
                } else {
                    this.help.showTopic((Book)this.helpSet, key);
                }
            } else {
                this.help.showNavigatorWindow();
            }
        }
        catch (Throwable e) {
            this.help.showNavigatorWindow();
            throw new HelpProviderException("Error in Loading the help files for the particular topic. Opening the General Contents Window.", e);
        }
    }

    private URL findLocalizedHelpset(String baseURL, String helpSetFileName, String helpSetJarName, Locale locale) {
        URL url = this.findURLForGivenLocale(baseURL, helpSetFileName, helpSetJarName, locale);
        if (url == null) {
            String asIsStringURL = baseURL + helpSetJarName + "!/" + helpSetFileName;
            url = this.checkURLFileExists(asIsStringURL);
        }
        return url;
    }

    private URL findURLForGivenLocale(String baseURL, String helpSetFileName, String helpSetJarName, Locale locale) {
        String[] splittedVal = helpSetJarName.split("\\.");
        String helpSetJarPrefix = splittedVal[0];
        String helpSetJarSuffix = splittedVal[1];
        URL url = null;
        if (locale != null) {
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            StringBuilder buffer = new StringBuilder(baseURL);
            buffer.append(helpSetJarPrefix);
            if (language != null && language.length() > 0) {
                StringBuilder languageStringURL = new StringBuilder(buffer);
                languageStringURL.append("_").append(language).append(".").append(helpSetJarSuffix).append("!/").append(helpSetFileName);
                if (country != null && country.length() > 0) {
                    StringBuilder countryStringURL = new StringBuilder(buffer);
                    countryStringURL.append("_").append(language).append("_").append(country).append(".").append(helpSetJarSuffix).append("!/").append(helpSetFileName);
                    if (variant != null && variant.length() > 0) {
                        StringBuilder variantStringURL = new StringBuilder(buffer);
                        variantStringURL.append("_").append(language).append("_").append(country).append("_").append(variant).append(".").append(helpSetJarSuffix).append("!/").append(helpSetFileName);
                        url = this.checkURLFileExists(variantStringURL.toString());
                    }
                    if (url == null) {
                        url = this.checkURLFileExists(countryStringURL.toString());
                    }
                }
                if (url == null) {
                    url = this.checkURLFileExists(languageStringURL.toString());
                }
            }
        }
        return url;
    }

    private URL checkURLFileExists(String url) {
        URL checkedURL = null;
        try {
            checkedURL = new URL(url);
            checkedURL.openStream().close();
        }
        catch (Exception e) {
            checkedURL = null;
        }
        return checkedURL;
    }
}

