/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.tasks;

import com.oracle.cie.common.util.PublishedMessage;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ext.ComponentMessage;
import com.oracle.cie.wizard.ext.CustomPanelCallbackHandler;
import com.oracle.cie.wizard.ext.CustomPanelComponentCallback;
import com.oracle.cie.wizard.ext.GUICustomPanelHelper;
import com.oracle.cie.wizard.ext.impl.OperationInputImpl;
import com.oracle.cie.wizard.ext.panel.ComponentWrapper;
import com.oracle.cie.wizard.ext.panel.CustomComponentFactory;
import com.oracle.cie.wizard.ext.panel.CustomPanelParser;
import com.oracle.cie.wizard.ext.panel.FileTypeComponent;
import com.oracle.cie.wizard.ext.panel.NotifyComponent;
import com.oracle.cie.wizard.ext.panel.WorkflowComponent;
import com.oracle.cie.wizard.ext.panel.xml.ComponentsType;
import com.oracle.cie.wizard.ext.panel.xml.DisplayType;
import com.oracle.cie.wizard.ext.panel.xml.EditableChoiceType;
import com.oracle.cie.wizard.ext.panel.xml.FileType;
import com.oracle.cie.wizard.ext.panel.xml.PanelType;
import com.oracle.cie.wizard.ext.panel.xml.RowType;
import com.oracle.cie.wizard.ext.panel.xml.SupportedAxisType;
import com.oracle.cie.wizard.ext.panel.xml.TableType;
import com.oracle.cie.wizard.ext.panel.xml.TextInputType;
import com.oracle.cie.wizard.ext.panel.xml.UIType;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.msgpanel.MessageType;
import com.oracle.cie.wizard.gui.tasks.AbstractGUITask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

@TaskDescription(name="custom_panel")
public class CustomPanelGUITask
extends AbstractGUITask {
    private String _configFile;
    private PanelType _panel;
    private Map<String, ComponentWrapper> _customCompWrappers;
    private Map<JComponent, ComponentWrapper> _workFlowComponents;
    private GUICustomPanelHelper _helper;
    private CustomPanelCallbackHandler _callbackHandler;
    private CustomPanelComponentCallback _callback;
    private String _panelHelperClass;
    private String _callbackHandlerClassName;
    private static final String CUSTOM_COMPONENTS = "CUSTOM_COMPONENTS";

    @TaskAttribute(required=true, type=TaskAttributeType.LITERAL)
    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.ext.GUICustomPanelHelper"}, required=true)
    public void setPanelHelperClass(String helperClassName) {
        this._panelHelperClass = helperClassName;
    }

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.ext.CustomPanelCallbackHandler"}, required=false)
    public void setCallbackHandlerClass(String callbackHandlerClassName) {
        this._callbackHandlerClassName = callbackHandlerClassName;
    }

    @Override
    public void configure(GUITaskContext context) throws TaskExecutionException {
        super.configure(context);
        try {
            ClassLoader classLoader = CustomPanelGUITask.class.getClassLoader();
            Class<?> loaderClass = classLoader.loadClass(this._panelHelperClass);
            this._helper = (GUICustomPanelHelper)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this._helper == null) {
                throw new TaskExecutionException(this, ((GUITaskContext)this._context).getPublishedMessage(this._namespace, "64040", this._panelHelperClass).getFullMessage());
            }
            this._panel = new CustomPanelParser().parse(classLoader.getResourceAsStream(this._configFile));
            if (this._callbackHandlerClassName != null) {
                Class<?> loadedCallbackClass = classLoader.loadClass(this._callbackHandlerClassName);
                this._callbackHandler = (CustomPanelCallbackHandler)loadedCallbackClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (this._callbackHandler == null) {
                    throw new TaskExecutionException(this, ((GUITaskContext)this._context).getPublishedMessage(this._namespace, "64040", this._callbackHandlerClassName).getFullMessage());
                }
            }
        }
        catch (TaskExecutionException e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new TaskExecutionException(this, ((GUITaskContext)this._context).getPublishedMessage(this._namespace, "64041", this._configFile, e.getMessage()).getFullMessage(), e);
        }
        this._customCompWrappers = new HashMap<String, ComponentWrapper>();
    }

    @Override
    public JComponent createUI() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        List<Object> cTypes = this._panel.getComponentsOrTable();
        int maxGridWidth = this.getMaxWidth(cTypes);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        mainPanel.add(Box.createGlue(), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        for (Object ocType : cTypes) {
            if (ocType instanceof ComponentsType) {
                gbc.gridwidth = maxGridWidth;
                ComponentsType cType = (ComponentsType)ocType;
                mainPanel.add((Component)this.getComponentPanel(cType), gbc);
            } else {
                gbc.gridx = 0;
                TableType tType = (TableType)ocType;
                List<RowType> rows = tType.getRow();
                gbc.gridx = 0;
                gbc.gridwidth = 1;
                ++gbc.gridy;
                for (RowType row : rows) {
                    gbc.gridx = 0;
                    gbc.gridwidth = 1;
                    for (ComponentsType comps : row.getComponents()) {
                        gbc.gridwidth = comps.getColspan();
                        if (comps.getColumn() > 0) {
                            gbc.gridx += comps.getColumn() - 1;
                        }
                        mainPanel.add((Component)this.getComponentPanel(comps), gbc);
                        ++gbc.gridx;
                    }
                    ++gbc.gridy;
                }
            }
            gbc.weighty = 0.0;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.fill = 2;
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = maxGridWidth;
        mainPanel.add(Box.createGlue(), gbc);
        String key = this._panel.getLoadMessageKey();
        if (key != null && !key.isEmpty()) {
            String message = ((GUITaskContext)this.getContext()).getI18nString(this._namespace, key);
            if (message != null && !message.isEmpty()) {
                ((GUITaskContext)this.getContext()).getMessagePanel().setNonValidationMessage(null, MessageType.INFORMATION, message);
            } else {
                this._logger.warning("message for key " + key + " is not on the properties");
            }
        }
        if (this._callbackHandler != null) {
            for (String componentID : this.getComponentIDValueMap(false, false).keySet()) {
                this._callbackHandler.handle(this.getCallback(), componentID);
            }
        }
        JScrollPane pane = new JScrollPane(mainPanel, 20, 31);
        return pane;
    }

    private JPanel getComponentPanel(ComponentsType cType) {
        JPanel compPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weighty = 0.0;
        List<UIType> uiTypes = cType.getTextInputOrLabelOrText();
        int noOfUIComps = uiTypes.size();
        CustomComponentFactory factory = new CustomComponentFactory(this._namespace, this._helper);
        for (UIType type : uiTypes) {
            if (cType.getAxis().equals((Object)SupportedAxisType.Y)) {
                ++gbc.gridy;
                gbc.gridx = 0;
            } else {
                ++gbc.gridx;
                gbc.gridy = 0;
            }
            gbc.insets = new Insets(noOfUIComps == uiTypes.size() ? 10 : 8, 10, 0, 0);
            List<ComponentWrapper> compWrappers = factory.getComponents(type);
            int countComps = 1;
            for (ComponentWrapper compWrapper : compWrappers) {
                JComponent component = compWrapper.getComponent();
                if (cType.getAxis().equals((Object)SupportedAxisType.Y)) {
                    gbc.fill = this.getGridBagFill(component, type);
                }
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).getDocument().addDocumentListener(new ComponentDocumentListener(component));
                } else if (component instanceof FileTypeComponent) {
                    ((FileTypeComponent)component).addDocumentListener(new ComponentDocumentListener(component));
                }
                if (!StringUtil.isNullOrEmpty((String)compWrapper.getID())) {
                    this._customCompWrappers.put(compWrapper.getID(), compWrapper);
                }
                this.registerListener(compWrapper);
                if (compWrapper.getID() != null) {
                    compWrapper.setValue(this.getComponentValue(compWrapper.getID()));
                }
                if (this._customCompWrappers.containsKey(compWrapper.getID())) {
                    compWrapper.setValue(this._customCompWrappers.get(compWrapper.getID()).getValue());
                }
                if (compWrappers.size() == countComps || component instanceof JRadioButton) {
                    gbc.insets.top = 8;
                    gbc.insets.bottom = 0;
                }
                if (compWrappers.size() == countComps) {
                    gbc.insets.right = 10;
                    gbc.weightx = 1.0;
                    if (cType.getAxis().equals((Object)SupportedAxisType.Y)) {
                        gbc.gridwidth = 0;
                    }
                } else {
                    gbc.gridwidth = countComps;
                    gbc.weightx = 0.0;
                }
                ++countComps;
                compPanel.add((Component)component, gbc);
                if (component instanceof JRadioButton) {
                    ++gbc.gridy;
                    continue;
                }
                ++gbc.gridx;
            }
        }
        return compPanel;
    }

    private int getGridBagFill(JComponent component, UIType type) {
        int w;
        if (type instanceof DisplayType && (w = ((DisplayType)type).getWidth()) > 0) {
            return 0;
        }
        if (type instanceof EditableChoiceType && (w = ((EditableChoiceType)type).getWidth()) > 0) {
            return 0;
        }
        if (type instanceof FileType) {
            w = ((FileType)type).getWidth();
            if (w > 0) {
                return 0;
            }
            return 2;
        }
        if (type instanceof TextInputType && (w = ((TextInputType)type).getWidth()) > 0) {
            return 0;
        }
        return 2;
    }

    private void registerListener(ComponentWrapper compWrapper) {
        WorkflowComponent wfWrapper;
        JComponent component = compWrapper.getComponent();
        boolean hasWorkFlow = false;
        boolean registerCallback = false;
        if (compWrapper instanceof WorkflowComponent && (wfWrapper = (WorkflowComponent)((Object)compWrapper)).hasWorkFlowProperty()) {
            if (this._workFlowComponents == null) {
                this._workFlowComponents = new HashMap<JComponent, ComponentWrapper>();
            }
            this._workFlowComponents.put(component, compWrapper);
            hasWorkFlow = true;
        }
        if (this._callbackHandler != null && compWrapper instanceof NotifyComponent) {
            registerCallback = ((NotifyComponent)((Object)compWrapper)).notifyComponents();
        }
        if (component instanceof JRadioButton) {
            ((JRadioButton)component).addItemListener(new ComponentItemListener(compWrapper.getID(), hasWorkFlow, registerCallback));
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(new ComponentActionListener(compWrapper.getID(), hasWorkFlow, registerCallback));
        } else if (component instanceof JCheckBox) {
            ((JCheckBox)component).addItemListener(new ComponentItemListener(compWrapper.getID(), hasWorkFlow, registerCallback));
        }
    }

    @Override
    public boolean okNext() {
        boolean canProceed = true;
        Map<String, Object> componentIdValueMap = this.getComponentIDValueMap(true, false);
        List<ComponentMessage> compMessages = this._helper.validate(componentIdValueMap);
        boolean hasValidationMessage = compMessages != null && !compMessages.isEmpty();
        ArrayList<PublishedMessage> warningMessages = null;
        if (hasValidationMessage) {
            warningMessages = new ArrayList<PublishedMessage>(compMessages.size());
            for (ComponentMessage compMessage : compMessages) {
                String message = this.getLocalizedMessage(compMessage);
                String compId = compMessage.getComponentId();
                if (compId == null || !this._customCompWrappers.containsKey(compId)) {
                    if (compMessage.isErrorMessage()) {
                        ((GUITaskContext)this._context).addPanelValidationMessage(((GUITaskContext)this._context).getPublishedMessage(this._namespace, "64043", message));
                    } else {
                        PublishedMessage pv = ((GUITaskContext)this._context).getPublishedMessage(this._namespace, "42002", message);
                        ((GUITaskContext)this._context).addPanelValidationMessage(pv);
                        warningMessages.add(pv);
                    }
                    this._logger.log(Level.INFO, "Problem occurred in custom panel validation '" + message + "'");
                } else {
                    ComponentWrapper wrapper = this._customCompWrappers.get(compId);
                    if (compMessage.isErrorMessage()) {
                        ((GUITaskContext)this._context).addValidationMessage(((GUITaskContext)this._context).getPublishedMessage(this._namespace, "64042", wrapper.getName(), message), wrapper.getComponent());
                    } else {
                        PublishedMessage pv = ((GUITaskContext)this._context).getPublishedMessage(this._namespace, "42001", wrapper.getName(), message);
                        ((GUITaskContext)this._context).addValidationMessage(pv, wrapper.getComponent());
                        warningMessages.add(pv);
                    }
                    this._logger.log(Level.INFO, "Problem occurred in custom panel validation, Component-Id:'" + compId, "', Validation Message:" + message);
                }
                if (compMessage.isErrorMessage()) {
                    canProceed = false;
                }
                this._logger.log(Level.INFO, message, compMessage.getCause());
            }
        }
        if (hasValidationMessage && canProceed && warningMessages != null && !warningMessages.isEmpty() && 0 != ((GUITaskContext)this._context).showConfirmDialog(warningMessages, 2, 2, MessageFormat.format(((GUITaskContext)this._context).getI18nString(this._namespace, "Generic.confirm.dialog.OK.CANCEL.additional.text"), ((GUITaskContext)this._context).getTitlePanel().getTitle()))) {
            return false;
        }
        if (canProceed) {
            ((GUITaskContext)this._context).storeObject(this._namespace, CUSTOM_COMPONENTS, this._customCompWrappers);
            if (OperationInputImpl.isInitialized()) {
                OperationInputImpl operationInput = (OperationInputImpl)OperationInputImpl.getInstance();
                for (Map.Entry<String, Object> entry : componentIdValueMap.entrySet()) {
                    operationInput.addVariable(entry.getKey(), entry.getValue());
                }
            }
        }
        return canProceed;
    }

    @Override
    public boolean okPrev() {
        return true;
    }

    protected Map<String, Object> getComponentIdWithValues() {
        if (this._customCompWrappers == null || this._customCompWrappers.isEmpty()) {
            return null;
        }
        HashMap<String, Object> componentIdValueMap = new HashMap<String, Object>(this._customCompWrappers.size(), 1.0f);
        for (Map.Entry<String, ComponentWrapper> entry : this._customCompWrappers.entrySet()) {
            ComponentWrapper compWrapper = entry.getValue();
            componentIdValueMap.put(entry.getKey(), compWrapper.getValue());
        }
        return componentIdValueMap;
    }

    protected GUICustomPanelHelper getHelper() {
        return this._helper;
    }

    protected String getComponentValue(String componentID) {
        return this._helper.hasDefaultValue(componentID) ? this._helper.getDefaultValue(componentID) : null;
    }

    private String getLocalizedMessage(ComponentMessage compMessage) {
        Object[] params = compMessage.getParams();
        String message = ((GUITaskContext)this._context).getI18nString(this._namespace, compMessage.getMessageKey());
        message = message == null || message.isEmpty() ? compMessage.getMessageKey() : message;
        return params != null ? MessageFormat.format(message, params) : message;
    }

    private Map<String, Object> getComponentIDValueMap(boolean unmodifiable, boolean includeDisableComponents) {
        HashMap<String, Object> componentIdValueMap = new HashMap<String, Object>();
        for (Map.Entry<String, ComponentWrapper> entry : this._customCompWrappers.entrySet()) {
            ComponentWrapper componentWrapper = entry.getValue();
            JComponent component = componentWrapper.getComponent();
            if (entry.getKey().endsWith("_label") && component instanceof JLabel) continue;
            if (component.isEnabled()) {
                componentIdValueMap.put(entry.getKey(), componentWrapper.getValue());
                continue;
            }
            if (!includeDisableComponents) continue;
            componentIdValueMap.put(entry.getKey(), null);
        }
        return unmodifiable ? Collections.unmodifiableMap(componentIdValueMap) : componentIdValueMap;
    }

    private void updateWorkFlowProperty(Object source) {
        if (this._workFlowComponents.containsKey(source)) {
            ComponentWrapper wfWrapper = this._workFlowComponents.get(source);
            ((GUITaskContext)this._context).setWorkflowProperty(((WorkflowComponent)((Object)wfWrapper)).getWorkFlowProperty(), String.valueOf(wfWrapper.getValue()));
        }
    }

    private int getMaxWidth(List<Object> cTypes) {
        int max = 1;
        int localMax = 0;
        for (Object ocType : cTypes) {
            if (!(ocType instanceof TableType)) continue;
            TableType tType = (TableType)ocType;
            List<RowType> rows = tType.getRow();
            for (RowType row : rows) {
                localMax = row.getComponents().size();
                if (localMax > max) {
                    max = localMax;
                }
                if ((localMax = row.getColSize()) <= max) continue;
                max = localMax;
            }
        }
        return max;
    }

    protected CustomPanelComponentCallback getCallback() {
        if (this._callback == null) {
            this._callback = new CustomPanelCallbackImpl();
        }
        return this._callback;
    }

    private class ComponentDocumentListener
    implements DocumentListener {
        private Component _source = null;

        public ComponentDocumentListener(Component comp) {
            this._source = comp;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((GUITaskContext)CustomPanelGUITask.this._context).clearValidationMessages((JComponent)this._source);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((GUITaskContext)CustomPanelGUITask.this._context).clearValidationMessages((JComponent)this._source);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((GUITaskContext)CustomPanelGUITask.this._context).clearValidationMessages((JComponent)this._source);
        }
    }

    private class ComponentItemListener
    extends ComponentListener
    implements ItemListener {
        ComponentItemListener(String componentID, boolean updateWorkFlow, boolean callbackRegistered) {
            super(componentID, updateWorkFlow, callbackRegistered);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ComponentWrapper wrapper = (ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(this._componentID);
            ((GUITaskContext)CustomPanelGUITask.this._context).clearValidationMessages(wrapper.getComponent());
            if (this._updateWorkFlow) {
                CustomPanelGUITask.this.updateWorkFlowProperty(e.getSource());
            }
            if (this._callbackRegistered && this._isActive) {
                Map componentIDValueMap = CustomPanelGUITask.this.getComponentIDValueMap(false, true);
                componentIDValueMap.put(this._componentID, wrapper.getValue());
                CustomPanelGUITask.this._callbackHandler.handle(CustomPanelGUITask.this.getCallback(), this._componentID);
            }
        }
    }

    private class ComponentActionListener
    extends ComponentListener
    implements ActionListener {
        ComponentActionListener(String componentID, boolean updateWorkFlow, boolean callbackRegistered) {
            super(componentID, updateWorkFlow, callbackRegistered);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((GUITaskContext)CustomPanelGUITask.this._context).clearValidationMessages((JComponent)e.getSource());
            if (this._updateWorkFlow) {
                CustomPanelGUITask.this.updateWorkFlowProperty(e.getSource());
            }
            if (this._callbackRegistered && this._isActive) {
                CustomPanelGUITask.this._callbackHandler.handle(CustomPanelGUITask.this.getCallback(), this._componentID);
            }
        }
    }

    private class CustomPanelCallbackImpl
    implements CustomPanelComponentCallback {
        private CustomPanelCallbackImpl() {
        }

        @Override
        public boolean isEnabled(String componentID) {
            this.validateComponentID(componentID);
            return ((ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(componentID)).getComponent().isEnabled();
        }

        @Override
        public void setEnable(String componentID, boolean enabled) {
            if (CustomPanelGUITask.this._customCompWrappers.containsKey(componentID)) {
                ((ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(componentID)).getComponent().setEnabled(enabled);
                if (CustomPanelGUITask.this._customCompWrappers.containsKey(componentID + "_label")) {
                    ((ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(componentID + "_label")).getComponent().setEnabled(enabled);
                }
            }
        }

        @Override
        public void setComponentValue(String componentID, Object value) {
            ComponentWrapper compWrapper = (ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(componentID);
            if (compWrapper != null) {
                compWrapper.setValue(value);
            }
        }

        @Override
        public Object getComponetValue(String componentID) {
            ComponentWrapper compWrapper = (ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(componentID);
            if (compWrapper != null) {
                return compWrapper.getValue();
            }
            return null;
        }

        @Override
        public void changeComponentFont(String componentID, final CustomPanelComponentCallback.SupportedFontStyle fontStyle) {
            ComponentWrapper compWrapper = (ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(componentID.concat("_label"));
            if (compWrapper == null && (compWrapper = (ComponentWrapper)CustomPanelGUITask.this._customCompWrappers.get(componentID)) == null) {
                CustomPanelGUITask.this._logger.log(Level.WARNING, "Can not change the component font, Invalid component-ID:" + componentID);
                return;
            }
            CustomPanelGUITask.this._logger.log(Level.FINEST, "Changing the font style of component-ID:" + componentID);
            final JComponent component = compWrapper.getComponent();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (component instanceof JLabel) {
                        ((JLabel)component).setFont(CustomPanelCallbackImpl.this.getFontMapping(fontStyle));
                    } else if (component instanceof JToggleButton) {
                        ((JToggleButton)component).setFont(CustomPanelCallbackImpl.this.getFontMapping(fontStyle));
                    } else {
                        CustomPanelGUITask.this._logger.log(Level.INFO, "Font style changes are not supported for component:" + component);
                    }
                }
            });
        }

        private Font getFontMapping(CustomPanelComponentCallback.SupportedFontStyle fontStyle) {
            Font font = new JLabel().getFont();
            switch (fontStyle) {
                case BOLD: {
                    return font.deriveFont(1);
                }
                case ITALIC: {
                    return font.deriveFont(2);
                }
                case BOLD_AND_ITALIC: {
                    return font.deriveFont(3);
                }
                case PLAIN: {
                    return font;
                }
            }
            CustomPanelGUITask.this._logger.log(Level.INFO, "Unsupported font style:" + (Object)((Object)fontStyle));
            return font;
        }

        private void validateComponentID(String componentID) {
            if (!CustomPanelGUITask.this._customCompWrappers.containsKey(componentID)) {
                throw new IllegalArgumentException("Invalid componentID:" + componentID);
            }
        }

        @Override
        public void clearAllValidationMessages() {
            ((GUITaskContext)CustomPanelGUITask.this._context).clearAllValidationMessages();
        }

        @Override
        public void setWorkFlowProperty(String name, String value) {
            if (StringUtil.isNullOrEmpty((String)name)) {
                throw new IllegalArgumentException("Can not set null or empty string as work-flow property.");
            }
            String oldValue = this.getWorkFlowProperty(name);
            if (!StringUtil.isNullOrEmpty((String)oldValue)) {
                CustomPanelGUITask.this._logger.log(Level.INFO, "Changing the work-flow property ('" + name + "') value (old-value='" + oldValue + "', new-value='" + value + "')");
            }
            ((GUITaskContext)CustomPanelGUITask.this._context).setWorkflowProperty(name, value);
        }

        @Override
        public String getWorkFlowProperty(String name) {
            return ((GUITaskContext)CustomPanelGUITask.this._context).getWorkflowProperty(name);
        }
    }

    private abstract class ComponentListener
    implements EventListener {
        boolean _updateWorkFlow = false;
        boolean _callbackRegistered = false;
        String _componentID;
        boolean _isActive;

        ComponentListener(String componentID, boolean updateWorkFlow, boolean callbackRegistered) {
            this._updateWorkFlow = updateWorkFlow;
            this._componentID = componentID;
            this._callbackRegistered = callbackRegistered;
            this._isActive = true;
        }
    }
}

