/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.roadmap.impl;

import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.wizard.gui.roadmap.impl.IndividualIcon;
import com.oracle.cie.wizard.gui.roadmap.impl.RoadmapListModelImpl;
import com.oracle.cie.wizard.gui.roadmap.impl.RoadmapStepImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CustomRoadmapNodeListRenderer
extends DefaultListCellRenderer {
    private static int _ICONS_TYPE_LIST_LENGTH = 6;
    private static int _ICONS_STATE_LIST_LENGTH = 7;
    private static final Icon[][] _ICONS = new Icon[_ICONS_TYPE_LIST_LENGTH][_ICONS_STATE_LIST_LENGTH];
    private static final String[] _STRIP_IMAGES = new String[]{"resources/wizard/images/simple-first.png", "resources/wizard/images/simple-middle.png", "resources/wizard/images/simple-last.png", "resources/wizard/images/branch-first.png", "resources/wizard/images/branch-middle.png", "resources/wizard/images/branch-last.png"};
    private static final Color _VISITED_STEP_COLOR = new Color(114, 0, 124);
    private static final Color _UNVISITED_STEP_COLOR = new Color(0, 51, 153);
    private static final Color _ERROR_STEP_COLOR = new Color(255, 0, 51);
    private static final Color _INVALIDATED_STEP_COLOR = Color.GRAY;
    private static final Color _FOCUSSTEP_BORDER_COLOR = new Color(157, 171, 194);
    private static int LEFT_OFFSET = 4;
    private static final Map<TextAttribute, Integer> UNDERLINE_FONT_ATTRBS = Collections.unmodifiableMap(new HashMap<TextAttribute, Integer>(){
        {
            this.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
    });
    protected static final Font FONT_PLAIN = UIManager.getFont("Label.font") != null ? UIManager.getFont("Label.font") : new JLabel().getFont();
    protected static final Font FONT_BOLD = FONT_PLAIN.deriveFont(1);
    protected static final Font FONT_PLAIN_UNDERLINED = FONT_PLAIN.deriveFont(UNDERLINE_FONT_ATTRBS);
    protected static final Font FONT_BOLD_UNDERLINED = FONT_BOLD.deriveFont(UNDERLINE_FONT_ATTRBS);
    private boolean _isSelected = false;
    private boolean _cellHasFocus = false;
    private boolean _isActive = false;

    public CustomRoadmapNodeListRenderer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, LEFT_OFFSET, 0, 0));
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int type;
        this._isSelected = isSelected;
        this._cellHasFocus = cellHasFocus;
        RoadmapListModelImpl listModelImpl = (RoadmapListModelImpl)list.getModel();
        int currentIndex = listModelImpl.getCurrentSelectedIndex();
        boolean isCurrent = false;
        if (index == currentIndex) {
            isCurrent = true;
        }
        boolean isStatusError = listModelImpl.isErrorState();
        RoadmapStepImpl node = (RoadmapStepImpl)value;
        boolean isVisited = node.isVisited();
        boolean isActive = node.isActive();
        boolean isValid = isVisited && !isCurrent || isActive;
        int startNavEnabledRange = listModelImpl.getStartNavEnabledRange();
        int endNavEnabledRange = listModelImpl.getEndNavEnabledRange();
        if (isActive && (index < startNavEnabledRange || index > endNavEnabledRange)) {
            isActive = false;
        }
        if (isStatusError && index > currentIndex) {
            isActive = false;
        }
        this._isActive = isActive;
        int n = type = node.getTaskEntry().isBranching() ? 3 : 0;
        type += index == 0 ? 0 : (index != list.getModel().getSize() - 1 ? 1 : 2);
        int state = 0;
        if (isActive) {
            if (!isValid || isStatusError && isCurrent) {
                state = 4;
            } else {
                int n2 = !isVisited ? (!isStatusError ? 2 : 6) : (state = 0);
            }
            if (state != 6 && isCurrent) {
                ++state;
            }
        } else {
            state = 6;
        }
        Color color = _UNVISITED_STEP_COLOR;
        Font font = FONT_PLAIN;
        switch (state) {
            case 0: {
                color = _VISITED_STEP_COLOR;
                font = FONT_PLAIN_UNDERLINED;
                break;
            }
            case 1: {
                color = _VISITED_STEP_COLOR;
                font = FONT_BOLD;
                break;
            }
            case 2: {
                color = _UNVISITED_STEP_COLOR;
                font = FONT_PLAIN_UNDERLINED;
                break;
            }
            case 3: {
                color = _UNVISITED_STEP_COLOR;
                font = FONT_BOLD;
                break;
            }
            case 4: {
                color = _ERROR_STEP_COLOR;
                font = FONT_PLAIN_UNDERLINED;
                break;
            }
            case 5: {
                color = _ERROR_STEP_COLOR;
                font = FONT_BOLD;
                break;
            }
            case 6: {
                color = _INVALIDATED_STEP_COLOR;
                font = FONT_PLAIN;
            }
        }
        this.setText(node.getTaskTitle());
        this.setForeground(color);
        this.setFont(font);
        this.setIcon(this._getIcon(type, state));
        if (isCurrent) {
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
        return this;
    }

    public Icon _getIcon(int type, int state) {
        if (_ICONS[type][state] == null) {
            ImageIcon icon = GUIUtilities.loadIcon((String)_STRIP_IMAGES[type], (ClassLoader)CustomRoadmapNodeListRenderer.class.getClassLoader());
            CustomRoadmapNodeListRenderer._ICONS[type][state] = this.getIndividiualIcon(icon.getImage(), _ICONS_STATE_LIST_LENGTH, state);
        }
        return _ICONS[type][state];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getIndividiualIcon(Image image, int length, int state) {
        if (image == null) {
            throw new IllegalArgumentException("Image not loaded");
        }
        Icon[] icons = new Icon[length];
        int xAxisStart = state % length;
        int yAxisStart = state / length;
        int imageWidth = image.getWidth(null) / length;
        int imageHeight = image.getHeight(null);
        if (xAxisStart < 0 || xAxisStart >= length || yAxisStart < 0 || yAxisStart >= 1) {
            throw new IllegalArgumentException();
        }
        int offset = xAxisStart + yAxisStart * length;
        CustomRoadmapNodeListRenderer customRoadmapNodeListRenderer = this;
        synchronized (customRoadmapNodeListRenderer) {
            Icon icon = icons[offset];
            if (icon == null) {
                icons[offset] = icon = new IndividualIcon(imageWidth, imageHeight, xAxisStart, yAxisStart, image);
            }
            return icon;
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        Border border = null;
        if (this._isActive && this._cellHasFocus) {
            if (this._isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = this.getNoFocusBorder();
        }
        if (border != null) {
            border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getBorder("List.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return new EmptyBorder(0, 0, 0, 0);
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == new EmptyBorder(0, 0, 0, 0))) {
            return border;
        }
        return noFocusBorder;
    }
}

