/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.summary;

import com.oracle.cie.common.SecureUnmarshaller;
import com.oracle.cie.wizard.ext.summary.xml.NodeType;
import com.oracle.cie.wizard.ext.summary.xml.OutcomeSummaryType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SummaryPanelParser {
    private static final Logger LOGGER = Logger.getLogger(SummaryPanelParser.class.getName());
    private static final String SUMMARY_PANEL_SCHEMA = "wcf/schema-imports/summary_panel.xsd";
    private static final String OUTCOME_SUMMARY_PANEL_SCHEMA = "wcf/schema/outcome_summary_panel.xsd";

    public NodeType parseSummaryConfig(InputStream is) throws SAXException, JAXBException {
        Object obj = this.parse(is, SUMMARY_PANEL_SCHEMA);
        return obj instanceof JAXBElement ? (NodeType)((JAXBElement)obj).getValue() : (NodeType)obj;
    }

    public OutcomeSummaryType parseOutcomeConfig(InputStream is) throws SAXException, JAXBException {
        Object obj = this.parse(is, OUTCOME_SUMMARY_PANEL_SCHEMA);
        return obj instanceof JAXBElement ? (OutcomeSummaryType)((JAXBElement)obj).getValue() : (OutcomeSummaryType)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parse(InputStream is, String schemaLoc) throws SAXException, JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("Invalid Stream");
        }
        try {
            URL schemaUrl = SummaryPanelParser.class.getClassLoader().getResource(schemaLoc);
            JAXBContext context = JAXBContext.newInstance((String)NodeType.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaUrl);
            unmarshaller.setSchema(schema);
            InputSource inputSource = new InputSource(is);
            Object object = SecureUnmarshaller.unmarshal((Unmarshaller)unmarshaller, (InputSource)inputSource);
            return object;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, "Issue in closing the summary panel configuration stream", e);
            }
        }
    }
}

