/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver;

import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import oracle.dbsysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public abstract class DummyProductDriver
extends ProductDriver {
    File dummyConfigFile;

    public void setDummyConfigFile(File dummyConfigFile) {
        this.dummyConfigFile = dummyConfigFile;
    }

    @Override
    public SystemInstance buildSystemInstance() {
        try {
            SystemInstance sinst = new SystemInstance();
            sinst = sinst.readFile(this.dummyConfigFile);
            this.setTop(sinst);
            return sinst;
        }
        catch (FileNotFoundException e) {
            throw new ProductDriverException(e.getMessage(), e);
        }
    }

    public abstract void setTop(SystemInstance var1);

    @Override
    public LocalInfo getLocalInfo() {
        if (this.localInfo != null) {
            return this.localInfo;
        }
        this.localInfo = new LocalInfo();
        this.localInfo.setOracleHomes(new ArrayList<OracleHome>());
        for (Object b : this.ti.getEntities()) {
            if (!(b instanceof OracleHome)) continue;
            OracleHome oh = (OracleHome)b;
            this.localInfo.getOracleHomes().add(oh);
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (BaseClass b : this.ti.getEntities()) {
            if (!(b instanceof Host)) continue;
            Host h = (Host)b;
            hosts.add(h);
        }
        Collections.sort(hosts, new HostComparator());
        Host first = (Host)hosts.get(0);
        this.localInfo.setLocalHostName(first.getHostName());
        this.localInfo.setLocalHost(first);
        return this.localInfo;
    }

    public void setSystemInstance(SystemInstance systemInstance) {
        this.ti = systemInstance;
    }

    public static class HostComparator
    implements Comparator<Host> {
        @Override
        public int compare(Host h1, Host h2) {
            String localName = OsysUtility.getHostname();
            if (localName.indexOf(".") != -1) {
                localName = localName.substring(0, localName.indexOf("."));
            }
            if (h1.getHostName().equals(localName)) {
                return -1;
            }
            if (h2.getHostName().equals(localName)) {
                return 1;
            }
            return h1.getHostName().compareTo(h2.getHostName());
        }
    }
}

