/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import java.util.logging.Level;

public class Jdk14LogLevelMapper {
    public static Level mapToJdkLevel(String level) {
        return Jdk14LogLevelMapper.mapToJdkLevel(level, Level.INFO);
    }

    public static Level mapToJdkLevel(String level, String defaultLevel) {
        return Jdk14LogLevelMapper.mapToJdkLevel(level, Jdk14LogLevelMapper.mapToJdkLevel(defaultLevel, Level.INFO));
    }

    public static Level mapToJdkLevel(String level, Level defaultLevel) {
        Level jdkLevel = defaultLevel;
        if (level != null) {
            level = level.toUpperCase();
        }
        if ("OFF".equalsIgnoreCase(level)) {
            jdkLevel = Level.OFF;
        } else if ("FATAL".equalsIgnoreCase(level) || "ERROR".equalsIgnoreCase(level)) {
            jdkLevel = Level.SEVERE;
        } else if ("WARN".equalsIgnoreCase(level)) {
            jdkLevel = Level.WARNING;
        } else if ("INFO".equalsIgnoreCase(level)) {
            jdkLevel = Level.INFO;
        } else if ("DEBUG".equalsIgnoreCase(level)) {
            jdkLevel = Level.FINE;
        } else if ("TRACE".equalsIgnoreCase(level)) {
            jdkLevel = Level.FINEST;
        } else if ("ALL".equalsIgnoreCase(level)) {
            jdkLevel = Level.ALL;
        } else {
            try {
                jdkLevel = Level.parse(level);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return jdkLevel;
    }
}

