/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.utils;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBBaseProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SDBProductSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class PrintHelp {
    private static StringBuilder sb = new StringBuilder();

    public static void main(String[] args) {
        try {
            PrintHelp printhelp = new PrintHelp();
            Set<OPatchAutoOption> options = PrintHelp.getAllOptions();
            ArrayList<String> argsList = new ArrayList<String>();
            if (args != null) {
                argsList.addAll(Arrays.asList(args));
            }
            String operationArg = "";
            if (argsList.contains("apply")) {
                operationArg = (String)argsList.get(argsList.indexOf("apply"));
                argsList.remove(argsList.indexOf("apply"));
            } else if (argsList.contains("rollback")) {
                operationArg = (String)argsList.get(argsList.indexOf("rollback"));
                argsList.remove(argsList.indexOf("rollback"));
            } else {
                Reporting.report((String)"Try this option : \n\t'opatchauto apply|rollback -sdb -help'");
                System.exit(0);
            }
            OPatchAutoCommand command = OPatchAutoCommand.valueOf((String)operationArg.toLowerCase());
            if (argsList.contains("-sdb")) {
                printhelp.sdbusage(options, command, argsList);
            }
        }
        catch (OPatchAutoException e) {
            Reporting.report((String)("Error while displaying help : " + e.getMessage()));
        }
    }

    public static Set<OPatchAutoOption> getAllOptions() {
        LinkedHashSet<OPatchAutoOption> options = new LinkedHashSet<OPatchAutoOption>();
        OPatchAutoOptions opatchAutoOptions = OPatchAutoOptions.getInstance();
        SDBProductSupport sdbProductSupport = new SDBProductSupport();
        DBBaseProductSupport dbBaseProductSupport = new DBBaseProductSupport();
        options.addAll(opatchAutoOptions.getAllOptions());
        options.addAll(sdbProductSupport.getOptions());
        options.addAll(dbBaseProductSupport.getOptions());
        return options;
    }

    private void sdbusage(Set<OPatchAutoOption> options, OPatchAutoCommand command, List<String> argsList) throws OPatchAutoException {
        List<String> allSDBSupportedOptions = PrintHelp.getAllSDBOptions(command.name());
        List<String> mandatorySDBOptions = PrintHelp.getSDBMandatoryOptions();
        List<String> otherSDBSupportedOptions = PrintHelp.getOtherSDBOptions(command.name());
        PrintHelp.sdbusage(options, command, allSDBSupportedOptions, mandatorySDBOptions, otherSDBSupportedOptions, argsList);
    }

    public static List<String> getAllSDBOptions(String operation) {
        ArrayList<String> options = new ArrayList<String>();
        options.addAll(PrintHelp.getSDBMandatoryOptions());
        options.addAll(PrintHelp.getOtherSDBOptions(operation));
        return options;
    }

    private static List<String> getSDBMandatoryOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("patch.location");
        options.add(DBProductParameterConstants.SDB.getValue());
        options.add("wallet");
        return options;
    }

    private static List<String> getOtherSDBOptions(String operation) {
        ArrayList<String> options = new ArrayList<String>();
        options.add(DBProductParameterConstants.PORT.getValue());
        options.add("host");
        options.add(DBProductParameterConstants.SID.getValue());
        options.add(DBProductParameterConstants.SERVICE.getValue());
        options.add(DBProductParameterConstants.ROLLING_MODE_KEY.getValue());
        options.add("analyze");
        options.add("patch.base.directory");
        options.add(OPatchAutoOptions.LOG_LEVEL_KEY);
        options.add(DBProductParameterConstants.SHARD_GROUP.getValue());
        options.add(DBProductParameterConstants.SHARD_SPACE.getValue());
        options.add(DBProductParameterConstants.DG.getValue());
        options.add(DBProductParameterConstants.IN_PLACE_KEY.getValue());
        if (!StringUtil.isNullOrEmpty((String)operation) && operation.equalsIgnoreCase("rollback")) {
            options.add("id");
        }
        return options;
    }

    private static void sdbusage(Set<OPatchAutoOption> options, OPatchAutoCommand command, List<String> allSDBSupportedOptions, List<String> mandatoryOptions, List<String> otherSupportedOptions, List<String> argsList) throws OPatchAutoException {
        PrintHelp.unsupportedErrorMsg(options, command, allSDBSupportedOptions, argsList);
        sb.append(PrintHelp.getUsageHeader());
        String indent = PrintHelp.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.command.description.indent", (Object[])new Object[0])));
        sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.command.description.header", (Object[])new Object[0]));
        sb.append("\n");
        String description = "";
        if (command.isApply()) {
            description = OPatchAutoHelper.getLocalizedString((String)"opatchauto.apply.sdb.description", (Object[])new Object[0]);
        } else if (command.isRollback()) {
            description = OPatchAutoHelper.getLocalizedString((String)"opatchauto.rollback.sdb.description", (Object[])new Object[0]);
        } else if (command.isResumed()) {
            description = command.getDescription();
        }
        String formattedDescription = description.replace("\n", "\n" + indent);
        sb.append(indent).append(formattedDescription);
        sb.append("\n\n");
        sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.syntax.description.header", (Object[])new Object[0]));
        sb.append("\n");
        String appName = indent + OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.app.name", (Object[])new Object[0]);
        String args = "";
        appName = appName + " " + command.name();
        int indentSize = appName.length() + 1;
        int mandatoryListSize = mandatoryOptions.size();
        int count = 0;
        for (String mandatoryOption : mandatoryOptions) {
            for (OPatchAutoOption option : options) {
                String argsStr = "";
                if (!mandatoryOption.equalsIgnoreCase(option.getKey())) continue;
                argsStr = option.isParameter() ? "<" + option.getArg() + ">" : (option.isSwitch() ? option.getArg() : option.getArg() + " <" + option.getKey() + ">");
                args = args + " " + argsStr;
                if (++count >= mandatoryListSize) continue;
                args = args + "\n" + PrintHelp.getIndent(indentSize);
            }
        }
        for (OPatchAutoOption option : options) {
            Object argsStr = "";
            if (!otherSupportedOptions.contains(option.getKey())) continue;
            argsStr = option.isSwitch() ? "[ " + option.getArg() + " ]" : (option.getArg().equalsIgnoreCase("-host") ? "[ " + option.getArg() + " <tns-host> ]" : (option.getArg().equalsIgnoreCase("-dg") ? "[ " + option.getArg() + " <primary.database.name> ]" : "[ " + option.getArg() + " <" + option.getKey() + "> ]"));
            args = args + "\n" + PrintHelp.getIndent(indentSize);
            args = args + " " + (String)argsStr;
        }
        sb.append(appName).append(args);
        sb.append("\n\n");
        PrintHelp.getParamOptions(options, allSDBSupportedOptions);
        sb.append("\n");
        sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.options.description.header", (Object[])new Object[0]));
        String optionIndent = PrintHelp.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.option.indent", (Object[])new Object[0])));
        String optionDescIndent = PrintHelp.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.option.description.indent", (Object[])new Object[0])));
        for (OPatchAutoOption option : options) {
            if (!allSDBSupportedOptions.contains(option.getKey())) continue;
            if (option.getArg().equalsIgnoreCase("-host")) {
                sb.append("\n");
                sb.append(optionIndent).append(option.getArg()).append(" <tns-host>");
                sb.append("\n");
                sb.append(optionDescIndent).append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.sdb.host.description", (Object[])new Object[0]));
                sb.append("\n");
                continue;
            }
            if (option.getArg().equalsIgnoreCase("-wallet")) {
                sb.append("\n");
                sb.append(optionIndent).append(option.getCommandLineDescription());
                sb.append("\n");
                sb.append(optionDescIndent).append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.sdb.wallet.description", (Object[])new Object[0]));
                sb.append("\n");
                continue;
            }
            if (option.getArg().equalsIgnoreCase("-logLevel")) {
                sb.append("\n");
                sb.append(optionIndent).append(option.getCommandLineDescription());
                sb.append("\n");
                sb.append(optionDescIndent).append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.option.logLevel.description", (Object[])new Object[0]));
                sb.append("\n");
                sb.append(optionDescIndent).append("Supported values : ");
                for (int i = 0; i < WizardConfiguration.LOGPRIORITY.getAllowedValues().length; ++i) {
                    sb.append(WizardConfiguration.LOGPRIORITY.getAllowedValues()[i]);
                    sb.append(" ");
                }
                sb.append("\n");
                continue;
            }
            if (option.getArg().equalsIgnoreCase("-dg")) {
                sb.append("\n");
                sb.append(optionIndent).append(option.getArg()).append(" <primary.database.name>");
                sb.append("\n");
                sb.append(optionDescIndent).append(option.getDescription().replace("\n", "\n" + optionDescIndent));
                sb.append("\n");
                continue;
            }
            if (option.isParameter()) continue;
            sb.append("\n");
            sb.append(optionIndent).append(option.getCommandLineDescription());
            sb.append("\n");
            sb.append(optionDescIndent).append(option.getDescription().replace("\n", "\n" + optionDescIndent));
            sb.append("\n");
        }
        String example = "";
        String dgExample = "";
        String shGrpExample = "";
        String shSpcExample = "";
        if (command.isApply()) {
            example = OPatchAutoHelper.getLocalizedString((String)"opatchauto.apply.sdb.examples", (Object[])new Object[0]);
            dgExample = OPatchAutoHelper.getLocalizedString((String)"opatchauto.apply.dg.examples", (Object[])new Object[0]);
            shGrpExample = OPatchAutoHelper.getLocalizedString((String)"opatchauto.apply.shardgroup.examples", (Object[])new Object[0]);
            shSpcExample = OPatchAutoHelper.getLocalizedString((String)"opatchauto.apply.shardspace.examples", (Object[])new Object[0]);
        } else if (command.isRollback()) {
            example = OPatchAutoHelper.getLocalizedString((String)"opatchauto.rollback.sdb.examples", (Object[])new Object[0]);
            dgExample = OPatchAutoHelper.getLocalizedString((String)"opatchauto.rollback.dg.examples", (Object[])new Object[0]);
            shGrpExample = OPatchAutoHelper.getLocalizedString((String)"opatchauto.rollback.shardgroup.examples", (Object[])new Object[0]);
            shSpcExample = OPatchAutoHelper.getLocalizedString((String)"opatchauto.rollback.shardspace.examples", (Object[])new Object[0]);
        }
        if (!StringUtil.isNullOrEmpty((String)example)) {
            sb.append("\n");
            String exampleHeaderString = OPatchAutoHelper.getLocalizedString((String)"opatchauto.command.example.header", (Object[])new Object[0]);
            sb.append(exampleHeaderString);
            sb.append("\n");
            String formattedExample = example.replace("\n", "\n" + indent);
            sb.append(indent).append(formattedExample);
            sb.append("\n");
            sb.append(indent).append(dgExample);
            sb.append("\n");
            sb.append(indent).append(shGrpExample);
            sb.append("\n");
            sb.append(indent).append(shSpcExample);
            sb.append("\n");
            sb.append(indent).append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.sdb.wallet.examples", (Object[])new Object[0]));
            sb.append("\n");
        }
        Reporting.report((String)sb.toString());
    }

    private static void unsupportedErrorMsg(Set<OPatchAutoOption> options, OPatchAutoCommand command, List<String> allSDBSupportedOptions, List<String> argsList) {
        ArrayList<String> unsupportedOptions = new ArrayList<String>();
        Iterator<String> itr = argsList.iterator();
        while (itr.hasNext()) {
            String arg = itr.next();
            if (arg.equalsIgnoreCase("apply") || arg.equalsIgnoreCase("rollback") || arg.equalsIgnoreCase("-sdb") || arg.equalsIgnoreCase("-help")) {
                itr.remove();
                continue;
            }
            unsupportedOptions.add(arg);
        }
        if (unsupportedOptions != null && unsupportedOptions.size() > 0) {
            String message = OPatchAutoHelper.getPublishedMessage((String)"68148", (Object[])new Object[]{unsupportedOptions});
            sb.append(message).append("\n\n");
        }
    }

    private static void getParamOptions(Set<OPatchAutoOption> options, List<String> allSDBSupportedOptions) {
        sb.append("\n");
        sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.parameters.description.header", (Object[])new Object[0]));
        sb.append("\n");
        for (OPatchAutoOption option : options) {
            if (!allSDBSupportedOptions.contains(option.getKey()) || !option.isParameter()) continue;
            String optionIndent = PrintHelp.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.parameter.indent", (Object[])new Object[0])));
            String optionDescIndent = PrintHelp.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.parameter.description.indent", (Object[])new Object[0])));
            sb.append(optionIndent).append(option.getArg());
            sb.append("\n");
            sb.append(optionDescIndent).append(option.getDescription().replace("\n", "\n" + optionDescIndent));
            sb.append("\n");
        }
    }

    private static String getIndent(int size) {
        return StringUtil.getPad((String)" ", (int)size);
    }

    private static String getUsageHeader() {
        return MessageFormat.format(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.header1", (Object[])new Object[0]), OPatchAutoHelper.getInstance().getOPatchAutoVersion()) + "\n" + OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.header2", (Object[])new Object[0]) + "\n\n";
    }

    static {
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchauto/messages");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchauto/opatchauto");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchauto/usage");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/usage");
        ResourceBundleManager.setPrefix((String)"opatchauto", (String)"OPATCHAUTO");
    }
}

