/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.utils;

import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporter;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Logger;

public class PrintCookie {
    private static final Logger _logger = Logger.getLogger(PrintCookie.class.getName());
    public static final String LOG_FILENAME_DATE_FORMAT = "yyyy-MM-dd_hh-mm-ssa";
    public static final String DEFAULT_LOG_DIR = "cfgtoollogs";
    public static final String OPATCH_AUTO_NAMESPACE = "opatchauto";
    public static final String APPLY_COOKIE_NAMESPACE = "OOPApplyState";
    public static final String SWITCHBACK_COOKIE_NAMESPACE = "OOPRollbackState";
    public static final String SESSION_STATE_NAMESPACE = "OOPSessionState";
    private static String oracleHome;
    private static String log;
    private static String host;

    public static void main(String[] args) throws OPatchAutoException {
        oracleHome = System.getProperty("OPatch.ORACLE_HOME");
        host = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        try {
            PrintCookie.setupReporting();
            PrintCookie.printCookie();
        }
        catch (Exception e) {
            Reporting.report((String)e.getMessage());
        }
    }

    private static void printCookie() throws OPatchAutoException {
        String applySessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        applySessionInfoFile = applySessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        File oopApplySessionInfoFile = new File(oracleHome + applySessionInfoFile);
        String rollbackSessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE_SWITCHBACK;
        rollbackSessionInfoFile = rollbackSessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        File oopRollbackSessionInfoFile = new File(oracleHome + rollbackSessionInfoFile);
        if (!oopApplySessionInfoFile.exists() && !oopRollbackSessionInfoFile.exists()) {
            Reporting.report((String)"No OOP session cookie file is found.\n");
            System.exit(0);
        }
        PrintCookie.initLogFactory(SESSION_STATE_NAMESPACE);
        _logger.info("OPatchAuto version: " + OPatchAutoHelper.getInstance().getOPatchAutoVersion());
        if (oopApplySessionInfoFile.exists()) {
            _logger.info("Start OOP Apply cookie print for host " + host + " and home " + oracleHome);
            Reporting.report((String)("The OOP apply session file path is  " + oopApplySessionInfoFile.getAbsolutePath()));
            Reporting.report((String)("The OOP apply session state log file path is  " + log + "\n"));
            PrintCookie.printOOPSessionCookie(oopApplySessionInfoFile);
            _logger.info("End OOP Apply cookie print for host " + host + " and home " + oracleHome);
        }
        if (oopRollbackSessionInfoFile.exists()) {
            _logger.info("Start OOP Switchback cookie print for host " + host + " and home " + oracleHome);
            Reporting.report((String)("The OOP switchback session file path is  " + oopRollbackSessionInfoFile.getAbsolutePath()));
            Reporting.report((String)("The OOP switchback session state log file path is  " + log + "\n"));
            PrintCookie.printOOPSessionCookie(oopRollbackSessionInfoFile);
            _logger.info("End OOP switchback cookie print for host " + host + " and home " + oracleHome);
        }
    }

    private static void setupReporting() throws OPatchAutoException {
        Reporter defaultReporter = Reporting.getDefaultReporter();
        Reporting.report((String)("\nCollect OOP session info for home " + oracleHome + " and host " + host + "\n"));
    }

    public static void initLogFactory(String fileName) {
        log = PrintCookie.getDefaultLogFileLocation(oracleHome, fileName);
        LogFactory logFactory = LogFactory.getFactory();
        logFactory.setupLogging(log, "INFO", true, new String[0]);
    }

    public static String getDefaultLogDir(String home) {
        return home.trim() + File.separator + DEFAULT_LOG_DIR + File.separator + OPATCH_AUTO_NAMESPACE;
    }

    public static String getDefaultLogFileLocation(String home, String fileName) {
        return PrintCookie.getDefaultLogDir(home) + File.separator + fileName + OPatchAutoHelper.getCurrentDateTimeStamp((String)LOG_FILENAME_DATE_FORMAT) + ".log";
    }

    public static void printOOPSessionCookie(File oopSessionCookieFile) throws OPatchAutoException {
        OOPSessionCookie cookie = null;
        FileInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new FileInputStream(oopSessionCookieFile);
            objectInputStream = new ObjectInputStream(inputStream);
            cookie = (OOPSessionCookie)objectInputStream.readObject();
            if (cookie == null) {
                _logger.info("cookie is null");
            }
            _logger.info(cookie.toString());
        }
        catch (IOException | ClassNotFoundException e) {
            _logger.info("cookie exception");
            throw new OPatchAutoException((Throwable)e);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException((Throwable)e);
            }
        }
    }

    static {
        log = "";
        host = "";
    }
}

