/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.opatchauto.core.binary.SessionPatches;

public class TwoStageAutoRollbackValidator
implements IValidator {
    Logger logger = Logger.getLogger(TwoStageAutoRollbackValidator.class.getName());
    private MultipleValidationResult multipleValidationResult = new MultipleValidationResult();

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Running two-stage rollback validation on auto rollback patches.");
        ArrayList<String> patchList = SessionData.getInstance().getAutoRollbackPatchIDs();
        if (patchList == null || patchList.size() < 1) {
            this.logger.info("There are no patches to be auto rolled back. Hence, the validator will be skipped.\n");
            return this.multipleValidationResult;
        }
        ClusterInformationLoader.CrsType crsType = ClusterInformationLoader.getInstance().getCRSType();
        this.logger.info("CRS Type is detected to be " + crsType);
        if (crsType.equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY)) {
            this.logger.info("Grid home is a software-only installation");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Two stage validations are not required for a software-only installation."));
            return this.multipleValidationResult;
        }
        PatchTarget patchTarget = (PatchTarget)params.get(ValidationParamKey.PATCH_TARGET.ordinal());
        ConfigGraph configGraph = (ConfigGraph)params.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        List<Host> hostModelList = configGraph.getTargets(Host.class);
        this.logger.info("Size of the host list is : " + hostModelList.size());
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        ArrayList<OracleHome> dbhomes = new ArrayList<OracleHome>();
        String crsHome = null;
        String crsOwner = null;
        boolean isSiha = false;
        for (OracleHome oh : oracleHomes) {
            if (oh.getHomeType().equals("crs")) {
                crsHome = oh.getPath();
                crsOwner = oh.getOwner();
                break;
            }
            if (oh.getHomeType().equals("siha")) {
                crsHome = oh.getPath();
                crsOwner = oh.getOwner();
                isSiha = true;
                break;
            }
            dbhomes.add(oh);
        }
        this.logger.fine("Is SIHA: " + isSiha);
        if (isSiha) {
            this.logger.info("This is a SIHA environment.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, "Two-stage Validation will be skipped on a SIHA environment."));
            return this.multipleValidationResult;
        }
        boolean isOOPEnabled = false;
        if (params.get(ValidationParamKey.OOP_ENABLED.ordinal()) != null) {
            isOOPEnabled = (Boolean)params.get(ValidationParamKey.OOP_ENABLED.ordinal());
        }
        String home = patchTarget.getHome().getLocation();
        this.logger.info("Validator is being run on home " + home);
        try {
            if (isOOPEnabled && !OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget)) {
                this.logger.info("This is not the first node of OOP Patching. Hence, the validator will be skipped.\n");
                return this.multipleValidationResult;
            }
            String idList = this.getIdList(home, patchList, isOOPEnabled);
            if (StringUtil.isNullOrEmpty((String)idList, (boolean)true)) {
                this.logger.info("There is no first node patch in this session for home " + home);
                return this.multipleValidationResult;
            }
            String invPtrLoc = home + File.separator + "oraInst.loc";
            String version_num = this.getRUVersionForRollback(home, patchList);
            boolean two_stage_rolling = this.isTwoStagePatchForRollback(home, patchList);
            String two_stage = "";
            two_stage = two_stage_rolling ? "TRUE" : "FALSE";
            int allowed_mode = this.runModeCheckCmd(home, idList, invPtrLoc, patchTarget.getHome().getOwner(), null, two_stage, version_num);
            if (allowed_mode != 0) {
                if (allowed_mode == 1) {
                    this.logger.warning("The selected patches require non-rolling mode of patching.");
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.TWO_STAGE_ROLLING_COMPULSATES_NONROLLING, null));
                } else if (allowed_mode == 2) {
                    this.logger.warning("Tool is unable to determine the required mode of patching. It is not safe to allow rolling mode of patching.");
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.UNABLE_TO_DETECT_ROLLBACK_MODE, null));
                } else {
                    this.logger.warning("Tool hit an error trying to determine the required mode of patching. It is not safe to allow rolling mode of patching.");
                    this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.HIT_AN_ERROR_DETECTING_ROLLBACK_MODE, null));
                }
            }
        }
        catch (Exception e) {
            this.logger.fine("Error hit : " + e.getMessage());
            this.logger.warning("Tool hit an exception trying to determine the required mode of patching. It is not safe to allow rolling mode of patching.");
            this.multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.HIT_AN_ERROR_DETECTING_ROLLBACK_MODE, null));
        }
        return this.multipleValidationResult;
    }

    public int runModeCheckCmd(String racHome, String idList, String invPtrLoc, String owner, Credential credential, String isTwoStageRolling, String vsnnum) {
        this.logger.info("Performing rollback method validations for home " + racHome);
        String commandToExecute = racHome + "/perl/bin/perl " + racHome + File.separator + "bin" + File.separator + "rrpatch.pl get_rollback_method -id " + idList + " -invPtrLoc " + invPtrLoc + " -oh " + racHome + " -two_stage_rolling " + isTwoStageRolling;
        if (!StringUtil.isNullOrEmpty((String)vsnnum, (boolean)true)) {
            commandToExecute = commandToExecute + " -db_version " + vsnnum;
        }
        try {
            GISystemCall.ExecReturn ret = GISystemCall.process(commandToExecute, owner, credential);
            if (ret == null) {
                this.logger.info("Unable to check rollback method.");
                return -1;
            }
            int exit_code = ret.getReturnCode();
            this.logger.info("get_rollback_method exit code is " + exit_code);
            switch (exit_code) {
                case 0: {
                    this.logger.info("get_rollback_method returned ROLLING mode");
                    break;
                }
                case 1: {
                    this.logger.info("get_rollback_method returned NONROLLING mode");
                    break;
                }
                case 2: {
                    this.logger.info("get_rollback_method returned UNKNOWN");
                    break;
                }
                default: {
                    this.logger.info("get_rollback_method hit an error : " + ret.getErrorMessage());
                }
            }
            this.logger.fine("get_rollback_method output : " + ret.getNormalMessage());
            return exit_code;
        }
        catch (Exception e) {
            this.logger.info("get_rollback_method hit an Exception " + e.getMessage());
            return -1;
        }
    }

    private String getIdList(String home, ArrayList<String> patchList, boolean isOOPEnabled) {
        StringBuffer idList = new StringBuffer();
        boolean firstPatch = true;
        try {
            if (patchList != null && !patchList.isEmpty()) {
                for (String individualPatch : patchList) {
                    boolean firstNode = true;
                    if (!isOOPEnabled) {
                        boolean bl = firstNode = DBPatchingHelper.identifyNodeOfPatching(home, individualPatch, SessionData.getInstance().getHostPatchDataMap(home), true) == DBPatchingHelper.NodeOfPatching.FIRST;
                    }
                    if (!firstNode) continue;
                    if (firstPatch) {
                        idList.append(individualPatch);
                        firstPatch = false;
                        continue;
                    }
                    idList.append(",").append(individualPatch);
                }
                return idList.toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isTwoStagePatchForRollback(String home, ArrayList<String> patchList) {
        for (String patchID : patchList) {
            if (!SessionPatches.isTwoStageRPForRollback((String)home, (String)patchID)) continue;
            return true;
        }
        return false;
    }

    private String getRUVersionForRollback(String home, ArrayList<String> patchList) {
        String ru = "";
        for (String patchID : patchList) {
            String version = SessionPatches.getRUVersionForRollback((String)home, (String)patchID);
            if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) continue;
            this.logger.info("RU Version is " + version);
            ru = version;
            break;
        }
        if (StringUtil.isNullOrEmpty((String)ru, (boolean)true) || ru.equalsIgnoreCase("null")) {
            return null;
        }
        return ru;
    }
}

