/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.sdk.cookies.SkipTargetCookie;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RACVersionGreaterValidator
implements IValidator {
    Logger logger = Logger.getLogger(RACVersionGreaterValidator.class.getName());
    private String strMinRACversion = null;

    public RACVersionGreaterValidator(String strMinRACversion) {
        this.strMinRACversion = strMinRACversion;
    }

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.INFO, "Invoking rule to ensure that RAC version is greater than " + this.strMinRACversion);
        CRSObjectValidator crsObjectValidator = new CRSObjectValidator();
        crsObjectValidator.setClazz(RACVersionGreaterValidator.class);
        MultipleValidationResult multipleValidationResult = crsObjectValidator.validate(params);
        if (this.getFailureResult(multipleValidationResult)) {
            return multipleValidationResult;
        }
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        CRSCluster crs = (CRSCluster)systemInst.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        list.add(crs);
        List racs = crs.getDbRAC();
        String message = null;
        String formattedMsg = "";
        ArrayList<BaseClass> noInstances = new ArrayList<BaseClass>();
        for (RACDatabase rac : racs) {
            if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) continue;
            this.logger.log(Level.INFO, "There are RAC Databases with no instances associated");
            noInstances.add((BaseClass)rac);
        }
        if (!noInstances.isEmpty()) {
            message = BundleUtils.getMessage(RACVersionGreaterValidator.class, "NO_RACINSTANCE", BundleUtils.makeStringOutOfList(noInstances));
            formattedMsg = ValidationUtil.getFormattedMessage(noInstances, message);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_RACINSTANCE, noInstances));
            this.logger.log(Level.INFO, formattedMsg);
            return multipleValidationResult;
        }
        ArrayList<BaseClass> instMissingVersion = new ArrayList<BaseClass>();
        ArrayList<BaseClass> wrongVersion = new ArrayList<BaseClass>();
        for (RACDatabase rac : racs) {
            String verRAC = null;
            if (rac.getProperty(SkipTargetCookie.class) != null) continue;
            for (RACDBInstance instance : rac.getDbInstances()) {
                String verInst = instance.getVersion();
                if (verInst == null) {
                    instMissingVersion.add((BaseClass)instance);
                    continue;
                }
                if (verRAC == null) {
                    verRAC = verInst;
                }
                if (instance.getProperty(SkipTargetCookie.class) == null) continue;
            }
            if (verRAC == null || verRAC.trim().compareToIgnoreCase(this.strMinRACversion) >= 0) continue;
            this.logger.log(Level.INFO, "Given RACs have a version that is not supported");
            wrongVersion.add((BaseClass)rac);
        }
        if (!instMissingVersion.isEmpty()) {
            message = BundleUtils.getMessage(RACVersionGreaterValidator.class, "MISSING_VERSION", BundleUtils.makeStringOutOfList(instMissingVersion));
            formattedMsg = ValidationUtil.getFormattedMessage(instMissingVersion, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMsg);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_VERSION, instMissingVersion));
            return multipleValidationResult;
        }
        if (!wrongVersion.isEmpty()) {
            message = BundleUtils.getMessage(RACVersionGreaterValidator.class, "RAC_VERSION_NOT_SUPPORTED", BundleUtils.makeStringOutOfList(wrongVersion));
            formattedMsg = ValidationUtil.getFormattedMessage(wrongVersion, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMsg);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MISSING_VERSION, instMissingVersion));
            return multipleValidationResult;
        }
        this.logger.log(Level.INFO, "All RACs have a version greater than the minimum required version");
        this.logger.log(Level.INFO, "RAC version is greater or equal to " + this.strMinRACversion);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }

    private boolean getFailureResult(MultipleValidationResult multipleValidationResult) {
        for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
            if (validationResult.getStatus() != ValidationResult.ValidationStatus.FAILED || validationResult.getFailureReason().equals(DBValidationFailureReason.MISSING_VERSION)) continue;
            return true;
        }
        return false;
    }
}

