/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class PatchingExecutionModeValidator
implements IValidator {
    private Logger _logger = Logger.getLogger(PatchingExecutionModeValidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        boolean isRollingMode;
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        ArrayList patchInfoList = (ArrayList)params.get(ValidationParamKey.ANALYZED_PATCHINFO_LIST.ordinal());
        boolean bl = isRollingMode = (Boolean)params.get(ValidationParamKey.NONROLLING_OPTION.ordinal()) == false;
        if (isRollingMode && patchInfoList != null && !patchInfoList.isEmpty()) {
            for (OPatchPatchInfo patchInfo : patchInfoList) {
                if (patchInfo.isRollingPatch()) continue;
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.INVALID_EXECUTION_MODE_FOR_PATCH, patchInfo.getPatchID()));
                break;
            }
        }
        if (multipleValidationResult.isEmpty()) {
            this._logger.info("Patch execution mode validation is successful");
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        }
        return multipleValidationResult;
    }
}

