/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationUtil;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.BaseClass;
import dbmodel.SystemInstance;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomeNotSharedValidator
implements IValidator {
    Logger logger = Logger.getLogger(HomeNotSharedValidator.class.getName());
    String homeType = "crs";
    Map<String, String> descriptionMap = new HashMap<String, String>();

    public HomeNotSharedValidator(String homeType) {
        this.homeType = homeType;
        this.descriptionMap.put("crs", "Grid Infrastructure ");
        this.descriptionMap.put("rac", "RAC Database ");
    }

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Invoking rule to ensure that the homes of the given type are not shared.");
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        String message = null;
        List homes = systemInst.getTargetsOfType(OracleHome.class);
        if (homes == null || homes.isEmpty()) {
            this.logger.log(Level.INFO, "The system instance contains no homes.");
            message = BundleUtils.getMessage(HomeNotSharedValidator.class, "NO_HOMES_IN_SYSTEM_INSTANCE", new Object[0]);
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_HOMES_IN_SYSTEM_INSTANCE, null));
            return multipleValidationResult;
        }
        ArrayList<OracleHome> homesOfGivenType = new ArrayList<OracleHome>();
        for (Object abt : homes) {
            OracleHome oracleHome = (OracleHome)abt;
            if (!oracleHome.getHomeType().equals(this.homeType)) continue;
            this.logger.log(Level.FINEST, "Found home of type " + this.homeType + "  at" + oracleHome.getPath());
            homesOfGivenType.add(oracleHome);
        }
        if (homesOfGivenType == null || homesOfGivenType.isEmpty()) {
            this.logger.log(Level.INFO, "The configuration contains no home of type " + this.homeType);
            message = BundleUtils.getMessage(HomeNotSharedValidator.class, "NO_GIVEN_HOMETYPE_HOMES_IN_SYSTEM_INSTANCE", this.descriptionMap.get(this.homeType));
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_GIVEN_HOMETYPE_HOMES_IN_SYSTEM_INSTANCE, null));
            return multipleValidationResult;
        }
        ArrayList<BaseClass> missingHost = new ArrayList<BaseClass>();
        for (OracleHome oracleHome : homesOfGivenType) {
            List hosts = oracleHome.getHosts();
            if (hosts != null && !hosts.isEmpty()) continue;
            this.logger.log(Level.FINE, "Home at path " + oracleHome.getPath() + " doesn't have the host information set.");
            missingHost.add((BaseClass)oracleHome);
        }
        if (missingHost != null && !missingHost.isEmpty()) {
            message = BundleUtils.getMessage(HomeNotSharedValidator.class, "MISSING_HOST", BundleUtils.makeStringOutOfList(missingHost));
            String formattedMessage = ValidationUtil.getFormattedMessage(missingHost, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, formattedMessage);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.NO_GIVEN_HOMETYPE_HOMES_IN_SYSTEM_INSTANCE, missingHost));
            return multipleValidationResult;
        }
        ArrayList<BaseClass> sharedHome = new ArrayList<BaseClass>();
        for (OracleHome gihome : homesOfGivenType) {
            List hosts = gihome.getHosts();
            if (hosts.size() == 1) continue;
            this.logger.log(Level.FINE, "Home at path " + gihome.getPath() + " is shared.");
            sharedHome.add((BaseClass)gihome);
        }
        if (sharedHome != null && !sharedHome.isEmpty()) {
            this.logger.log(Level.INFO, "One or more homes in this configuration are shared");
            message = BundleUtils.getMessage(HomeNotSharedValidator.class, "HOMES_SHARED", BundleUtils.makeStringOutOfList(sharedHome));
            String string = ValidationUtil.getFormattedMessage(sharedHome, message);
            Reporting.report((String)message);
            this.logger.log(Level.INFO, string);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.HOMES_SHARED, missingHost));
            return multipleValidationResult;
        }
        message = "Ensures that home of the give home type is not shared.";
        this.logger.log(Level.FINE, message);
        multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        return multipleValidationResult;
    }
}

